/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core;

import java.util.Map;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.context.notification.AsyncMessageNotificationListener;
import org.mule.runtime.core.api.context.notification.ClusterNodeNotificationListener;
import org.mule.runtime.core.api.context.notification.ConnectionNotificationListener;
import org.mule.runtime.core.api.context.notification.CustomNotificationListener;
import org.mule.runtime.core.api.context.notification.ExceptionNotificationListener;
import org.mule.runtime.core.api.context.notification.ManagementNotificationListener;
import org.mule.runtime.core.api.context.notification.MuleContextNotificationListener;
import org.mule.runtime.core.api.context.notification.PipelineMessageNotificationListener;
import org.mule.runtime.core.api.context.notification.RegistryNotificationListener;
import org.mule.runtime.core.api.context.notification.RoutingNotificationListener;
import org.mule.runtime.core.api.context.notification.SecurityNotificationListener;
import org.mule.runtime.core.api.context.notification.TransactionNotificationListener;
import org.mule.runtime.core.api.lifecycle.LifecycleManager;
import org.mule.runtime.core.config.DefaultMuleConfiguration;
import org.mule.runtime.core.context.DefaultMuleContextBuilder;
import org.mule.runtime.core.context.notification.AsyncMessageNotification;
import org.mule.runtime.core.context.notification.ClusterNodeNotification;
import org.mule.runtime.core.context.notification.ConnectionNotification;
import org.mule.runtime.core.context.notification.CustomNotification;
import org.mule.runtime.core.context.notification.ExceptionNotification;
import org.mule.runtime.core.context.notification.ManagementNotification;
import org.mule.runtime.core.context.notification.MuleContextNotification;
import org.mule.runtime.core.context.notification.PipelineMessageNotification;
import org.mule.runtime.core.context.notification.RegistryNotification;
import org.mule.runtime.core.context.notification.RoutingNotification;
import org.mule.runtime.core.context.notification.SecurityNotification;
import org.mule.runtime.core.context.notification.ServerNotificationManager;
import org.mule.runtime.core.context.notification.TransactionNotification;
import org.mule.runtime.core.lifecycle.MuleContextLifecycleManager;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class DefaultMuleContextBuilderTestCase
extends AbstractMuleTestCase {
    @Test
    public void testBuildMuleContextDefault() {
        DefaultMuleContextBuilder builder = new DefaultMuleContextBuilder();
        MuleContext muleContext = builder.buildMuleContext();
        Assert.assertThat((Object)muleContext, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)muleContext.getConfiguration(), (Matcher)CoreMatchers.instanceOf(DefaultMuleConfiguration.class));
        Assert.assertThat((Object)muleContext.getLifecycleManager(), (Matcher)CoreMatchers.instanceOf(MuleContextLifecycleManager.class));
        Assert.assertThat((Object)muleContext.getNotificationManager(), (Matcher)CoreMatchers.instanceOf(ServerNotificationManager.class));
    }

    @Test
    public void testBuildMuleContextCustom() {
        MuleContext muleContext = this.build();
        Assert.assertThat((Object)muleContext, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)muleContext.getConfiguration(), (Matcher)CoreMatchers.instanceOf(MyMuleConfiguration.class));
        Assert.assertThat((Object)muleContext.getLifecycleManager(), (Matcher)CoreMatchers.instanceOf(MyLifeCycleManager.class));
        Assert.assertThat((Object)muleContext.getNotificationManager(), (Matcher)CoreMatchers.instanceOf(MyServerNotificationManager.class));
    }

    @Test
    public void notificationManagerContainsTheCorrectInterfaces() {
        DefaultMuleContextBuilder builder = new DefaultMuleContextBuilder();
        builder.setMuleConfiguration((MuleConfiguration)new MyMuleConfiguration());
        builder.setLifecycleManager((LifecycleManager)new MyLifeCycleManager());
        MuleContext muleContext = builder.buildMuleContext();
        Map interfaces = muleContext.getNotificationManager().getInterfaceToTypes();
        Assert.assertEquals(MuleContextNotification.class, (Object)((Set)interfaces.get(MuleContextNotificationListener.class)).toArray()[0]);
        Assert.assertEquals(RoutingNotification.class, (Object)((Set)interfaces.get(RoutingNotificationListener.class)).toArray()[0]);
        Assert.assertEquals(SecurityNotification.class, (Object)((Set)interfaces.get(SecurityNotificationListener.class)).toArray()[0]);
        Assert.assertEquals(ManagementNotification.class, (Object)((Set)interfaces.get(ManagementNotificationListener.class)).toArray()[0]);
        Assert.assertEquals(CustomNotification.class, (Object)((Set)interfaces.get(CustomNotificationListener.class)).toArray()[0]);
        Assert.assertEquals(ConnectionNotification.class, (Object)((Set)interfaces.get(ConnectionNotificationListener.class)).toArray()[0]);
        Assert.assertEquals(RegistryNotification.class, (Object)((Set)interfaces.get(RegistryNotificationListener.class)).toArray()[0]);
        Assert.assertEquals(ExceptionNotification.class, (Object)((Set)interfaces.get(ExceptionNotificationListener.class)).toArray()[0]);
        Assert.assertEquals(TransactionNotification.class, (Object)((Set)interfaces.get(TransactionNotificationListener.class)).toArray()[0]);
        Assert.assertEquals(PipelineMessageNotification.class, (Object)((Set)interfaces.get(PipelineMessageNotificationListener.class)).toArray()[0]);
        Assert.assertEquals(AsyncMessageNotification.class, (Object)((Set)interfaces.get(AsyncMessageNotificationListener.class)).toArray()[0]);
        Assert.assertEquals(ClusterNodeNotification.class, (Object)((Set)interfaces.get(ClusterNodeNotificationListener.class)).toArray()[0]);
    }

    private MuleContext build() {
        DefaultMuleContextBuilder builder = new DefaultMuleContextBuilder();
        builder.setMuleConfiguration((MuleConfiguration)new MyMuleConfiguration());
        builder.setLifecycleManager((LifecycleManager)new MyLifeCycleManager());
        builder.setNotificationManager((ServerNotificationManager)new MyServerNotificationManager());
        return builder.buildMuleContext();
    }

    protected MuleContext createMuleContext() throws Exception {
        return null;
    }

    static class MyServerNotificationManager
    extends ServerNotificationManager {
        MyServerNotificationManager() {
        }
    }

    static class MyMuleConfiguration
    extends DefaultMuleConfiguration {
        MyMuleConfiguration() {
        }
    }

    static class MyLifeCycleManager
    extends MuleContextLifecycleManager {
        MyLifeCycleManager() {
        }
    }
}

