/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.DefaultMuleContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.context.MuleContextBuilder;
import org.mule.runtime.core.api.context.notification.MuleContextListener;
import org.mule.runtime.core.config.DefaultMuleConfiguration;
import org.mule.runtime.core.config.builders.AbstractConfigurationBuilder;
import org.mule.runtime.core.config.builders.DefaultsConfigurationBuilder;
import org.mule.runtime.core.config.builders.SimpleConfigurationBuilder;
import org.mule.runtime.core.context.DefaultMuleContextBuilder;
import org.mule.runtime.core.context.DefaultMuleContextFactory;
import org.mule.tck.config.TestServicesConfigurationBuilder;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.testmodels.fruit.Banana;

public class DefaultMuleContextFactoryTestCase
extends AbstractMuleTestCase {
    @Rule
    public TestServicesConfigurationBuilder testServicesConfigurationBuilder = new TestServicesConfigurationBuilder();
    private DefaultMuleContextFactory muleContextFactory = new DefaultMuleContextFactory();
    private static String TEST_STRING_KEY = "test";
    private static String TEST_STRING_VALUE = "test_value";
    private static String TEST_STRING_KEY2 = "test2";
    private static String TEST_STRING_VALUE2 = "test_value2";
    private static String TEST_OBJECT_NAME = "testObject";
    private MuleContext context;

    @After
    public void disposeContext() {
        if (this.context != null && !this.context.isDisposed()) {
            this.context.dispose();
        }
    }

    @Test
    public void testCreateMuleContext() throws InitialisationException, ConfigurationException {
        this.context = this.muleContextFactory.createMuleContext(new ConfigurationBuilder[]{this.testServicesConfigurationBuilder, new DefaultsConfigurationBuilder()});
        this.assertMuleContextConfiguration(this.context);
        this.assertDefaults(this.context);
    }

    @Test
    public void testCreateMuleContextConfigurationBuilder() throws InitialisationException, ConfigurationException {
        this.context = this.muleContextFactory.createMuleContext(new ConfigurationBuilder[]{this.testServicesConfigurationBuilder, new TestConfigurationBuilder()});
        this.assertMuleContextConfiguration(this.context);
        this.assertConfigurationBuilder1Objects(this.context);
        this.assertNoDefaults(this.context);
    }

    @Test
    public void testCreateMuleContextListMuleContextBuilder() throws InitialisationException, ConfigurationException {
        ArrayList<Object> configBuilders = new ArrayList<Object>();
        configBuilders.add(this.testServicesConfigurationBuilder);
        configBuilders.add((Object)new TestConfigurationBuilder());
        configBuilders.add((Object)new TestConfigurationBuilder2());
        TestMuleContextBuilder muleContextBuilder = new TestMuleContextBuilder();
        this.context = this.muleContextFactory.createMuleContext(configBuilders, (MuleContextBuilder)muleContextBuilder);
        this.assertCustomMuleContext(this.context);
        this.assertConfigurationBuilder1Objects(this.context);
        this.assertConfigurationBuilder2Objects(this.context);
        this.assertNoDefaults(this.context);
    }

    @Test
    public void testCreateMuleContextMuleContextBuilder() throws InitialisationException, ConfigurationException {
        TestMuleContextBuilder muleContextBuilder = new TestMuleContextBuilder();
        this.context = this.muleContextFactory.createMuleContext(Arrays.asList(this.testServicesConfigurationBuilder, new SimpleConfigurationBuilder(null)), (MuleContextBuilder)muleContextBuilder);
        this.assertCustomMuleContext(this.context);
        this.assertNoDefaults(this.context);
    }

    @Test
    public void testCreateMuleContextConfigurationBuilderMuleContextBuilder() throws InitialisationException, ConfigurationException {
        TestMuleContextBuilder muleContextBuilder = new TestMuleContextBuilder();
        this.context = this.muleContextFactory.createMuleContext(Arrays.asList(new ConfigurationBuilder[]{this.testServicesConfigurationBuilder, new TestConfigurationBuilder2()}), (MuleContextBuilder)muleContextBuilder);
        this.assertCustomMuleContext(this.context);
        this.assertConfigurationBuilder2Objects(this.context);
        this.assertNoDefaults(this.context);
    }

    @Test
    public void testCreateMuleContextString() throws InitialisationException, ConfigurationException {
        this.context = null;
        try {
            this.context = this.muleContextFactory.createMuleContext("log4j2-test.xml");
        }
        catch (ConfigurationException e) {
            Assert.assertEquals((Object)"No suitable configuration builder for resource \"[ConfigResource{resourceName='log4j2-test.xml'}]\" found.  Check you have configuration module on your classpath and are using correct file extension. (org.mule.runtime.core.api.config.ConfigurationException)", (Object)e.getMessage());
        }
        Assert.assertNull((Object)this.context);
    }

    @Test
    public void testCreateMuleContextStringProperties() throws InitialisationException, ConfigurationException {
        Properties properties = new Properties();
        properties.put("testKey1", "testValue1");
        properties.put("testKey2", "testValue2");
        this.context = null;
        try {
            this.context = this.muleContextFactory.createMuleContext("log4j2-test.xml", properties);
        }
        catch (ConfigurationException e) {
            Assert.assertEquals((Object)"No suitable configuration builder for resource \"[ConfigResource{resourceName='log4j2-test.xml'}]\" found.  Check you have configuration module on your classpath and are using correct file extension. (org.mule.runtime.core.api.config.ConfigurationException)", (Object)e.getMessage());
        }
        Assert.assertNull((Object)this.context);
    }

    @Test
    public void testCreateMuleContextConfigurationBuilderProperties() throws InitialisationException, ConfigurationException {
        Properties properties = new Properties();
        properties.put("testKey3", "testValue3");
        properties.put("testKey4", "testValue4");
        this.context = this.muleContextFactory.createMuleContext(Arrays.asList(new ConfigurationBuilder[]{this.testServicesConfigurationBuilder, new TestConfigurationBuilder()}), properties);
        this.assertMuleContextConfiguration(this.context);
        this.assertConfigurationBuilder1Objects(this.context);
        Assert.assertEquals((Object)"testValue3", (Object)this.context.getRegistry().lookupObject("testKey3"));
        Assert.assertEquals((Object)"testValue4", (Object)this.context.getRegistry().lookupObject("testKey4"));
        this.assertNoDefaults(this.context);
    }

    @Test
    public void notifiesMuleContextEvents() throws InitialisationException, ConfigurationException {
        MuleContextListener listener = (MuleContextListener)Mockito.mock(MuleContextListener.class);
        ConfigurationBuilder configurationBuilder = (ConfigurationBuilder)Mockito.mock(ConfigurationBuilder.class);
        this.context = (MuleContext)Mockito.mock(MuleContext.class);
        MuleContextBuilder contextBuilder = (MuleContextBuilder)Mockito.mock(MuleContextBuilder.class);
        Mockito.when((Object)contextBuilder.buildMuleContext()).thenReturn((Object)this.context);
        this.muleContextFactory.addListener(listener);
        this.muleContextFactory.createMuleContext(configurationBuilder, contextBuilder);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{listener});
        ((MuleContextListener)inOrder.verify((Object)listener, Mockito.times((int)1))).onCreation(this.context);
        ((MuleContextListener)inOrder.verify((Object)listener, Mockito.times((int)1))).onConfiguration(this.context);
        ((MuleContextListener)inOrder.verify((Object)listener, Mockito.times((int)1))).onInitialization(this.context);
    }

    private void assertDefaults(MuleContext context) {
        junit.framework.Assert.assertNotNull((Object)context.getRegistry().lookupObject("_muleQueueManager"));
        junit.framework.Assert.assertNotNull((Object)context.getRegistry().lookupObject("_muleSecurityManager"));
        junit.framework.Assert.assertNotNull((Object)context.getRegistry().lookupObject("_defaultInMemoryObjectStore"));
    }

    private void assertNoDefaults(MuleContext context) {
        Assert.assertNull((Object)context.getRegistry().lookupObject("_muleQueueManager"));
        Assert.assertNull((Object)context.getRegistry().lookupObject("_muleSecurityManager"));
        Assert.assertNull((Object)context.getRegistry().lookupObject("_defaultInMemoryObjectStore"));
        Assert.assertNull((Object)context.getRegistry().lookupObject("_muleSimpleRegistryBootstrap"));
    }

    private void assertMuleContextConfiguration(MuleContext context) {
        Assert.assertThat((Object)context, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)context, (Matcher)CoreMatchers.instanceOf(DefaultMuleContext.class));
        Assert.assertTrue((boolean)context.isInitialised());
        Assert.assertThat((Object)context.getConfiguration(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)context.getConfiguration(), (Matcher)CoreMatchers.instanceOf(DefaultMuleConfiguration.class));
        Assert.assertThat((Object)context.getLifecycleManager(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)context.getNotificationManager(), (Matcher)CoreMatchers.notNullValue());
    }

    private void assertCustomMuleContext(MuleContext context) {
        Assert.assertThat((Object)context, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)context, (Matcher)CoreMatchers.instanceOf(TestMuleContext.class));
        Assert.assertTrue((boolean)context.isInitialised());
        Assert.assertThat((Object)context.getConfiguration(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)context.getLifecycleManager(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)context.getNotificationManager(), (Matcher)CoreMatchers.notNullValue());
    }

    private void assertConfigurationBuilder1Objects(MuleContext context) {
        Assert.assertEquals((Object)TEST_STRING_VALUE, (Object)context.getRegistry().lookupObject(TEST_STRING_KEY));
        Object obj = context.getRegistry().lookupObject(TEST_OBJECT_NAME);
        junit.framework.Assert.assertNotNull((Object)obj);
        Assert.assertEquals(Banana.class, obj.getClass());
    }

    private void assertConfigurationBuilder2Objects(MuleContext context) {
        Assert.assertEquals((Object)TEST_STRING_VALUE2, (Object)context.getRegistry().lookupObject(TEST_STRING_KEY2));
    }

    static class TestMuleConfiguration
    extends DefaultMuleConfiguration {
        TestMuleConfiguration() {
        }
    }

    static class TestMuleContext
    extends DefaultMuleContext {
    }

    static class TestMuleContextBuilder
    extends DefaultMuleContextBuilder {
        TestMuleContextBuilder() {
        }

        protected DefaultMuleContext createDefaultMuleContext() {
            return new TestMuleContext();
        }
    }

    static class TestConfigurationBuilder2
    extends AbstractConfigurationBuilder {
        TestConfigurationBuilder2() {
        }

        protected void doConfigure(MuleContext context) throws Exception {
            context.getRegistry().registerObject(TEST_STRING_KEY2, (Object)TEST_STRING_VALUE2);
        }
    }

    static class TestConfigurationBuilder
    extends AbstractConfigurationBuilder {
        TestConfigurationBuilder() {
        }

        protected void doConfigure(MuleContext context) throws Exception {
            context.getRegistry().registerObject(TEST_STRING_KEY, (Object)TEST_STRING_VALUE);
            context.getRegistry().registerObject(TEST_OBJECT_NAME, (Object)new Banana());
        }
    }
}

