/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.junit4.matcher.DataTypeMatcher;
import org.mule.tck.size.SmallTest;

@SmallTest
public class DefaultMuleEventTestCase
extends AbstractMuleContextTestCase {
    @Rule
    public ExpectedException expected = ExpectedException.none();
    public static final Charset CUSTOM_ENCODING = StandardCharsets.UTF_8;
    public static final String PROPERTY_NAME = "test";
    public static final String PROPERTY_VALUE = "foo";
    private Message muleMessage = Message.of((Object)"test-data");
    private Flow flow;
    private EventContext messageContext;
    private Event muleEvent;

    @Before
    public void before() throws Exception {
        this.flow = MuleTestUtils.getTestFlow((MuleContext)muleContext);
        this.messageContext = DefaultEventContext.create((FlowConstruct)this.flow, (ComponentLocation)TEST_CONNECTOR_LOCATION);
        this.muleEvent = Event.builder((EventContext)this.messageContext).message(this.muleMessage).flow((FlowConstruct)this.flow).build();
    }

    @Test
    public void setFlowVariableDefaultDataType() throws Exception {
        this.muleEvent = Event.builder((Event)this.muleEvent).addVariable(PROPERTY_NAME, (Object)PROPERTY_VALUE).build();
        DataType dataType = this.muleEvent.getVariable(PROPERTY_NAME).getDataType();
        MatcherAssert.assertThat((Object)dataType, (Matcher)DataTypeMatcher.like(String.class, (MediaType)MediaType.ANY, null));
    }

    @Test
    public void setFlowVariableCustomDataType() throws Exception {
        DataType dataType = DataType.builder().type(String.class).mediaType(MediaType.APPLICATION_XML).charset(CUSTOM_ENCODING).build();
        this.muleEvent = Event.builder((Event)this.muleEvent).addVariable(PROPERTY_NAME, (Object)PROPERTY_VALUE, dataType).build();
        DataType actualDataType = this.muleEvent.getVariable(PROPERTY_NAME).getDataType();
        MatcherAssert.assertThat((Object)actualDataType, (Matcher)DataTypeMatcher.like(String.class, (MediaType)MediaType.APPLICATION_XML, (Charset)CUSTOM_ENCODING));
    }

    @Test
    public void setSessionVariableDefaultDataType() throws Exception {
        this.muleEvent.getSession().setProperty(PROPERTY_NAME, (Serializable)((Object)PROPERTY_VALUE));
        DataType dataType = this.muleEvent.getSession().getPropertyDataType(PROPERTY_NAME);
        MatcherAssert.assertThat((Object)dataType, (Matcher)DataTypeMatcher.like(String.class, (MediaType)MediaType.ANY, null));
    }

    @Test
    public void setSessionVariableCustomDataType() throws Exception {
        DataType dataType = DataType.builder().type(String.class).mediaType(MediaType.APPLICATION_XML).charset(CUSTOM_ENCODING).build();
        this.muleEvent.getSession().setProperty(PROPERTY_NAME, (Serializable)((Object)PROPERTY_VALUE), dataType);
        DataType actualDataType = this.muleEvent.getSession().getPropertyDataType(PROPERTY_NAME);
        MatcherAssert.assertThat((Object)actualDataType, (Matcher)DataTypeMatcher.like(String.class, (MediaType)MediaType.APPLICATION_XML, (Charset)CUSTOM_ENCODING));
    }

    @Test
    public void setNullMessage() throws Exception {
        this.expected.expect(NullPointerException.class);
        Event.builder((EventContext)this.messageContext).message(null);
    }

    @Test
    public void dontSetMessage() throws Exception {
        this.expected.expect(NullPointerException.class);
        this.muleEvent = Event.builder((EventContext)this.messageContext).build();
    }
}

