/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.collection.IsEmptyCollection;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.message.Attributes;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.message.NullAttributes;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Orange;

public class DefaultMuleMessageTestCase
extends AbstractMuleContextTestCase {
    public static final String FOO_PROPERTY = "foo";
    private Attributes testAttributes = NullAttributes.NULL_ATTRIBUTES;

    @Test
    public void testMessagePropertiesAccessors() {
        Map<String, Serializable> properties = this.createMessageProperties();
        properties.put("number", (Serializable)((Object)"24"));
        properties.put("decimal", (Serializable)((Object)"24.3"));
        properties.put("boolean", (Serializable)((Object)"true"));
        Apple apple = new Apple(true);
        properties.put("apple", (Serializable)apple);
        InternalMessage message = InternalMessage.builder().payload((Object)"Test Message").outboundProperties(properties).build();
        Assert.assertTrue((boolean)((Boolean)message.getOutboundProperty("boolean", (Serializable)Boolean.valueOf(false))));
        Assert.assertEquals((Object)new Integer(24), (Object)message.getOutboundProperty("number", (Serializable)Integer.valueOf(0)));
        Assert.assertEquals((Object)new Byte(24), (Object)message.getOutboundProperty("number", (Serializable)Byte.valueOf((byte)0)));
        Assert.assertEquals((Object)new Long(24L), (Object)message.getOutboundProperty("number", (Serializable)Long.valueOf(0L)));
        Assert.assertEquals((Object)new Float(24.3), (Object)message.getOutboundProperty("decimal", (Serializable)Float.valueOf(0.0f)));
        Double d = (Double)message.getOutboundProperty("decimal", (Serializable)Double.valueOf(0.0));
        Assert.assertEquals((Object)new Double(24.3), (Object)d);
        Assert.assertEquals((Object)"true", (Object)message.getOutboundProperty("boolean", (Serializable)((Object)"")));
        Assert.assertEquals((Object)apple, (Object)message.getOutboundProperty("apple"));
        try {
            message.getOutboundProperty("apple", (Serializable)new Orange());
            Assert.fail((String)"Orange is not assignable to Apple");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertNull((Object)message.getOutboundProperty("banana"));
        Assert.assertNull((Object)message.getOutboundProperty("blah"));
        Assert.assertEquals((Object)new Float(24.3), (Object)message.getOutboundProperty("blah", (Serializable)Float.valueOf(24.3f)));
    }

    @Test
    public void testClearProperties() {
        InternalMessage payload = InternalMessage.builder((Message)this.createMuleMessage()).addOutboundProperty(FOO_PROPERTY, (Serializable)((Object)"fooValue")).build();
        MatcherAssert.assertThat((Object)payload.getOutboundPropertyNames(), (Matcher)IsCollectionWithSize.hasSize((int)2));
        MatcherAssert.assertThat((Object)payload.getInboundPropertyNames(), (Matcher)IsEmptyCollection.empty());
        payload = InternalMessage.builder((Message)payload).outboundProperties(Collections.emptyMap()).build();
        MatcherAssert.assertThat((Object)payload.getOutboundPropertyNames(), (Matcher)IsEmptyCollection.empty());
    }

    private Map<String, Serializable> createMessageProperties() {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("MessageProperties", (Serializable)((Object)"MessageProperties"));
        return map;
    }

    private Message createMuleMessage() {
        return InternalMessage.builder().payload((Object)"test").attributes((Object)this.testAttributes).addOutboundProperty("Message", (Serializable)((Object)"Message")).build();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testPropertyNamesImmutable() throws Exception {
        InternalMessage message = (InternalMessage)this.createMuleMessage();
        message.getOutboundPropertyNames().add("other");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testInboundPropertyNamesAddImmutable() throws Exception {
        InternalMessage message = (InternalMessage)this.createMuleMessage();
        message.getOutboundPropertyNames().add("other");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testOutboundPropertyNamesImmutable() throws Exception {
        Message message = this.createMuleMessage();
        ((InternalMessage)message).getOutboundPropertyNames().add("other");
    }

    @Test
    public void usesNullPayloadAsNull() throws Exception {
        InternalMessage message = InternalMessage.builder((Message)this.createMuleMessage()).addOutboundProperty(FOO_PROPERTY, null).build();
        MatcherAssert.assertThat((Object)message.getOutboundProperty(FOO_PROPERTY), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }
}

