/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.registry.MuleRegistry;
import org.mule.runtime.core.api.transformer.Converter;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.internal.transformer.DynamicDataTypeConversionResolver;
import org.mule.runtime.core.transformer.builder.MockConverterBuilder;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class DynamicDataTypeConverterResolverTestCase
extends AbstractMuleTestCase {
    private MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class);
    private MuleRegistry muleRegistry = (MuleRegistry)Mockito.mock(MuleRegistry.class);

    @Test
    public void doesNotFailWhenThereIsNoDataTypeResolution() throws TransformerException {
        Mockito.when((Object)this.muleContext.getRegistry()).thenReturn((Object)this.muleRegistry);
        Mockito.when((Object)this.muleRegistry.lookupTransformer((DataType)Mockito.any(DataType.class), (DataType)Mockito.any(DataType.class))).thenReturn(null);
        DynamicDataTypeConversionResolver resolver = new DynamicDataTypeConversionResolver(this.muleContext);
        ArrayList<DataType> targetTypes = new ArrayList<DataType>();
        targetTypes.add(DataType.STRING);
        Transformer resolvedConverter = resolver.resolve(DataType.INPUT_STREAM, targetTypes);
        Assert.assertEquals(null, (Object)resolvedConverter);
    }

    @Test
    public void findsExpectedConverter() throws TransformerException {
        Converter expectedConverter = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(DataType.BYTE_ARRAY)).to(DataType.STRING)).build();
        Mockito.when((Object)this.muleContext.getRegistry()).thenReturn((Object)this.muleRegistry);
        Mockito.when((Object)this.muleRegistry.lookupTransformer(DataType.BYTE_ARRAY, DataType.STRING)).thenReturn((Object)expectedConverter);
        DynamicDataTypeConversionResolver resolver = new DynamicDataTypeConversionResolver(this.muleContext);
        ArrayList<DataType> targetTypes = new ArrayList<DataType>();
        targetTypes.add(DataType.INPUT_STREAM);
        targetTypes.add(DataType.STRING);
        Transformer resolvedConverter = resolver.resolve(DataType.BYTE_ARRAY, targetTypes);
        Assert.assertEquals((Object)expectedConverter, (Object)resolvedConverter);
    }
}

