/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core;

import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.construct.Pipeline;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.internal.util.SerializationUtils;
import org.mule.runtime.core.transformer.AbstractTransformer;
import org.mule.runtime.core.transformer.simple.ByteArrayToObject;
import org.mule.runtime.core.transformer.simple.SerializableToByteArray;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class MuleEventTestCase
extends AbstractMuleContextTestCase {
    private static String TIMEOUT_ILLEGAL_ARGUMENT_EXCEPTION_MESSAGE = "Timeout on Mono blocking read";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testEventSerialization() throws Exception {
        Event.setCurrentEvent((Event)this.testEvent());
        Transformer transformer = this.createSerializableToByteArrayTransformer();
        transformer.setMuleContext(muleContext);
        Serializable serialized = (Serializable)this.createSerializableToByteArrayTransformer().transform((Object)this.testEvent());
        Assert.assertNotNull((Object)serialized);
        ByteArrayToObject trans = new ByteArrayToObject();
        trans.setMuleContext(muleContext);
        Event deserialized = (Event)trans.transform((Object)serialized);
        Assert.assertNotNull((Object)deserialized);
        Assert.assertNotNull((Object)deserialized.getSession());
    }

    private Transformer createSerializableToByteArrayTransformer() {
        SerializableToByteArray transformer = new SerializableToByteArray();
        transformer.setMuleContext(muleContext);
        return transformer;
    }

    @Test
    public void testEventSerializationRestart() throws Exception {
        Event event = this.createEventToSerialize();
        Serializable serialized = (Serializable)this.createSerializableToByteArrayTransformer().transform((Object)event);
        Assert.assertNotNull((Object)serialized);
        muleContext.dispose();
        muleContext = this.createMuleContext();
        muleContext.start();
        ByteArrayToObject trans = new ByteArrayToObject();
        trans.setMuleContext(muleContext);
        this.createAndRegisterTransformersEndpointBuilderService();
        Event deserialized = (Event)trans.transform((Object)serialized);
        Assert.assertNotNull((Object)deserialized);
        Assert.assertNotNull((Object)deserialized.getSession());
    }

    private Event createEventToSerialize() throws Exception {
        this.createAndRegisterTransformersEndpointBuilderService();
        return this.testEvent();
    }

    @Test
    public void testMuleEventSerializationWithRawPayload() throws Exception {
        StringBuilder payload = new StringBuilder();
        for (int i = 0; i < 108; ++i) {
            payload.append("1234567890");
        }
        Event testEvent = MuleEventTestCase.eventBuilder().message(Message.of((Object)new ByteArrayInputStream(payload.toString().getBytes()))).build();
        Event.setCurrentEvent((Event)testEvent);
        byte[] serializedEvent = muleContext.getObjectSerializer().getExternalProtocol().serialize((Object)testEvent);
        testEvent = (Event)muleContext.getObjectSerializer().getExternalProtocol().deserialize(serializedEvent);
        Assert.assertArrayEquals((byte[])((byte[])testEvent.getMessage().getPayload().getValue()), (byte[])payload.toString().getBytes());
    }

    private void createAndRegisterTransformersEndpointBuilderService() throws Exception {
        TestEventTransformer trans1 = new TestEventTransformer();
        trans1.setName("OptimusPrime");
        muleContext.getRegistry().registerTransformer((Transformer)trans1);
        TestEventTransformer trans2 = new TestEventTransformer();
        trans2.setName("Bumblebee");
        muleContext.getRegistry().registerTransformer((Transformer)trans2);
        ArrayList<TestEventTransformer> transformers = new ArrayList<TestEventTransformer>();
        transformers.add(trans1);
        transformers.add(trans2);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testFlowVarNamesAddImmutable() throws Exception {
        Event event = MuleEventTestCase.eventBuilder().message(Message.of((Object)"whatever")).addVariable("test", (Object)"val").build();
        event.getVariableNames().add("other");
    }

    public void testFlowVarNamesRemoveMutable() throws Exception {
        Event event = MuleEventTestCase.eventBuilder().message(Message.of((Object)"whatever")).addVariable("test", (Object)"val").build();
        event = Event.builder((Event)event).addVariable("test", (Object)"val").build();
        event.getVariableNames().remove("test");
        Assert.assertNull((Object)event.getVariable("test").getValue());
    }

    @Test
    public void testFlowVarsNotShared() throws Exception {
        Event event = MuleEventTestCase.eventBuilder().message(Message.of((Object)"whatever")).addVariable("foo", (Object)"bar").build();
        event = Event.builder((Event)event).addVariable("foo", (Object)"bar").build();
        Event copy = Event.builder((Event)event).build();
        copy = Event.builder((Event)copy).addVariable("foo", (Object)"bar2").build();
        Assert.assertEquals((Object)"bar", (Object)event.getVariable("foo").getValue());
        Assert.assertEquals((Object)"bar2", (Object)copy.getVariable("foo").getValue());
    }

    @Test(expected=NoSuchElementException.class)
    public void testGetFlowVarNonexistent() throws Exception {
        this.testEvent().getVariable("foo").getValue();
    }

    @Test(expected=NoSuchElementException.class)
    public void testGetFlowVarDataTypeNonexistent() throws Exception {
        this.testEvent().getVariable("foo").getDataType();
    }

    @Test
    public void eventContextSerializationNoPipelinePublisherLost() throws Exception {
        Event result = this.testEvent();
        Event before = this.testEvent();
        Event after = (Event)SerializationUtils.deserialize((byte[])org.apache.commons.lang.SerializationUtils.serialize((Serializable)before), (MuleContext)muleContext);
        after.getContext().success(result);
        Assert.assertThat((Object)before.getContext().getId(), (Matcher)CoreMatchers.equalTo((Object)after.getContext().getId()));
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage(CoreMatchers.startsWith((String)TIMEOUT_ILLEGAL_ARGUMENT_EXCEPTION_MESSAGE));
        Mono.from((Publisher)before.getContext().getResponsePublisher()).block(Duration.ofMillis(500L));
    }

    @Test
    public void eventContextSerializationEventContextGarbageCollected() throws Exception {
        Flow flow = MuleTestUtils.getTestFlow((MuleContext)muleContext);
        Event before = MuleEventTestCase.eventBuilder().message(Message.of(null)).flow((FlowConstruct)flow).build();
        String beforeId = before.getContext().getId();
        byte[] bytes = org.apache.commons.lang.SerializationUtils.serialize((Serializable)before);
        before = null;
        System.gc();
        Assert.assertThat(flow.getSerializationEventContextCache().get(beforeId), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void eventContextSerializationPublisherConserved() throws Exception {
        Event result = this.testEvent();
        Event before = MuleEventTestCase.eventBuilder().message(Message.of(null)).flow((FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext)).build();
        Event after = (Event)SerializationUtils.deserialize((byte[])org.apache.commons.lang.SerializationUtils.serialize((Serializable)before), (MuleContext)muleContext);
        after.getContext().success(result);
        Assert.assertThat((Object)before.getContext().getId(), (Matcher)CoreMatchers.equalTo((Object)after.getContext().getId()));
        Assert.assertThat((Object)Mono.from((Publisher)before.getContext().getResponsePublisher()).block(), (Matcher)CoreMatchers.equalTo((Object)result));
        Assert.assertThat(((Pipeline)before.getFlowConstruct()).getSerializationEventContextCache().get(before.getContext().getId()), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    private static class TestEventTransformer
    extends AbstractTransformer {
        private TestEventTransformer() {
        }

        public Object doTransform(Object src, Charset encoding) throws TransformerException {
            return "Transformed Test Data";
        }
    }
}

