/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.TransformationService;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class TransformationServiceNullTransformationTestCase
extends AbstractMuleTestCase {
    @Test
    public void transformerIsNeverCalledWithANullValue() throws MuleException {
        MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class);
        MuleConfiguration muleConfiguration = (MuleConfiguration)Mockito.mock(MuleConfiguration.class);
        Mockito.when((Object)muleContext.getConfiguration()).thenReturn((Object)muleConfiguration);
        TransformationService transformationService = new TransformationService(muleContext);
        Transformer transformer1 = (Transformer)Mockito.mock(Transformer.class);
        Mockito.when((Object)transformer1.transform(Matchers.any(Object.class))).thenReturn(null);
        Mockito.when((Object)transformer1.isSourceDataTypeSupported((DataType)Matchers.any(DataType.class))).thenReturn((Object)true);
        Mockito.when((Object)transformer1.getReturnDataType()).thenReturn((Object)DataType.OBJECT);
        Transformer transformer2 = (Transformer)Mockito.mock(Transformer.class);
        Mockito.when((Object)transformer2.transform(Matchers.any(Object.class))).thenReturn((Object)"foo");
        Mockito.when((Object)transformer2.isSourceDataTypeSupported((DataType)Matchers.any(DataType.class))).thenReturn((Object)true);
        Mockito.when((Object)transformer2.getReturnDataType()).thenReturn((Object)DataType.OBJECT);
        Message message = transformationService.applyTransformers(Message.of((Object)""), null, new Transformer[]{transformer1, transformer2});
        Assert.assertEquals((Object)"foo", (Object)message.getPayload().getValue());
        ((Transformer)Mockito.verify((Object)transformer1, (VerificationMode)Mockito.never())).transform(null);
        ((Transformer)Mockito.verify((Object)transformer1, (VerificationMode)Mockito.never())).isAcceptNull();
        ((Transformer)Mockito.verify((Object)transformer2, (VerificationMode)Mockito.never())).transform(null);
        ((Transformer)Mockito.verify((Object)transformer2, (VerificationMode)Mockito.never())).isAcceptNull();
    }
}

