/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.agent.registry;

import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.transformer.builder.MockConverterBuilder;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.fruit.BloodOrange;
import org.mule.tck.testmodels.fruit.Fruit;
import org.mule.tck.testmodels.fruit.Orange;

public class MuleRegistryHelperTestCase
extends AbstractMuleContextTestCase {
    private static final DataType ORANGE_DATA_TYPE = DataType.fromType(Orange.class);
    private static final DataType BLOOD_ORANGE_DATA_TYPE = DataType.fromType(BloodOrange.class);
    private static final DataType FRUIT_DATA_TYPE = DataType.fromType(Fruit.class);
    private Transformer t1;
    private Transformer t2;

    @Before
    public void setUp() throws Exception {
        this.t1 = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("t1")).from(ORANGE_DATA_TYPE)).to(FRUIT_DATA_TYPE)).build();
        muleContext.getRegistry().registerTransformer(this.t1);
        this.t2 = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("t2")).from(DataType.OBJECT)).to(FRUIT_DATA_TYPE)).build();
        muleContext.getRegistry().registerTransformer(this.t2);
    }

    @Test
    public void lookupsTransformersByType() throws Exception {
        List trans = muleContext.getRegistry().lookupTransformers(BLOOD_ORANGE_DATA_TYPE, FRUIT_DATA_TYPE);
        Assert.assertEquals((long)2L, (long)trans.size());
        Assert.assertTrue((boolean)trans.contains(this.t1));
        Assert.assertTrue((boolean)trans.contains(this.t2));
    }

    @Test
    public void lookupsTransformerByPriority() throws Exception {
        Transformer result = muleContext.getRegistry().lookupTransformer(BLOOD_ORANGE_DATA_TYPE, FRUIT_DATA_TYPE);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)this.t1, (Object)result);
    }
}

