/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.agent.registry;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.registry.TransformerResolver;
import org.mule.runtime.core.api.transformer.Converter;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.registry.DefaultRegistryBroker;
import org.mule.runtime.core.registry.MuleRegistryHelper;
import org.mule.runtime.core.transformer.builder.MockConverterBuilder;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.tck.testmodels.fruit.Apple;

@SmallTest
public class MuleRegistryHelperTransformersAsObjectsTestCase
extends AbstractMuleTestCase {
    private static final DataType APPLE_DATA_TYPE = DataType.fromType(Apple.class);
    private final DefaultRegistryBroker registry = (DefaultRegistryBroker)Mockito.mock(DefaultRegistryBroker.class);
    private final MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class);
    private final MuleRegistryHelper muleRegistryHelper = new MuleRegistryHelper(this.registry, this.muleContext);
    private final Converter stringToApple = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(DataType.STRING)).to(APPLE_DATA_TYPE)).build();
    private final Converter appleToString = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(APPLE_DATA_TYPE)).to(DataType.STRING)).build();

    @Before
    public void setUp() throws Exception {
        TransformerResolver transformerResolver = (TransformerResolver)Mockito.mock(TransformerResolver.class);
        Mockito.when((Object)transformerResolver.resolve(DataType.STRING, APPLE_DATA_TYPE)).thenReturn((Object)this.stringToApple);
        Mockito.when((Object)transformerResolver.resolve(APPLE_DATA_TYPE, DataType.STRING)).thenReturn((Object)this.appleToString);
        this.muleRegistryHelper.registerObject("mockTransformerResolver", (Object)transformerResolver);
        this.muleRegistryHelper.registerObject("StringToAppleConverter", (Object)this.stringToApple);
        this.muleRegistryHelper.registerObject("AppleToStringConverter", (Object)this.appleToString, this.appleToString.getClass());
    }

    @Test
    public void testRegisterTransformersAsNamedObjects() throws Exception {
        Transformer transformer1 = this.muleRegistryHelper.lookupTransformer(DataType.STRING, APPLE_DATA_TYPE);
        Transformer transformer2 = this.muleRegistryHelper.lookupTransformer(APPLE_DATA_TYPE, DataType.STRING);
        Assert.assertEquals((Object)this.stringToApple, (Object)transformer1);
        Assert.assertEquals((Object)this.appleToString, (Object)transformer2);
    }
}

