/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api;

import javax.xml.namespace.QName;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.api.exception.LocatedMuleException;
import org.mule.runtime.api.meta.AnnotatedObject;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.size.SmallTest;

@RunWith(value=MockitoJUnitRunner.class)
@SmallTest
public class LocatedMuleExceptionTestCase
extends AbstractMuleContextTestCase {
    private static QName docNameAttrName = new QName("http://www.mulesoft.org/schema/mule/documentation", "name");
    private static QName sourceFileNameAttrName = new QName("http://www.mulesoft.org/schema/mule/documentation", "sourceFileName");
    private static QName sourceFileLineAttrName = new QName("http://www.mulesoft.org/schema/mule/documentation", "sourceFileLine");

    @Test
    public void namedComponent() {
        NamedObject named = (NamedObject)Mockito.mock(NamedObject.class);
        Mockito.when((Object)named.getName()).thenReturn((Object)"mockComponent");
        LocatedMuleException lme = new LocatedMuleException((Object)named);
        Assert.assertThat((Object)lme.getInfo().get("Element").toString(), (Matcher)CoreMatchers.is((Object)"/mockComponent @ app"));
    }

    @Test
    public void annotatedComponent() {
        AnnotatedObject annotated = (AnnotatedObject)Mockito.mock(AnnotatedObject.class);
        Mockito.when((Object)annotated.getAnnotation((QName)Matchers.eq((Object)docNameAttrName))).thenReturn((Object)"Mock Component");
        Mockito.when((Object)annotated.getAnnotation((QName)Matchers.eq((Object)sourceFileNameAttrName))).thenReturn((Object)"muleApp.xml");
        Mockito.when((Object)annotated.getAnnotation((QName)Matchers.eq((Object)sourceFileLineAttrName))).thenReturn((Object)10);
        Mockito.when((Object)annotated.toString()).thenReturn((Object)"Mock@1");
        LocatedMuleException lme = new LocatedMuleException((Object)annotated);
        Assert.assertThat((Object)lme.getInfo().get("Element").toString(), (Matcher)CoreMatchers.is((Object)"Mock@1 @ app:muleApp.xml:10 (Mock Component)"));
    }

    @Test
    public void namedAnnotatedComponent() {
        AnnotatedObject namedAnnotated = (AnnotatedObject)Mockito.mock(AnnotatedObject.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{NamedObject.class}));
        Mockito.when((Object)((NamedObject)namedAnnotated).getName()).thenReturn((Object)"mockComponent");
        Mockito.when((Object)namedAnnotated.getAnnotation((QName)Matchers.eq((Object)docNameAttrName))).thenReturn((Object)"Mock Component");
        Mockito.when((Object)namedAnnotated.getAnnotation((QName)Matchers.eq((Object)sourceFileNameAttrName))).thenReturn((Object)"muleConfig.xml");
        Mockito.when((Object)namedAnnotated.getAnnotation((QName)Matchers.eq((Object)sourceFileLineAttrName))).thenReturn((Object)6);
        Mockito.when((Object)namedAnnotated.toString()).thenReturn((Object)"Mock@1");
        LocatedMuleException lme = new LocatedMuleException((Object)namedAnnotated);
        Assert.assertThat((Object)lme.getInfo().get("Element").toString(), (Matcher)CoreMatchers.is((Object)"/mockComponent @ app:muleConfig.xml:6 (Mock Component)"));
    }

    @Test
    public void rawComponent() {
        Object raw = Mockito.mock(Object.class);
        Mockito.when((Object)raw.toString()).thenReturn((Object)"Mock@1");
        LocatedMuleException lme = new LocatedMuleException(raw);
        Assert.assertThat((Object)lme.getInfo().get("Element").toString(), (Matcher)CoreMatchers.is((Object)"Mock@1 @ app"));
    }
}

