/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketException;
import javax.xml.namespace.QName;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.AnnotatedObject;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.TestNotSerializableMessageProcessor;
import org.mule.runtime.core.api.TestSerializableMessageProcessor;
import org.mule.runtime.core.api.TransformationService;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.context.notification.EnrichedNotificationInfo;
import org.mule.runtime.core.api.processor.AbstractProcessor;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.config.DefaultMuleConfiguration;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.exception.MessagingExceptionLocationProvider;
import org.mule.tck.SerializationTestUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.size.SmallTest;

@RunWith(value=MockitoJUnitRunner.class)
@SmallTest
public class MessagingExceptionTestCase
extends AbstractMuleContextTestCase {
    private static final String message = "a message";
    private static final String value = "Hello world!";
    private boolean originalVerboseExceptions;
    private MessagingExceptionLocationProvider locationProvider = new MessagingExceptionLocationProvider();
    @Mock
    private MuleContext mockContext;
    private Event testEvent;
    @Mock
    private FlowConstruct flowConstruct;
    @Mock
    private TransformationService transformationService;
    private static QName docNameAttrName = new QName("http://www.mulesoft.org/schema/mule/documentation", "name");
    private static QName sourceFileNameAttrName = new QName("http://www.mulesoft.org/schema/mule/documentation", "sourceFileName");
    private static QName sourceFileLineAttrName = new QName("http://www.mulesoft.org/schema/mule/documentation", "sourceFileLine");

    @Before
    public void before() throws MuleException {
        this.originalVerboseExceptions = MuleException.verboseExceptions;
        this.locationProvider.setMuleContext(this.mockContext);
        DefaultMuleConfiguration mockConfiguration = (DefaultMuleConfiguration)Mockito.mock(DefaultMuleConfiguration.class);
        Mockito.when((Object)mockConfiguration.getId()).thenReturn((Object)"MessagingExceptionTestCase");
        Mockito.when((Object)this.mockContext.getConfiguration()).thenReturn((Object)mockConfiguration);
        Mockito.when((Object)this.mockContext.getTransformationService()).thenReturn((Object)this.transformationService);
        this.testEvent = MessagingExceptionTestCase.eventBuilder().message(Message.of((Object)"test")).build();
    }

    @After
    public void after() {
        MuleException.verboseExceptions = this.originalVerboseExceptions;
    }

    @Test
    public void getCauseExceptionWithoutCause() {
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.testEvent);
        Assert.assertThat((Object)exception.getRootCause(), (Matcher)CoreMatchers.is((Object)((Object)exception)));
    }

    @Test
    public void getCauseExceptionWithMuleCause() {
        DefaultMuleException causeException = new DefaultMuleException("");
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.testEvent, (Throwable)causeException);
        Assert.assertThat((Object)exception.getRootCause(), (Matcher)CoreMatchers.is((Object)causeException));
    }

    @Test
    public void getCauseExceptionWithMuleCauseWithMuleCause() {
        DefaultMuleException causeCauseException = new DefaultMuleException("");
        DefaultMuleException causeException = new DefaultMuleException((Throwable)causeCauseException);
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.testEvent, (Throwable)causeException);
        Assert.assertThat((Object)exception.getRootCause(), (Matcher)CoreMatchers.is((Object)causeCauseException));
    }

    @Test
    public void getCauseExceptionWithNonMuleCause() {
        IOException causeException = new IOException("");
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.testEvent, (Throwable)causeException);
        Assert.assertThat((Object)exception.getRootCause(), (Matcher)CoreMatchers.is((Object)causeException));
    }

    @Test
    public void getCauseExceptionWithNonMuleCauseWithNonMuleCause() {
        ConnectException causeCauseException = new ConnectException();
        IOException causeException = new IOException(causeCauseException);
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.testEvent, (Throwable)causeException);
        Assert.assertThat((Object)exception.getRootCause(), (Matcher)CoreMatchers.is((Object)causeCauseException));
    }

    @Test
    public void causedByWithNullCause() {
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.testEvent);
        Assert.assertThat((Object)exception.causedBy(MessagingException.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)exception.causedBy(Exception.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)exception.causedBy(DefaultMuleException.class), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)exception.causedBy(IOException.class), (Matcher)Is.is((Object)false));
    }

    @Test
    public void causedByWithMuleCauseWithMuleCause() {
        DefaultMuleException causeCauseException = new DefaultMuleException("");
        DefaultMuleException causeException = new DefaultMuleException((Throwable)causeCauseException);
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.testEvent, (Throwable)causeException);
        Assert.assertThat((Object)exception.causedBy(DefaultMuleException.class), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)exception.causedBy(MessagingException.class), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void causedByWithNonMuleCause() {
        IOException causeException = new IOException("");
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.testEvent, (Throwable)causeException);
        Assert.assertThat((Object)exception.causedBy(IOException.class), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)exception.causedBy(MessagingException.class), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)exception.causedBy(Exception.class), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)exception.causedBy(NullPointerException.class), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void causedByWithNonMuleCauseWithNonMuleCause() {
        ConnectException causeCauseException = new ConnectException();
        IOException causeException = new IOException(causeCauseException);
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.testEvent, (Throwable)causeException);
        Assert.assertThat((Object)exception.causedBy(NullPointerException.class), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)exception.causedBy(SocketException.class), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)exception.causedBy(IOException.class), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)exception.causedBy(MessagingException.class), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void causedExactlyByWithNullCause() {
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.testEvent);
        Assert.assertThat((Object)exception.causedExactlyBy(MessagingException.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)exception.causedExactlyBy(Exception.class), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)exception.causedExactlyBy(DefaultMuleException.class), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)exception.causedExactlyBy(IOException.class), (Matcher)Is.is((Object)false));
    }

    @Test
    public void causedExactlyByWithMuleCauseWithMuleCause() {
        DefaultMuleException causeCauseException = new DefaultMuleException("");
        DefaultMuleException causeException = new DefaultMuleException((Throwable)causeCauseException);
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.testEvent, (Throwable)causeException);
        Assert.assertThat((Object)exception.causedExactlyBy(DefaultMuleException.class), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)exception.causedExactlyBy(MessagingException.class), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void causedExactlyByWithNonMuleCause() {
        IOException causeException = new IOException("");
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.testEvent, (Throwable)causeException);
        Assert.assertThat((Object)exception.causedExactlyBy(IOException.class), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)exception.causedExactlyBy(MessagingException.class), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)exception.causedExactlyBy(Exception.class), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)exception.causedExactlyBy(NullPointerException.class), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void causedExactlyByWithNonMuleCauseWithNonMuleCause() {
        ConnectException causeCauseException = new ConnectException();
        IOException causeException = new IOException(causeCauseException);
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.testEvent, (Throwable)causeException);
        Assert.assertThat((Object)exception.causedExactlyBy(ConnectException.class), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)exception.causedExactlyBy(SocketException.class), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)exception.causedExactlyBy(IOException.class), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)exception.causedExactlyBy(MessagingException.class), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void withFailingProcessorNoPathResolver() {
        Processor mockProcessor = (Processor)Mockito.mock(Processor.class);
        Mockito.when((Object)mockProcessor.toString()).thenReturn((Object)"Mock@1");
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.testEvent, mockProcessor);
        exception.getInfo().putAll(this.locationProvider.getContextInfo(EnrichedNotificationInfo.createInfo((Event)this.testEvent, (Exception)((Object)exception), (Object)mockProcessor), mockProcessor, null));
        Assert.assertThat((Object)exception.getInfo().get("Element").toString(), (Matcher)CoreMatchers.is((Object)"Mock@1 @ MessagingExceptionTestCase"));
    }

    @Test
    public void withFailingProcessorPathResolver() {
        AbstractProcessor mockProcessor = (AbstractProcessor)Mockito.mock(AbstractProcessor.class);
        ComponentLocation componentLocation = (ComponentLocation)Mockito.mock(ComponentLocation.class);
        Mockito.when((Object)mockProcessor.getAnnotation((QName)Matchers.eq((Object)sourceFileNameAttrName))).thenReturn((Object)"muleApp.xml");
        Mockito.when((Object)mockProcessor.getAnnotation((QName)Matchers.eq((Object)sourceFileLineAttrName))).thenReturn((Object)10);
        Mockito.when((Object)mockProcessor.getLocation()).thenReturn((Object)componentLocation);
        Mockito.when((Object)componentLocation.getLocation()).thenReturn((Object)"flow/processor");
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.testEvent, (Processor)mockProcessor);
        exception.getInfo().putAll(this.locationProvider.getContextInfo(EnrichedNotificationInfo.createInfo((Event)this.testEvent, (Exception)((Object)exception), (Object)mockProcessor), (Processor)mockProcessor, this.flowConstruct));
        Assert.assertThat((Object)exception.getInfo().get("Element").toString(), (Matcher)CoreMatchers.is((Object)"flow/processor @ MessagingExceptionTestCase:muleApp.xml:10"));
    }

    @Test
    public void withFailingProcessorNotPathResolver() {
        Processor mockProcessor = (Processor)Mockito.mock(Processor.class);
        FlowConstruct nonPathResolver = (FlowConstruct)Mockito.mock(FlowConstruct.class);
        Mockito.when((Object)mockProcessor.toString()).thenReturn((Object)"Mock@1");
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.testEvent, mockProcessor);
        exception.getInfo().putAll(this.locationProvider.getContextInfo(EnrichedNotificationInfo.createInfo((Event)this.testEvent, (Exception)((Object)exception), (Object)mockProcessor), mockProcessor, nonPathResolver));
        Assert.assertThat((Object)exception.getInfo().get("Element").toString(), (Matcher)CoreMatchers.is((Object)"Mock@1 @ MessagingExceptionTestCase"));
    }

    @Test
    public void withAnnotatedFailingProcessorNoPathResolver() {
        Processor mockProcessor = (Processor)Mockito.mock(Processor.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{AnnotatedObject.class}));
        Mockito.when((Object)((AnnotatedObject)mockProcessor).getAnnotation((QName)Matchers.eq((Object)docNameAttrName))).thenReturn((Object)"Mock Component");
        Mockito.when((Object)((AnnotatedObject)mockProcessor).getAnnotation((QName)Matchers.eq((Object)sourceFileNameAttrName))).thenReturn((Object)"muleApp.xml");
        Mockito.when((Object)((AnnotatedObject)mockProcessor).getAnnotation((QName)Matchers.eq((Object)sourceFileLineAttrName))).thenReturn((Object)10);
        Mockito.when((Object)mockProcessor.toString()).thenReturn((Object)"Mock@1");
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.testEvent, mockProcessor);
        exception.getInfo().putAll(this.locationProvider.getContextInfo(EnrichedNotificationInfo.createInfo((Event)this.testEvent, (Exception)((Object)exception), (Object)mockProcessor), mockProcessor, null));
        Assert.assertThat((Object)exception.getInfo().get("Element").toString(), (Matcher)CoreMatchers.is((Object)"Mock@1 @ MessagingExceptionTestCase:muleApp.xml:10 (Mock Component)"));
    }

    @Test
    public void withAnnotatedFailingProcessorPathResolver() {
        AbstractProcessor mockProcessor = (AbstractProcessor)Mockito.mock(AbstractProcessor.class);
        Mockito.when((Object)mockProcessor.getAnnotation((QName)Matchers.eq((Object)docNameAttrName))).thenReturn((Object)"Mock Component");
        Mockito.when((Object)mockProcessor.getAnnotation((QName)Matchers.eq((Object)sourceFileNameAttrName))).thenReturn((Object)"muleApp.xml");
        Mockito.when((Object)mockProcessor.getAnnotation((QName)Matchers.eq((Object)sourceFileLineAttrName))).thenReturn((Object)10);
        ComponentLocation componentLocation = (ComponentLocation)Mockito.mock(ComponentLocation.class);
        Mockito.when((Object)mockProcessor.getLocation()).thenReturn((Object)componentLocation);
        Mockito.when((Object)componentLocation.getLocation()).thenReturn((Object)"flow/processor");
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.testEvent, (Processor)mockProcessor);
        exception.getInfo().putAll(this.locationProvider.getContextInfo(EnrichedNotificationInfo.createInfo((Event)this.testEvent, (Exception)((Object)exception), (Object)mockProcessor), (Processor)mockProcessor, this.flowConstruct));
        Assert.assertThat((Object)exception.getInfo().get("Element").toString(), (Matcher)CoreMatchers.is((Object)"flow/processor @ MessagingExceptionTestCase:muleApp.xml:10 (Mock Component)"));
    }

    @Test
    public void withAnnotatedFailingProcessorNotPathResolver() {
        Processor mockProcessor = (Processor)Mockito.mock(Processor.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{AnnotatedObject.class}));
        Mockito.when((Object)((AnnotatedObject)mockProcessor).getAnnotation((QName)Matchers.eq((Object)docNameAttrName))).thenReturn((Object)"Mock Component");
        Mockito.when((Object)((AnnotatedObject)mockProcessor).getAnnotation((QName)Matchers.eq((Object)sourceFileNameAttrName))).thenReturn((Object)"muleApp.xml");
        Mockito.when((Object)((AnnotatedObject)mockProcessor).getAnnotation((QName)Matchers.eq((Object)sourceFileLineAttrName))).thenReturn((Object)10);
        FlowConstruct nonPathResolver = (FlowConstruct)Mockito.mock(FlowConstruct.class);
        Mockito.when((Object)mockProcessor.toString()).thenReturn((Object)"Mock@1");
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.testEvent, mockProcessor);
        exception.getInfo().putAll(this.locationProvider.getContextInfo(EnrichedNotificationInfo.createInfo((Event)this.testEvent, (Exception)((Object)exception), (Object)mockProcessor), mockProcessor, nonPathResolver));
        Assert.assertThat((Object)exception.getInfo().get("Element").toString(), (Matcher)CoreMatchers.is((Object)"Mock@1 @ MessagingExceptionTestCase:muleApp.xml:10 (Mock Component)"));
    }

    @Test
    public void serializableMessagingException() throws Exception {
        TestSerializableMessageProcessor processor = new TestSerializableMessageProcessor();
        processor.setValue(value);
        MessagingException e = new MessagingException(I18nMessageFactory.createStaticMessage((String)message), this.testEvent, (Processor)processor);
        e = (MessagingException)((Object)SerializationTestUtils.testException((Exception)((Object)e), (MuleContext)muleContext));
        Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)message));
        Assert.assertThat((Object)e.getFailingMessageProcessor(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)e.getFailingMessageProcessor(), (Matcher)IsInstanceOf.instanceOf(TestSerializableMessageProcessor.class));
        Assert.assertThat((Object)((TestSerializableMessageProcessor)e.getFailingMessageProcessor()).getValue(), (Matcher)CoreMatchers.is((Object)value));
    }

    @Test
    public void nonSerializableMessagingException() throws Exception {
        TestNotSerializableMessageProcessor processor = new TestNotSerializableMessageProcessor();
        MessagingException e = new MessagingException(I18nMessageFactory.createStaticMessage((String)message), this.testEvent, (Processor)processor);
        e = (MessagingException)((Object)SerializationTestUtils.testException((Exception)((Object)e), (MuleContext)muleContext));
        Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)message));
        Assert.assertThat((Object)e.getFailingMessageProcessor(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    @Ignore(value="MULE-10266 review how the transformationService is obtained when building an exception.")
    public void payloadInfoNonConsumable() throws Exception {
        MuleException.verboseExceptions = true;
        Event testEvent = (Event)Mockito.mock(Event.class);
        Object payload = Mockito.mock(Object.class);
        Mockito.when((Object)payload.toString()).then((Answer)new FailAnswer("toString() expected not to be called."));
        Message muleMessage = Message.of((Object)payload);
        Mockito.when((Object)this.transformationService.transform(muleMessage, DataType.STRING)).thenReturn((Object)Message.of((Object)value));
        Mockito.when((Object)testEvent.getMessage()).thenReturn((Object)muleMessage);
        MessagingException e = new MessagingException(I18nMessageFactory.createStaticMessage((String)message), testEvent);
        Assert.assertThat(e.getInfo().get("Payload"), (Matcher)CoreMatchers.is((Object)value));
    }

    @Test
    public void payloadInfoConsumable() throws Exception {
        MuleException.verboseExceptions = true;
        Event testEvent = (Event)Mockito.mock(Event.class);
        ByteArrayInputStream payload = new ByteArrayInputStream(new byte[0]);
        Message muleMessage = Message.of((Object)payload);
        Mockito.when((Object)testEvent.getMessage()).thenReturn((Object)muleMessage);
        MessagingException e = new MessagingException(I18nMessageFactory.createStaticMessage((String)message), testEvent);
        Assert.assertThat((Object)((String)e.getInfo().get("Payload")), (Matcher)CoreMatchers.containsString((String)(ByteArrayInputStream.class.getName() + "@")));
        ((TransformationService)Mockito.verify((Object)this.transformationService, (VerificationMode)Mockito.never())).transform(muleMessage, DataType.STRING);
    }

    @Test
    @Ignore(value="MULE-10266 review how the transformationService is obtained when building an exception.")
    public void payloadInfoException() throws Exception {
        MuleException.verboseExceptions = true;
        Event testEvent = (Event)Mockito.mock(Event.class);
        Object payload = Mockito.mock(Object.class);
        Mockito.when((Object)payload.toString()).then((Answer)new FailAnswer("toString() expected not to be called."));
        Message muleMessage = Message.of((Object)payload);
        Mockito.when((Object)this.transformationService.transform(muleMessage, DataType.STRING)).thenThrow(new Throwable[]{new TransformerException(CoreMessages.createStaticMessage((String)"exception thrown"))});
        Mockito.when((Object)testEvent.getMessage()).thenReturn((Object)muleMessage);
        MessagingException e = new MessagingException(I18nMessageFactory.createStaticMessage((String)message), testEvent);
        Assert.assertThat(e.getInfo().get("Payload"), (Matcher)CoreMatchers.is((Object)(TransformerException.class.getName() + " while getting payload: exception thrown")));
    }

    @Test
    public void payloadInfoNonVerbose() throws Exception {
        MuleException.verboseExceptions = false;
        Event testEvent = (Event)Mockito.mock(Event.class);
        Message muleMessage = (Message)Mockito.spy((Object)Message.of((Object)""));
        Mockito.when((Object)testEvent.getMessage()).thenReturn((Object)muleMessage);
        MessagingException e = new MessagingException(I18nMessageFactory.createStaticMessage((String)message), testEvent);
        Assert.assertThat(e.getInfo().get("Payload"), (Matcher)CoreMatchers.nullValue());
        ((Message)Mockito.verify((Object)muleMessage, (VerificationMode)Mockito.never())).getPayload();
        ((TransformationService)Mockito.verify((Object)this.transformationService, (VerificationMode)Mockito.never())).transform(muleMessage, DataType.STRING);
    }

    private static final class FailAnswer
    implements Answer<String> {
        private final String failMessage;

        private FailAnswer(String failMessage) {
            this.failMessage = failMessage;
        }

        public String answer(InvocationOnMock invocation) throws Throwable {
            Assert.fail((String)this.failMessage);
            return null;
        }
    }
}

