/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.lifecycle.CreateException;
import org.mule.runtime.core.api.security.tls.TlsConfiguration;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.util.SecurityUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class TlsConfigurationTestCase
extends AbstractMuleTestCase {
    private static final String SUPPORTED_CIPHER_SUITE = "TLS_DHE_DSS_WITH_AES_128_CBC_SHA";
    private static final String SUPPORTED_PROTOCOL = "TLSv1";
    private static final String TEST_SECURITY_MODEL = "test";

    @Test
    public void testEmptyConfiguration() throws Exception {
        TlsConfiguration configuration = new TlsConfiguration(".keystore");
        try {
            configuration.initialise(false, "javax.net");
            Assert.fail((String)"no key password");
        }
        catch (IllegalArgumentException e) {
            Assert.assertNotNull((String)"expected", (Object)e);
        }
        configuration.setKeyPassword("mulepassword");
        try {
            configuration.initialise(false, "javax.net");
            Assert.fail((String)"no store password");
        }
        catch (IllegalArgumentException e) {
            Assert.assertNotNull((String)"expected", (Object)e);
        }
        configuration.setKeyStorePassword("mulepassword");
        configuration.setKeyStore("");
        try {
            configuration.initialise(false, "javax.net");
            Assert.fail((String)"no keystore");
        }
        catch (Exception e) {
            Assert.assertNotNull((String)"expected", (Object)e);
        }
    }

    @Test
    public void testSimpleSocket() throws Exception {
        TlsConfiguration configuration = new TlsConfiguration(".keystore");
        configuration.setKeyPassword("mulepassword");
        configuration.setKeyStorePassword("mulepassword");
        configuration.setKeyStore("clientKeystore");
        configuration.initialise(false, "javax.net");
        SSLSocketFactory socketFactory = configuration.getSocketFactory();
        Assert.assertTrue((String)"socket is useless", (socketFactory.getSupportedCipherSuites().length > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testExceptionOnInvalidKeyAlias() throws Exception {
        URL keystoreUrl = ((Object)((Object)this)).getClass().getClassLoader().getResource("serverKeystore");
        File keystoreFile = new File(keystoreUrl.toURI());
        TlsConfiguration config = new TlsConfiguration(keystoreFile.getAbsolutePath());
        config.setKeyStorePassword("mulepassword");
        config.setKeyPassword("mulepassword");
        config.setKeyAlias("this_key_does_not_exist_in_the_keystore");
        try {
            config.initialise(false, "javax.net");
        }
        catch (CreateException ce) {
            Assert.assertTrue((boolean)(ce.getCause() instanceof IllegalStateException));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCipherSuitesFromConfigFile() throws Exception {
        File configFile = this.createDefaultConfigFile();
        try {
            TlsConfiguration tlsConfiguration = new TlsConfiguration(".keystore");
            tlsConfiguration.initialise(true, "javax.net");
            SSLSocket socket = (SSLSocket)tlsConfiguration.getSocketFactory().createSocket();
            SSLServerSocket serverSocket = (SSLServerSocket)tlsConfiguration.getServerSocketFactory().createServerSocket();
            Assert.assertArrayEquals((Object[])new String[]{SUPPORTED_CIPHER_SUITE}, (Object[])socket.getEnabledCipherSuites());
            Assert.assertArrayEquals((Object[])new String[]{SUPPORTED_CIPHER_SUITE}, (Object[])serverSocket.getEnabledCipherSuites());
        }
        finally {
            configFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProtocolsFromConfigFile() throws Exception {
        File configFile = this.createDefaultConfigFile();
        try {
            TlsConfiguration tlsConfiguration = new TlsConfiguration(".keystore");
            tlsConfiguration.initialise(true, "javax.net");
            SSLSocket socket = (SSLSocket)tlsConfiguration.getSocketFactory().createSocket();
            SSLServerSocket serverSocket = (SSLServerSocket)tlsConfiguration.getServerSocketFactory().createServerSocket();
            Assert.assertArrayEquals((Object[])new String[]{SUPPORTED_PROTOCOL}, (Object[])socket.getEnabledProtocols());
            Assert.assertArrayEquals((Object[])new String[]{SUPPORTED_PROTOCOL}, (Object[])serverSocket.getEnabledProtocols());
        }
        finally {
            configFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSecurityModelProperty() throws Exception {
        String previousSecurityModel = SecurityUtils.getSecurityModel();
        System.setProperty("mule.security.model", TEST_SECURITY_MODEL);
        File file = this.createConfigFile(TEST_SECURITY_MODEL, "enabledCipherSuites=TEST");
        try {
            TlsConfiguration tlsConfiguration = new TlsConfiguration(".keystore");
            tlsConfiguration.initialise(true, "javax.net");
            Assert.assertArrayEquals((Object[])new String[]{"TEST"}, (Object[])tlsConfiguration.getEnabledCipherSuites());
        }
        finally {
            System.setProperty("mule.security.model", previousSecurityModel);
            file.delete();
        }
    }

    private File createDefaultConfigFile() throws IOException {
        String contents = String.format("enabledCipherSuites=UNSUPPORTED,%s\nenabledProtocols=UNSUPPORTED,%s", SUPPORTED_CIPHER_SUITE, SUPPORTED_PROTOCOL);
        return this.createConfigFile("default", contents);
    }

    private File createConfigFile(String securityModel, String contents) throws IOException {
        String path = ClassUtils.getClassPathRoot(((Object)((Object)this)).getClass()).getPath();
        File file = new File(path, String.format("tls-%s.conf", securityModel));
        PrintWriter writer = new PrintWriter(file, "UTF-8");
        writer.println(contents);
        writer.close();
        return file;
    }
}

