/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.model.resolvers;

import java.lang.reflect.Method;
import junit.framework.AssertionFailedError;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleEventContext;
import org.mule.runtime.core.api.model.InvocationResult;
import org.mule.runtime.core.api.model.resolvers.AbstractEntryPointResolver;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class EntryPointResolverMethodCacheTestCase
extends AbstractMuleTestCase {
    private static final String METHOD = "aMethod";

    @Test
    public void testMethodCaching() throws Exception {
        Method method = ((Object)((Object)this)).getClass().getMethod(METHOD, String.class);
        Method anotherMethod = AnotherClass.class.getMethod(METHOD, String.class);
        MuleEventContext eventContext = (MuleEventContext)Mockito.mock(MuleEventContext.class);
        MockEntryPointResolver epResolver = new MockEntryPointResolver();
        epResolver.addMethodByName((Object)this, method, eventContext);
        Method method1 = epResolver.getMethodByName((Object)this, METHOD, eventContext);
        Assert.assertEquals((Object)method, (Object)method1);
        Assert.assertEquals(((Object)((Object)this)).getClass(), method1.getDeclaringClass());
        AnotherClass anotherObject = new AnotherClass();
        epResolver.addMethodByName(anotherObject, anotherMethod, eventContext);
        Method anotherMethod1 = epResolver.getMethodByName(anotherObject, METHOD, eventContext);
        Assert.assertEquals((Object)anotherMethod, (Object)anotherMethod1);
        Assert.assertEquals(AnotherClass.class, anotherMethod.getDeclaringClass());
    }

    public void aMethod(String payload) {
    }

    private static class AnotherClass {
        private AnotherClass() {
        }

        public void aMethod(String payload) {
        }
    }

    private static class MockEntryPointResolver
    extends AbstractEntryPointResolver {
        private MockEntryPointResolver() {
        }

        public InvocationResult invoke(Object component, MuleEventContext context, Event.Builder eventBuilder) throws Exception {
            throw new AssertionFailedError("do not invoke this method");
        }
    }
}

