/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.processor;

import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.processor.LoggerMessageProcessor;
import org.mule.runtime.core.api.registry.RegistrationException;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.util.MuleContextUtils;
import org.slf4j.Logger;

public class LoggerMessageProcessorTestCase
extends AbstractMuleTestCase {
    private Flow flow;

    @Before
    public void before() throws RegistrationException {
        this.flow = Flow.builder((String)"flow", (MuleContext)MuleContextUtils.mockContextWithServices()).build();
    }

    @Test
    public void logNullEvent() {
        this.verifyNullEventByLevel("TRACE");
        this.verifyNullEventByLevel("DEBUG");
        this.verifyNullEventByLevel("INFO");
        this.verifyNullEventByLevel("WARN");
        this.verifyNullEventByLevel("ERROR");
    }

    @Test
    public void logMuleEvent() {
        this.verifyMuleEventByLevel("TRACE");
        this.verifyMuleEventByLevel("DEBUG");
        this.verifyMuleEventByLevel("INFO");
        this.verifyMuleEventByLevel("WARN");
        this.verifyMuleEventByLevel("ERROR");
    }

    @Test
    public void logWithMessage() {
        this.verifyLoggerMessageByLevel("TRACE");
        this.verifyLoggerMessageByLevel("DEBUG");
        this.verifyLoggerMessageByLevel("INFO");
        this.verifyLoggerMessageByLevel("WARN");
        this.verifyLoggerMessageByLevel("ERROR");
    }

    private void verifyLogCall(LoggerMessageProcessor loggerMessageProcessor, String logLevel, String enabledLevel, Event muleEvent, String message) {
        Mockito.when((Object)loggerMessageProcessor.logger.isTraceEnabled()).thenReturn((Object)"TRACE".equals(enabledLevel));
        Mockito.when((Object)loggerMessageProcessor.logger.isDebugEnabled()).thenReturn((Object)"DEBUG".equals(enabledLevel));
        Mockito.when((Object)loggerMessageProcessor.logger.isInfoEnabled()).thenReturn((Object)"INFO".equals(enabledLevel));
        Mockito.when((Object)loggerMessageProcessor.logger.isWarnEnabled()).thenReturn((Object)"WARN".equals(enabledLevel));
        Mockito.when((Object)loggerMessageProcessor.logger.isErrorEnabled()).thenReturn((Object)"ERROR".equals(enabledLevel));
        loggerMessageProcessor.log(muleEvent);
        ((Logger)Mockito.verify((Object)loggerMessageProcessor.logger, (VerificationMode)Mockito.times((int)("TRACE".equals(enabledLevel) ? 1 : 0)))).trace(message);
        ((Logger)Mockito.verify((Object)loggerMessageProcessor.logger, (VerificationMode)Mockito.times((int)("DEBUG".equals(enabledLevel) ? 1 : 0)))).debug(message);
        ((Logger)Mockito.verify((Object)loggerMessageProcessor.logger, (VerificationMode)Mockito.times((int)("INFO".equals(enabledLevel) ? 1 : 0)))).info(message);
        ((Logger)Mockito.verify((Object)loggerMessageProcessor.logger, (VerificationMode)Mockito.times((int)("WARN".equals(enabledLevel) ? 1 : 0)))).warn(message);
        ((Logger)Mockito.verify((Object)loggerMessageProcessor.logger, (VerificationMode)Mockito.times((int)("ERROR".equals(enabledLevel) ? 1 : 0)))).error(message);
    }

    private void verifyExpressionEvaluation(LoggerMessageProcessor loggerMessageProcessor, String level, String enabledLevel, Event muleEvent, VerificationMode timesEvaluateExpression) {
        Mockito.when((Object)loggerMessageProcessor.logger.isTraceEnabled()).thenReturn((Object)"TRACE".equals(enabledLevel));
        Mockito.when((Object)loggerMessageProcessor.logger.isDebugEnabled()).thenReturn((Object)"DEBUG".equals(enabledLevel));
        Mockito.when((Object)loggerMessageProcessor.logger.isInfoEnabled()).thenReturn((Object)"INFO".equals(enabledLevel));
        Mockito.when((Object)loggerMessageProcessor.logger.isWarnEnabled()).thenReturn((Object)"WARN".equals(enabledLevel));
        Mockito.when((Object)loggerMessageProcessor.logger.isErrorEnabled()).thenReturn((Object)"ERROR".equals(enabledLevel));
        loggerMessageProcessor.expressionManager = this.buildExpressionManager();
        loggerMessageProcessor.log(muleEvent);
        ((ExtendedExpressionManager)Mockito.verify((Object)loggerMessageProcessor.expressionManager, (VerificationMode)timesEvaluateExpression)).parse("some expression", muleEvent, (FlowConstruct)this.flow);
    }

    private void verifyNullEventByLevel(String level) {
        LoggerMessageProcessor loggerMessageProcessor = this.buildLoggerMessageProcessorWithLevel(level);
        this.verifyLogCall(loggerMessageProcessor, level, level, null, null);
        loggerMessageProcessor = this.buildLoggerMessageProcessorWithLevel(level);
        this.verifyLogCall(loggerMessageProcessor, level, "not" + level, null, null);
    }

    private void verifyMuleEventByLevel(String level) {
        LoggerMessageProcessor loggerMessageProcessor = this.buildLoggerMessageProcessorWithLevel(level);
        Event muleEvent = this.buildMuleEvent();
        this.verifyLogCall(loggerMessageProcessor, level, level, muleEvent, muleEvent.getMessage().toString());
        loggerMessageProcessor = this.buildLoggerMessageProcessorWithLevel(level);
        this.verifyLogCall(loggerMessageProcessor, level, "not" + level, muleEvent, muleEvent.getMessage().toString());
    }

    private void verifyLoggerMessageByLevel(String level) {
        Event muleEvent = this.buildMuleEvent();
        this.verifyLogCall(this.buildLoggerMessageProcessorForExpressionEvaluation(level), level, level, muleEvent, "text to log".toString());
        this.verifyLogCall(this.buildLoggerMessageProcessorForExpressionEvaluation(level), level, "not" + level, muleEvent, "text to log".toString());
        this.verifyExpressionEvaluation(this.buildLoggerMessageProcessorForExpressionEvaluation(level), level, level, muleEvent, Mockito.times((int)1));
        this.verifyExpressionEvaluation(this.buildLoggerMessageProcessorForExpressionEvaluation(level), level, "not" + level, muleEvent, Mockito.never());
    }

    private Logger buildMockLogger() {
        Logger mockLogger = (Logger)Mockito.mock(Logger.class);
        ((Logger)Mockito.doNothing().when((Object)mockLogger)).error((String)Matchers.any());
        ((Logger)Mockito.doNothing().when((Object)mockLogger)).warn((String)Matchers.any());
        ((Logger)Mockito.doNothing().when((Object)mockLogger)).info((String)Matchers.any());
        ((Logger)Mockito.doNothing().when((Object)mockLogger)).debug((String)Matchers.any());
        ((Logger)Mockito.doNothing().when((Object)mockLogger)).trace((String)Matchers.any());
        Mockito.when((Object)mockLogger.isErrorEnabled()).thenReturn((Object)true);
        Mockito.when((Object)mockLogger.isWarnEnabled()).thenReturn((Object)true);
        Mockito.when((Object)mockLogger.isInfoEnabled()).thenReturn((Object)true);
        Mockito.when((Object)mockLogger.isDebugEnabled()).thenReturn((Object)true);
        Mockito.when((Object)mockLogger.isTraceEnabled()).thenReturn((Object)true);
        return mockLogger;
    }

    private LoggerMessageProcessor buildLoggerMessageProcessorWithLevel(String level) {
        LoggerMessageProcessor loggerMessageProcessor = new LoggerMessageProcessor();
        loggerMessageProcessor.initLogger();
        loggerMessageProcessor.logger = this.buildMockLogger();
        loggerMessageProcessor.setLevel(level);
        loggerMessageProcessor.setFlowConstruct((FlowConstruct)this.flow);
        return loggerMessageProcessor;
    }

    private LoggerMessageProcessor buildLoggerMessageProcessorForExpressionEvaluation(String level) {
        LoggerMessageProcessor loggerMessageProcessor = this.buildLoggerMessageProcessorWithLevel(level);
        loggerMessageProcessor = this.buildLoggerMessageProcessorWithLevel(level);
        loggerMessageProcessor.expressionManager = this.buildExpressionManager();
        loggerMessageProcessor.setMessage("some expression");
        loggerMessageProcessor.setFlowConstruct((FlowConstruct)this.flow);
        return loggerMessageProcessor;
    }

    private Event buildMuleEvent() {
        Event event = (Event)Mockito.mock(Event.class);
        InternalMessage message = (InternalMessage)Mockito.mock(InternalMessage.class);
        Mockito.when((Object)message.toString()).thenReturn((Object)"text to log");
        Mockito.when((Object)event.getMessage()).thenReturn((Object)message);
        return event;
    }

    private ExtendedExpressionManager buildExpressionManager() {
        ExtendedExpressionManager expressionLanguage = (ExtendedExpressionManager)Mockito.mock(ExtendedExpressionManager.class);
        Mockito.when((Object)expressionLanguage.parse(Matchers.anyString(), (Event)Matchers.any(Event.class), (FlowConstruct)Matchers.eq((Object)this.flow))).thenReturn((Object)"text to log");
        return expressionLanguage;
    }
}

