/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.util;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang.SerializationUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.core.api.util.CaseInsensitiveHashMap;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class CaseInsensitiveHashMapTestCase
extends AbstractMuleTestCase {
    protected Map createTestMap() {
        CaseInsensitiveHashMap map = new CaseInsensitiveHashMap();
        map.put("FOO", "BAR");
        map.put("doo", 3);
        return map;
    }

    @Test
    public void keysCaseSensitive() throws Exception {
        Map map = this.createTestMap();
        Assert.assertEquals((long)2L, (long)map.keySet().size());
        Assert.assertTrue((map.keySet().toArray()[0].equals("FOO") || map.keySet().toArray()[0].equals("doo") ? 1 : 0) != 0);
        Assert.assertTrue((map.keySet().toArray()[1].equals("FOO") || map.keySet().toArray()[1].equals("doo") ? 1 : 0) != 0);
    }

    @Test
    public void testMap() throws Exception {
        Map map = this.createTestMap();
        this.doTestMap(map);
    }

    @Test
    public void testMapSerialization() throws Exception {
        Map map = this.createTestMap();
        this.doTestMap(map);
        byte[] bytes = SerializationUtils.serialize((Serializable)((Serializable)((Object)map)));
        Map resultMap = (Map)SerializationUtils.deserialize((byte[])bytes);
        this.doTestMap(resultMap);
    }

    public void doTestMap(Map map) throws Exception {
        Assert.assertEquals((Object)"BAR", map.get("FOO"));
        Assert.assertEquals((Object)"BAR", map.get("foo"));
        Assert.assertEquals((Object)"BAR", map.get("Foo"));
        Assert.assertEquals((Object)3, map.get("DOO"));
        Assert.assertEquals((Object)3, map.get("doo"));
        Assert.assertEquals((Object)3, map.get("Doo"));
    }
}

