/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.util.concurrent;

import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.core.api.util.concurrent.Latch;
import org.mule.runtime.core.api.util.concurrent.NamedThreadFactory;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class NamedThreadFactoryTestCase
extends AbstractMuleTestCase {
    protected Latch latch = new Latch();
    protected String testThreadName = "myThread";
    protected ClassLoader testClassLoader = new ClassLoader(){};
    protected Runnable nullRunnable = () -> {};

    @Test
    public void testNameContextClassloader() throws InterruptedException {
        NamedThreadFactory threadFactory = new NamedThreadFactory(this.testThreadName, this.testClassLoader);
        Thread t = threadFactory.newThread(() -> {
            Assert.assertEquals((Object)(this.testThreadName + ".01"), (Object)Thread.currentThread().getName());
            Assert.assertEquals((Object)this.testClassLoader, (Object)Thread.currentThread().getContextClassLoader());
            this.latch.countDown();
        });
        t.start();
        Assert.assertTrue((boolean)this.latch.await(200L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testNameIncrement() throws InterruptedException {
        NamedThreadFactory threadFactory = new NamedThreadFactory(this.testThreadName);
        Thread t = threadFactory.newThread(this.nullRunnable);
        Assert.assertEquals((Object)(this.testThreadName + ".01"), (Object)t.getName());
        t = threadFactory.newThread(this.nullRunnable);
        Assert.assertEquals((Object)(this.testThreadName + ".02"), (Object)t.getName());
        t = threadFactory.newThread(this.nullRunnable);
        Assert.assertEquals((Object)(this.testThreadName + ".03"), (Object)t.getName());
    }
}

