/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.component;

import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.component.LifecycleAdapter;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.object.ObjectFactory;
import org.mule.runtime.core.component.AbstractComponentTestCase;
import org.mule.runtime.core.component.DefaultComponentLifecycleAdapter;
import org.mule.runtime.core.component.DefaultJavaComponent;
import org.mule.runtime.core.object.PrototypeObjectFactory;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.core.lifecycle.LifecycleTrackerComponent;
import org.mule.tck.testmodels.fruit.Orange;

public class DefaultJavaComponentTestCase
extends AbstractComponentTestCase {
    protected ObjectFactory createObjectFactory() throws InitialisationException {
        PrototypeObjectFactory objectFactory = new PrototypeObjectFactory(Orange.class);
        objectFactory.initialise();
        return objectFactory;
    }

    @Test
    public void testComponentCreation() throws Exception {
        ObjectFactory objectFactory = this.createObjectFactory();
        DefaultJavaComponent component = new DefaultJavaComponent(objectFactory);
        Assert.assertNotNull((Object)component.getObjectFactory());
        Assert.assertEquals((Object)objectFactory, (Object)component.getObjectFactory());
        Assert.assertEquals(Orange.class, (Object)component.getObjectFactory().getObjectClass());
        Assert.assertEquals(Orange.class, (Object)component.getObjectType());
    }

    @Test
    public void testLifecycle() throws Exception {
        DefaultJavaComponent component = new DefaultJavaComponent(this.createObjectFactory());
        component.setFlowConstruct((FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext));
        component.setMuleContext(muleContext);
        component.initialise();
        component.start();
        Assert.assertNotSame((Object)component.borrowComponentLifecycleAdaptor(), (Object)component.borrowComponentLifecycleAdaptor());
        Object obj = component.getObjectFactory().getInstance(muleContext);
        Assert.assertNotNull((Object)obj);
        component.stop();
        component.start();
        Assert.assertNotSame((Object)((DefaultComponentLifecycleAdapter)component.borrowComponentLifecycleAdaptor()).componentObject, (Object)((DefaultComponentLifecycleAdapter)component.borrowComponentLifecycleAdaptor()).componentObject);
    }

    @Test
    public void testComponentDisposal() throws Exception {
        DefaultJavaComponent component = new DefaultJavaComponent(this.createObjectFactory());
        component.setFlowConstruct((FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext));
        component.setMuleContext(muleContext);
        component.initialise();
        component.start();
        DefaultComponentLifecycleAdapter lifecycleAdapter = (DefaultComponentLifecycleAdapter)component.borrowComponentLifecycleAdaptor();
        component.returnComponentLifecycleAdaptor((LifecycleAdapter)lifecycleAdapter);
        component.stop();
        component.dispose();
        Assert.assertNull((Object)lifecycleAdapter.componentObject);
    }

    @Test
    public void testServicePropagatedLifecycle() throws Exception {
        LifecycleTrackerComponent component = new LifecycleTrackerComponent();
        Flow flow = Flow.builder((String)"test", (MuleContext)muleContext).messageProcessors(Collections.singletonList(component)).build();
        flow.initialise();
        Assert.assertTrue((boolean)component.getTracker().contains("initialise"));
    }
}

