/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.component;

import java.util.NoSuchElementException;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.config.PoolingProfile;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.component.LifecycleAdapter;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.object.ObjectFactory;
import org.mule.runtime.core.component.DefaultComponentLifecycleAdapter;
import org.mule.runtime.core.component.PooledJavaComponent;
import org.mule.runtime.core.internal.util.pool.AbstractPoolingTestCase;
import org.mule.runtime.core.object.PrototypeObjectFactory;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.services.UniqueComponent;
import org.mule.tck.testmodels.fruit.Orange;
import org.mule.tck.testmodels.fruit.WaterMelon;

public class PooledJavaComponentTestCase
extends AbstractPoolingTestCase {
    @Test
    public void testComponentCreation() throws Exception {
        PrototypeObjectFactory objectFactory = this.getDefaultObjectFactory();
        PoolingProfile pp = this.createDefaultPoolingProfile();
        pp.setExhaustedAction(0);
        PooledJavaComponent component = new PooledJavaComponent((ObjectFactory)objectFactory, pp);
        component.setMuleContext(muleContext);
        Assert.assertNotNull((Object)component.getObjectFactory());
        Assert.assertEquals((Object)objectFactory, (Object)component.getObjectFactory());
        Assert.assertEquals(Orange.class, (Object)component.getObjectType());
        Assert.assertNotNull((Object)component.getPoolingProfile());
        Assert.assertEquals((Object)pp, (Object)component.getPoolingProfile());
    }

    @Test
    public void testPoolManagement() throws Exception {
        PooledJavaComponent component = new PooledJavaComponent((ObjectFactory)this.getDefaultObjectFactory(), this.createDefaultPoolingProfile());
        Assert.assertNull((Object)component.lifecycleAdapterPool);
        component.setFlowConstruct((FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext));
        component.setMuleContext(muleContext);
        component.initialise();
        Assert.assertNull((Object)component.lifecycleAdapterPool);
        component.start();
        Assert.assertNotNull((Object)component.lifecycleAdapterPool);
        component.stop();
        Assert.assertNull((Object)component.lifecycleAdapterPool);
    }

    @Test
    public void testStartStop() throws Exception {
        PooledJavaComponent component = this.createPooledComponent();
        Assert.assertNotSame((Object)component.borrowComponentLifecycleAdaptor(), (Object)component.borrowComponentLifecycleAdaptor());
        component.stop();
        component.start();
        Object la1 = ((DefaultComponentLifecycleAdapter)component.borrowComponentLifecycleAdaptor()).componentObject;
        Object la2 = ((DefaultComponentLifecycleAdapter)component.borrowComponentLifecycleAdaptor()).componentObject;
        Assert.assertNotSame((Object)la1, (Object)la2);
    }

    @Test
    public void testCreateLifecycleAdapters() throws Exception {
        PooledJavaComponent component = this.createPooledComponent();
        Assert.assertEquals((long)0L, (long)component.lifecycleAdapterPool.getNumActive());
        LifecycleAdapter borrowed = component.borrowComponentLifecycleAdaptor();
        Assert.assertNotNull((Object)borrowed);
        Assert.assertEquals((long)1L, (long)component.lifecycleAdapterPool.getNumActive());
        component.returnComponentLifecycleAdaptor(borrowed);
        Assert.assertEquals((long)0L, (long)component.lifecycleAdapterPool.getNumActive());
        borrowed = component.borrowComponentLifecycleAdaptor();
        Assert.assertNotNull((Object)borrowed);
        Assert.assertEquals((long)1L, (long)component.lifecycleAdapterPool.getNumActive());
        LifecycleAdapter borrowed2 = component.borrowComponentLifecycleAdaptor();
        Assert.assertNotNull((Object)borrowed2);
        Assert.assertEquals((long)2L, (long)component.lifecycleAdapterPool.getNumActive());
    }

    @Test
    public void testFailOnExhaust() throws Exception {
        PoolingProfile pp = this.createDefaultPoolingProfile();
        pp.setExhaustedAction(0);
        PooledJavaComponent component = this.createPooledComponent(pp);
        this.borrowLifecycleAdaptersUntilPoolIsFull(component);
        try {
            component.borrowComponentLifecycleAdaptor();
            Assert.fail((String)"Should throw an Exception");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testBlockExpiryOnExhaust() throws Exception {
        PoolingProfile pp = this.createDefaultPoolingProfile();
        pp.setExhaustedAction(1);
        PooledJavaComponent component = this.createPooledComponent(pp);
        Assert.assertEquals((long)0L, (long)component.lifecycleAdapterPool.getNumActive());
        this.borrowLifecycleAdaptersUntilPoolIsFull(component);
        long startTime = System.currentTimeMillis();
        try {
            component.borrowComponentLifecycleAdaptor();
            Assert.fail((String)"Should throw an Exception");
        }
        catch (NoSuchElementException e) {
            long totalTime = System.currentTimeMillis() - startTime;
            Assert.assertTrue((totalTime >= 1500L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testBlockOnExhaust() throws Exception {
        PoolingProfile pp = this.createDefaultPoolingProfile();
        pp.setExhaustedAction(1);
        PooledJavaComponent component = this.createPooledComponent(pp);
        Assert.assertEquals((long)0L, (long)component.lifecycleAdapterPool.getNumActive());
        int oneRemainingInPool = 2;
        for (int i = 0; i < oneRemainingInPool; ++i) {
            LifecycleAdapter borrowed = component.borrowComponentLifecycleAdaptor();
            Assert.assertNotNull((Object)borrowed);
            Assert.assertEquals((long)component.lifecycleAdapterPool.getNumActive(), (long)(i + 1));
        }
        Assert.assertEquals((long)oneRemainingInPool, (long)component.lifecycleAdapterPool.getNumActive());
        long startTime = System.currentTimeMillis();
        int borrowerWait = 500;
        Borrower borrower = new Borrower(component, borrowerWait);
        new Thread((Runnable)borrower, "BorrowThread").start();
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        LifecycleAdapter borrowed = component.borrowComponentLifecycleAdaptor();
        Assert.assertNotNull((Object)borrowed);
        long totalTime = System.currentTimeMillis() - startTime;
        Assert.assertTrue((totalTime >= (long)borrowerWait ? 1 : 0) != 0);
    }

    @Test
    public void testGrowOnExhaust() throws Exception {
        PoolingProfile pp = this.createDefaultPoolingProfile();
        pp.setExhaustedAction(2);
        PooledJavaComponent component = this.createPooledComponent(pp);
        this.borrowLifecycleAdaptersUntilPoolIsFull(component);
        LifecycleAdapter borrowed = component.borrowComponentLifecycleAdaptor();
        Assert.assertNotNull((Object)borrowed);
        Assert.assertEquals((long)4L, (long)component.lifecycleAdapterPool.getNumActive());
    }

    @Test
    public void testClearPool() throws Exception {
        PoolingProfile pp = this.createDefaultPoolingProfile();
        pp.setExhaustedAction(0);
        PooledJavaComponent component = this.createPooledComponent(pp);
        LifecycleAdapter borrowed = component.borrowComponentLifecycleAdaptor();
        Assert.assertEquals((long)1L, (long)component.lifecycleAdapterPool.getNumActive());
        component.returnComponentLifecycleAdaptor(borrowed);
        Assert.assertEquals((long)0L, (long)component.lifecycleAdapterPool.getNumActive());
        component.stop();
        component.start();
        Assert.assertEquals((long)0L, (long)component.lifecycleAdapterPool.getNumActive());
    }

    @Test
    public void testObjectUniqueness() throws Exception {
        PrototypeObjectFactory objectFactory = new PrototypeObjectFactory(UniqueComponent.class);
        PooledJavaComponent component = this.createPooledComponent((ObjectFactory)objectFactory);
        Assert.assertEquals((long)0L, (long)component.lifecycleAdapterPool.getNumActive());
        String id1 = this.getIdFromObjectCreatedByPool(component);
        String id2 = this.getIdFromObjectCreatedByPool(component);
        String id3 = this.getIdFromObjectCreatedByPool(component);
        Assert.assertFalse((String)("Service IDs " + id1 + " and " + id2 + " should be different"), (boolean)id1.equals(id2));
        Assert.assertFalse((String)("Service IDs " + id2 + " and " + id3 + " should be different"), (boolean)id2.equals(id3));
        Assert.assertFalse((String)("Service IDs " + id1 + " and " + id3 + " should be different"), (boolean)id1.equals(id3));
    }

    @Test
    public void testDisposingFactoryDisposesObject() throws Exception {
        PrototypeObjectFactory objectFactory = new PrototypeObjectFactory(WaterMelon.class);
        PooledJavaComponent component = this.createPooledComponent((ObjectFactory)objectFactory);
        DefaultComponentLifecycleAdapter lifecycleAdapter = (DefaultComponentLifecycleAdapter)component.borrowComponentLifecycleAdaptor();
        component.returnComponentLifecycleAdaptor((LifecycleAdapter)lifecycleAdapter);
        component.stop();
        component.dispose();
        Assert.assertNull((Object)lifecycleAdapter.componentObject);
    }

    private PrototypeObjectFactory getDefaultObjectFactory() throws InitialisationException {
        PrototypeObjectFactory objectFactory = new PrototypeObjectFactory(Orange.class);
        objectFactory.initialise();
        return objectFactory;
    }

    private PooledJavaComponent createPooledComponent() throws Exception {
        return this.createPooledComponent(this.createDefaultPoolingProfile(), (ObjectFactory)this.getDefaultObjectFactory());
    }

    private PooledJavaComponent createPooledComponent(ObjectFactory objectFactory) throws Exception {
        return this.createPooledComponent(this.createDefaultPoolingProfile(), objectFactory);
    }

    private PooledJavaComponent createPooledComponent(PoolingProfile poolingProfile) throws Exception {
        return this.createPooledComponent(poolingProfile, (ObjectFactory)this.getDefaultObjectFactory());
    }

    private PooledJavaComponent createPooledComponent(PoolingProfile poolingProfile, ObjectFactory objectFactory) throws Exception {
        PooledJavaComponent component = new PooledJavaComponent(objectFactory, poolingProfile);
        component.setMuleContext(muleContext);
        component.setFlowConstruct((FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext));
        component.initialise();
        component.start();
        return component;
    }

    private void borrowLifecycleAdaptersUntilPoolIsFull(PooledJavaComponent component) throws Exception {
        for (int i = 0; i < 3; ++i) {
            LifecycleAdapter borrowed = component.borrowComponentLifecycleAdaptor();
            Assert.assertNotNull((Object)borrowed);
            Assert.assertEquals((long)component.lifecycleAdapterPool.getNumActive(), (long)(i + 1));
        }
        Assert.assertEquals((long)3L, (long)component.lifecycleAdapterPool.getNumActive());
    }

    private String getIdFromObjectCreatedByPool(PooledJavaComponent component) throws Exception {
        DefaultComponentLifecycleAdapter lifecycleAdapter = (DefaultComponentLifecycleAdapter)component.borrowComponentLifecycleAdaptor();
        Object obj = lifecycleAdapter.componentObject;
        Assert.assertNotNull((Object)obj);
        Assert.assertTrue((String)"Object should be of type UniqueComponent", (boolean)(obj instanceof UniqueComponent));
        String id = ((UniqueComponent)obj).getId();
        Assert.assertNotNull((Object)id);
        return id;
    }

    private static class Borrower
    implements Runnable {
        private PooledJavaComponent component;
        private long time;

        public Borrower(PooledJavaComponent component, long time) {
            if (component == null) {
                throw new IllegalArgumentException("Pool cannot be null");
            }
            this.component = component;
            if (time < 500L) {
                time = 500L;
            }
            this.time = time;
        }

        @Override
        public void run() {
            try {
                LifecycleAdapter object = this.component.borrowComponentLifecycleAdaptor();
                try {
                    Thread.sleep(this.time);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.component.returnComponentLifecycleAdaptor(object);
            }
            catch (Exception e) {
                Assert.fail((String)("Borrower thread failed:\n" + ExceptionUtils.getStackTrace((Throwable)e)));
            }
        }
    }
}

