/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.config.artifact;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.core.config.artifact.DefaultArtifactProperties;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class DefaultArtifactPropertiesTestCase
extends AbstractMuleTestCase {
    private static final String OVERRIDE_PROPERTY_KEY = "overrideProperty";
    private static final String CONFIG_PROPERTY_OVERRIDE_VALUE = "configPropertyValue";
    private static final String ARTIFACT_PROPERTY_OVERRIDE_VALUE = "artifactPropertyValue";
    private static final String SPRING_PROPERTY_OVERRIDE_VALUE = "springPropertyValue";
    private static final String SYSTEM_PROPERTY_OVERRIDE_VALUE = "systemPropertyValue";
    private Map<Object, Object> configPropertiesOverriddenPropertyMap = ImmutableMap.builder().put((Object)"overrideProperty", (Object)"configPropertyValue").build();
    private Map<Object, Object> artifactPropertiesOverriddenMap = ImmutableMap.builder().put((Object)"overrideProperty", (Object)"artifactPropertyValue").build();
    private Map<Object, Object> springPropertiesOverriddenMap = ImmutableMap.builder().put((Object)"overrideProperty", (Object)"springPropertyValue").build();
    private DefaultArtifactProperties properties;

    @Test
    public void propertiesScopesOverride() throws Exception {
        this.properties = new DefaultArtifactProperties(this.configPropertiesOverriddenPropertyMap, Collections.emptyMap(), Collections.emptyMap());
        Assert.assertThat((Object)this.properties.getProperty((Object)OVERRIDE_PROPERTY_KEY), (Matcher)Is.is((Object)CONFIG_PROPERTY_OVERRIDE_VALUE));
        this.properties = new DefaultArtifactProperties(this.configPropertiesOverriddenPropertyMap, this.springPropertiesOverriddenMap, Collections.emptyMap());
        Assert.assertThat((Object)this.properties.getProperty((Object)OVERRIDE_PROPERTY_KEY), (Matcher)Is.is((Object)SPRING_PROPERTY_OVERRIDE_VALUE));
        this.properties = new DefaultArtifactProperties(this.configPropertiesOverriddenPropertyMap, this.springPropertiesOverriddenMap, this.artifactPropertiesOverriddenMap);
        Assert.assertThat((Object)this.properties.getProperty((Object)OVERRIDE_PROPERTY_KEY), (Matcher)Is.is((Object)ARTIFACT_PROPERTY_OVERRIDE_VALUE));
        MuleTestUtils.testWithSystemProperty((String)OVERRIDE_PROPERTY_KEY, (String)SYSTEM_PROPERTY_OVERRIDE_VALUE, () -> {
            this.properties = new DefaultArtifactProperties(this.configPropertiesOverriddenPropertyMap, this.springPropertiesOverriddenMap, this.artifactPropertiesOverriddenMap);
            Assert.assertThat((Object)this.properties.getProperty((Object)OVERRIDE_PROPERTY_KEY), (Matcher)Is.is((Object)SYSTEM_PROPERTY_OVERRIDE_VALUE));
        });
    }

    @Test(expected=UnsupportedOperationException.class)
    public void propertiesMapReturnsInmmutableMap() {
        new DefaultArtifactProperties(Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap()).toImmutableMap().put("key", "value");
    }

    @Test(expected=IllegalArgumentException.class)
    public void configMapCannotBeNull() {
        new DefaultArtifactProperties(null, Collections.emptyMap(), Collections.emptyMap());
    }

    @Test(expected=IllegalArgumentException.class)
    public void springPropertiesMapCannotBeNull() {
        new DefaultArtifactProperties(Collections.emptyMap(), null, Collections.emptyMap());
    }

    @Test(expected=IllegalArgumentException.class)
    public void artifactConfigMapCannotBeNull() {
        new DefaultArtifactProperties(Collections.emptyMap(), Collections.emptyMap(), null);
    }
}

