/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.config.bootstrap;

import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.core.config.bootstrap.BootstrapException;
import org.mule.runtime.core.config.bootstrap.BootstrapService;
import org.mule.runtime.core.config.bootstrap.PropertiesBootstrapServiceDiscoverer;
import org.mule.runtime.core.config.bootstrap.RegistryBootstrapDiscoverer;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class PropertiesBootstrapServiceDiscovererTestCase
extends AbstractMuleTestCase {
    @Test
    public void discoversServiceOnDefaultClassLoader() throws Exception {
        ClassLoader classLoader = (ClassLoader)Mockito.mock(ClassLoader.class);
        Enumeration enumeration = (Enumeration)Mockito.mock(Enumeration.class);
        Mockito.when((Object)enumeration.hasMoreElements()).thenReturn((Object)true).thenReturn((Object)true).thenReturn((Object)true).thenReturn((Object)false);
        URL resource = ((Object)((Object)this)).getClass().getClassLoader().getResource("META-INF/org/mule/runtime/core/config/registry-bootstrap.properties");
        Mockito.when(enumeration.nextElement()).thenReturn((Object)resource);
        Mockito.when(enumeration.nextElement()).thenReturn((Object)resource);
        Mockito.when(enumeration.nextElement()).thenReturn((Object)resource);
        Mockito.when(classLoader.getResources("META-INF/org/mule/runtime/core/config/registry-bootstrap.properties")).thenReturn((Object)enumeration);
        PropertiesBootstrapServiceDiscoverer propertiesBootstrapServiceDiscoverer = new PropertiesBootstrapServiceDiscoverer(classLoader);
        List services = propertiesBootstrapServiceDiscoverer.discover();
        MatcherAssert.assertThat((Object)services.size(), (Matcher)Matchers.is((Object)3));
    }

    @Test
    public void discoversMultipleServices() throws Exception {
        ArrayList<Properties> properties = new ArrayList<Properties>();
        properties.add(new Properties());
        properties.add(new Properties());
        this.doCustomClassLoaderDiscoverTest(properties);
    }

    @Test
    public void discoversNoServices() throws Exception {
        this.doCustomClassLoaderDiscoverTest(new ArrayList<Properties>());
    }

    private void doCustomClassLoaderDiscoverTest(List<Properties> properties) throws BootstrapException {
        ClassLoader classLoader = (ClassLoader)Mockito.mock(ClassLoader.class);
        RegistryBootstrapDiscoverer registryBootstrapDiscoverer = (RegistryBootstrapDiscoverer)Mockito.mock(RegistryBootstrapDiscoverer.class);
        Mockito.when((Object)registryBootstrapDiscoverer.discover()).thenReturn(properties);
        PropertiesBootstrapServiceDiscoverer propertiesBootstrapServiceDiscoverer = new PropertiesBootstrapServiceDiscoverer(classLoader, registryBootstrapDiscoverer);
        List services = propertiesBootstrapServiceDiscoverer.discover();
        MatcherAssert.assertThat((Object)services.size(), (Matcher)Matchers.is((Object)properties.size()));
        for (int i = 0; i < services.size(); ++i) {
            MatcherAssert.assertThat((Object)((BootstrapService)services.get(i)).getProperties(), (Matcher)Matchers.is((Object)properties.get(i)));
        }
    }
}

