/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.config.bootstrap;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.DefaultMuleContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.core.api.registry.ResolverException;
import org.mule.runtime.core.api.registry.TransformerResolver;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.config.bootstrap.ArtifactType;
import org.mule.runtime.core.config.bootstrap.BootstrapServiceDiscoverer;
import org.mule.runtime.core.config.bootstrap.SimpleRegistryBootstrap;
import org.mule.runtime.core.config.bootstrap.TestBootstrapServiceDiscoverer;
import org.mule.runtime.core.config.builders.DefaultsConfigurationBuilder;
import org.mule.runtime.core.transformer.AbstractDiscoverableTransformer;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class SimpleRegistryBootstrapTransformersTest
extends AbstractMuleContextTestCase {
    @Test
    public void registeringTransformersWithCustomKey() throws MuleException {
        Properties properties = new Properties();
        properties.setProperty("core.transformer.1", ExpectedKeyTransformer.class.getName());
        properties.setProperty("custom1", CustomKeyTransformer.class.getName());
        TestTransformerResolver transformerResolver = new TestTransformerResolver();
        muleContext.getRegistry().registerObject("testTransformerResolver", (Object)transformerResolver);
        TestBootstrapServiceDiscoverer bootstrapServiceDiscoverer = new TestBootstrapServiceDiscoverer(properties);
        ((DefaultMuleContext)muleContext).setBootstrapServiceDiscoverer((BootstrapServiceDiscoverer)bootstrapServiceDiscoverer);
        SimpleRegistryBootstrap registryBootstrap = new SimpleRegistryBootstrap(ArtifactType.APP, muleContext);
        registryBootstrap.initialise();
        junit.framework.Assert.assertEquals((int)2, (int)transformerResolver.getTransformersCount());
        Assert.assertTrue((boolean)transformerResolver.contains(ExpectedKeyTransformer.class));
        Assert.assertTrue((boolean)transformerResolver.contains(CustomKeyTransformer.class));
    }

    protected ConfigurationBuilder getBuilder() throws Exception {
        return new DummyConfigurationBuilder();
    }

    private static class TestTransformerResolver
    implements TransformerResolver {
        private List<Transformer> transformers = new ArrayList<Transformer>();

        private TestTransformerResolver() {
        }

        public Transformer resolve(DataType source, DataType result) throws ResolverException {
            return null;
        }

        public void transformerChange(Transformer transformer, TransformerResolver.RegistryAction registryAction) {
            this.transformers.add(transformer);
        }

        public int getTransformersCount() {
            return this.transformers.size();
        }

        private boolean contains(Class<? extends Transformer> transformerClass) {
            for (Transformer transformer : this.transformers) {
                if (!transformerClass.isAssignableFrom(transformer.getClass())) continue;
                return true;
            }
            return false;
        }
    }

    public static class CustomKeyTransformer
    extends AbstractDiscoverableTransformer {
        protected Object doTransform(Object src, Charset enc) throws TransformerException {
            return null;
        }
    }

    public static class ExpectedKeyTransformer
    extends AbstractDiscoverableTransformer {
        protected Object doTransform(Object src, Charset enc) throws TransformerException {
            return null;
        }
    }

    private class DummyConfigurationBuilder
    extends DefaultsConfigurationBuilder {
        private DummyConfigurationBuilder() {
        }

        protected void doConfigure(MuleContext muleContext) throws Exception {
        }
    }
}

