/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.connection;

import org.hamcrest.core.IsInstanceOf;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.core.internal.connection.LifecycleAwareConnectionProviderWrapper;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class LifecycleAwareConnectionProviderWrapperTestCase
extends AbstractMuleContextTestCase {
    private static final String ERROR_MESSAGE = "BOOM ><";
    @Rule
    public ExpectedException exception = ExpectedException.none();
    @Mock
    private ConnectionProvider<Lifecycle> connectionProvider;
    @Mock
    private Lifecycle connection;
    private LifecycleAwareConnectionProviderWrapper<Lifecycle> wrapper;

    @Before
    public void before() throws Exception {
        Mockito.when((Object)this.connectionProvider.connect()).thenReturn((Object)this.connection);
        this.wrapper = new LifecycleAwareConnectionProviderWrapper(this.connectionProvider, muleContext);
        muleContext.start();
    }

    @Test
    public void connect() throws Exception {
        this.wrapper.connect();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.connection});
        ((Lifecycle)inOrder.verify((Object)this.connection)).initialise();
        ((Lifecycle)inOrder.verify((Object)this.connection)).start();
    }

    @Test
    public void disconnect() throws Exception {
        this.wrapper.connect();
        this.wrapper.disconnect((Object)this.connection);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.connection});
        ((Lifecycle)inOrder.verify((Object)this.connection)).initialise();
        ((Lifecycle)inOrder.verify((Object)this.connection)).start();
        ((Lifecycle)inOrder.verify((Object)this.connection)).stop();
        ((Lifecycle)inOrder.verify((Object)this.connection)).dispose();
    }

    @Test
    public void alwaysThrowConnectionException() throws ConnectionException {
        this.exception.expect(ConnectionException.class);
        this.exception.expectCause(IsInstanceOf.instanceOf(NullPointerException.class));
        this.exception.expectMessage(ERROR_MESSAGE);
        this.wrapper = new LifecycleAwareConnectionProviderWrapper((ConnectionProvider)new TestProvider(), muleContext);
        this.wrapper.connect();
    }

    private class TestProvider
    implements ConnectionProvider {
        private TestProvider() {
        }

        public Object connect() throws ConnectionException {
            throw new NullPointerException(LifecycleAwareConnectionProviderWrapperTestCase.ERROR_MESSAGE);
        }

        public void disconnect(Object connection) {
        }

        public ConnectionValidationResult validate(Object connection) {
            return ConnectionValidationResult.success();
        }
    }
}

