/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.construct;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategyFactory;
import org.mule.runtime.core.api.registry.RegistrationException;
import org.mule.runtime.core.processor.strategy.TransactionAwareWorkQueueProcessingStrategyFactory;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.tck.util.MuleContextUtils;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class FlowProcessingStrategyTestCase
extends AbstractMuleTestCase {
    protected MuleContext muleContext = MuleContextUtils.mockContextWithServices();
    @Mock
    private MuleConfiguration configuration;
    private Flow flow;

    @Before
    public void before() throws RegistrationException {
        Mockito.when((Object)this.muleContext.getConfiguration()).thenReturn((Object)this.configuration);
        this.createFlow();
    }

    @Test
    public void fixedProcessingStrategyIsHonoured() throws Exception {
        ProcessingStrategyFactory processingStrategyFactory = (ProcessingStrategyFactory)Mockito.mock(ProcessingStrategyFactory.class);
        this.createFlow();
        this.flow.setProcessingStrategyFactory(processingStrategyFactory);
        this.flow.initialise();
        Assert.assertThat((Object)this.flow.getProcessingStrategyFactory(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)processingStrategyFactory)));
    }

    @Test
    public void defaultProcessingStrategyInConfigIsHonoured() throws Exception {
        ProcessingStrategyFactory processingStrategyFactory = (ProcessingStrategyFactory)Mockito.mock(ProcessingStrategyFactory.class);
        Mockito.when((Object)this.configuration.getDefaultProcessingStrategyFactory()).thenReturn((Object)processingStrategyFactory);
        this.createFlow();
        this.flow.initialise();
        Assert.assertThat((Object)this.flow.getProcessingStrategyFactory(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)processingStrategyFactory)));
    }

    @Test
    public void fixedProcessingStrategyTakesPrecedenceOverConfig() throws Exception {
        ProcessingStrategyFactory configProcessingStrategyFactory = (ProcessingStrategyFactory)Mockito.mock(ProcessingStrategyFactory.class);
        Mockito.when((Object)this.configuration.getDefaultProcessingStrategyFactory()).thenReturn((Object)configProcessingStrategyFactory);
        ProcessingStrategyFactory processingStrategyFactory = (ProcessingStrategyFactory)Mockito.mock(ProcessingStrategyFactory.class);
        this.createFlow();
        this.flow.setProcessingStrategyFactory(processingStrategyFactory);
        this.flow.initialise();
        Assert.assertThat((Object)this.flow.getProcessingStrategyFactory(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)processingStrategyFactory)));
    }

    @Test
    public void createDefaultProcessingStrategyIfNoneSpecified() throws Exception {
        this.flow.initialise();
        Assert.assertThat((Object)this.flow.getProcessingStrategyFactory(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(TransactionAwareWorkQueueProcessingStrategyFactory.class)));
    }

    private void createFlow() {
        this.flow = Flow.builder((String)"test", (MuleContext)this.muleContext).build();
    }
}

