/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.construct.processor;

import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentMatcher;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.TransformationService;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.context.notification.EnrichedServerNotification;
import org.mule.runtime.core.api.context.notification.ServerNotification;
import org.mule.runtime.core.api.exception.MessagingExceptionHandler;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.MessageProcessorChainBuilder;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.config.DefaultMuleConfiguration;
import org.mule.runtime.core.context.notification.AsyncMessageNotification;
import org.mule.runtime.core.context.notification.PipelineMessageNotification;
import org.mule.runtime.core.context.notification.ServerNotificationManager;
import org.mule.runtime.core.exception.ErrorHandlerFactory;
import org.mule.runtime.core.exception.ErrorTypeLocator;
import org.mule.runtime.core.exception.Errors;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.internal.construct.DefaultFlowBuilder;
import org.mule.runtime.core.management.stats.AllStatistics;
import org.mule.tck.junit4.AbstractReactiveProcessorTestCase;
import org.mule.tck.util.MuleContextUtils;

@RunWith(value=Parameterized.class)
public class PipelineMessageNotificationTestCase
extends AbstractReactiveProcessorTestCase {
    private Event event;
    private ServerNotificationManager notificationManager;
    private TestPipeline pipeline;
    private final String pipelineName = "testPipeline";
    private EventContext context;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    public PipelineMessageNotificationTestCase(AbstractReactiveProcessorTestCase.Mode mode) {
        super(mode);
    }

    @Before
    public void createMocks() throws Exception {
        muleContext.dispose();
        muleContext = MuleContextUtils.mockContextWithServices();
        Mockito.when((Object)muleContext.getStatistics()).thenReturn((Object)new AllStatistics());
        Mockito.when((Object)muleContext.getConfiguration()).thenReturn((Object)new DefaultMuleConfiguration());
        Mockito.when((Object)muleContext.getDefaultErrorHandler()).thenReturn((Object)new ErrorHandlerFactory().createDefault());
        this.notificationManager = (ServerNotificationManager)Mockito.mock(ServerNotificationManager.class);
        Mockito.when((Object)muleContext.getNotificationManager()).thenReturn((Object)this.notificationManager);
        ErrorTypeLocator errorTypeLocator = (ErrorTypeLocator)Mockito.mock(ErrorTypeLocator.class);
        ErrorType errorType = (ErrorType)Mockito.mock(ErrorType.class);
        Mockito.when((Object)errorTypeLocator.lookupErrorType((Throwable)Matchers.any(Throwable.class))).thenReturn((Object)errorType);
        Mockito.when((Object)errorTypeLocator.lookupComponentErrorType((ComponentIdentifier)Matchers.any(ComponentIdentifier.class), (Throwable)Matchers.any(Throwable.class))).thenReturn((Object)errorType);
        Mockito.when((Object)muleContext.getErrorTypeLocator()).thenReturn((Object)errorTypeLocator);
        Mockito.when((Object)muleContext.getErrorTypeRepository().getErrorType(Errors.ComponentIdentifiers.UNKNOWN)).thenReturn(Optional.of(Mockito.mock(ErrorType.class)));
        this.pipeline = new TestPipeline("testPipeline", muleContext);
        Mockito.when((Object)muleContext.getTransformationService()).thenReturn((Object)new TransformationService(muleContext));
        this.context = DefaultEventContext.create((FlowConstruct)this.pipeline, (ComponentLocation)TEST_CONNECTOR_LOCATION);
    }

    @After
    public void after() throws MuleException {
        LifecycleUtils.stopIfNeeded((Object)((Object)this.pipeline));
        LifecycleUtils.stopIfNeeded((Object)muleContext.getSchedulerService());
    }

    @Test
    public void send() throws Exception {
        this.pipeline.initialise();
        this.pipeline.start();
        this.event = Event.builder((EventContext)this.context).message(Message.of((Object)"request")).flow((FlowConstruct)this.pipeline).build();
        this.process((Processor)this.pipeline, this.event);
        this.verifySucess();
    }

    @Test
    public void requestResponseException() throws Exception {
        this.pipeline.setExceptionListener((MessagingExceptionHandler)new ErrorHandlerFactory().createDefault());
        ArrayList<ExceptionThrowingMessageProcessor> processors = new ArrayList<ExceptionThrowingMessageProcessor>();
        processors.add(new ExceptionThrowingMessageProcessor());
        this.pipeline.setMessageProcessors(processors);
        this.pipeline.initialise();
        this.pipeline.start();
        this.event = Event.builder((EventContext)this.context).message(Message.of((Object)"request")).flow((FlowConstruct)this.pipeline).build();
        this.thrown.expect(CoreMatchers.instanceOf(MessagingException.class));
        this.thrown.expectCause(CoreMatchers.instanceOf(IllegalStateException.class));
        try {
            this.process((Processor)this.pipeline, this.event);
        }
        finally {
            this.verifyException();
        }
    }

    private void verifySucess() {
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)1))).fireNotification((ServerNotification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(1801, false, this.event)));
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)1))).fireNotification((ServerNotification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(1802, false, this.event)));
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)1))).fireNotification((ServerNotification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(1804, false, this.event)));
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)3))).fireNotification((ServerNotification)Matchers.any(PipelineMessageNotification.class));
    }

    private void verifyException() {
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)1))).fireNotification((ServerNotification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(1801, false, this.event)));
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)1))).fireNotification((ServerNotification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(1804, true, null)));
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)1))).fireNotification((ServerNotification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(2001, false, null)));
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)1))).fireNotification((ServerNotification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(2002, false, null)));
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)4))).fireNotification((ServerNotification)Matchers.any(PipelineMessageNotification.class));
    }

    public static class ExceptionThrowingMessageProcessor
    implements Processor {
        public Event process(Event event) throws MuleException {
            throw new IllegalStateException();
        }
    }

    private class PipelineMessageNotificiationArgumentMatcher
    extends ArgumentMatcher<PipelineMessageNotification> {
        private int expectedAction;
        private boolean exceptionExpected;
        private Event event;

        public PipelineMessageNotificiationArgumentMatcher(int expectedAction, boolean exceptionExpected, Event event) {
            this.expectedAction = expectedAction;
            this.exceptionExpected = exceptionExpected;
            this.event = event;
        }

        public boolean matches(Object argument) {
            EnrichedServerNotification notification = (EnrichedServerNotification)argument;
            MessagingException exception = null;
            if (notification instanceof PipelineMessageNotification) {
                exception = ((PipelineMessageNotification)notification).getException();
            } else if (notification instanceof AsyncMessageNotification) {
                exception = ((AsyncMessageNotification)notification).getException();
            }
            if (this.exceptionExpected) {
                return this.expectedAction == notification.getAction() && exception != null && notification.getMessage() != null && (this.event == null || this.event.getMessage().equals(notification.getMessage()));
            }
            return this.expectedAction == notification.getAction() && exception == null && notification.getMessage() != null && (this.event == null || this.event.getMessage().equals(notification.getMessage()));
        }
    }

    private class TestPipeline
    extends DefaultFlowBuilder.DefaultFlow {
        CountDownLatch latch;

        public TestPipeline(String name, MuleContext muleContext) {
            super(name, muleContext);
            this.latch = new CountDownLatch(2);
        }

        protected void configureMessageProcessors(MessageProcessorChainBuilder builder) throws MuleException {
            builder.chain(new Processor[]{event -> {
                this.latch.countDown();
                return event;
            }});
            super.configureMessageProcessors(builder);
        }

        protected void configurePostProcessors(MessageProcessorChainBuilder builder) throws MuleException {
            super.configurePostProcessors(builder);
            builder.chain(new Processor[]{event -> {
                this.latch.countDown();
                return event;
            }});
        }

        public String getConstructType() {
            return "test";
        }
    }
}

