/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.context.notification;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.meta.AnnotatedObject;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.construct.Pipeline;
import org.mule.runtime.core.api.context.notification.EnrichedNotificationInfo;
import org.mule.runtime.core.api.context.notification.FlowCallStack;
import org.mule.runtime.core.api.context.notification.ProcessorsTrace;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.config.DefaultMuleConfiguration;
import org.mule.runtime.core.context.notification.DefaultFlowCallStack;
import org.mule.runtime.core.context.notification.MessageProcessingFlowTraceManager;
import org.mule.runtime.core.context.notification.MessageProcessorNotification;
import org.mule.runtime.core.context.notification.PipelineMessageNotification;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class MessageProcessingFlowTraceManagerTestCase
extends AbstractMuleTestCase {
    private static QName docNameAttrName = new QName("http://www.mulesoft.org/schema/mule/documentation", "name");
    private static QName sourceFileNameAttrName = new QName("http://www.mulesoft.org/schema/mule/documentation", "sourceFileName");
    private static QName sourceFileLineAttrName = new QName("http://www.mulesoft.org/schema/mule/documentation", "sourceFileLine");
    private static final String NESTED_FLOW_NAME = "nestedFlow";
    private static final String ROOT_FLOW_NAME = "rootFlow";
    private static final String APP_ID = "MessageProcessingFlowTraceManagerTestCase";
    private static boolean originalFlowTrace;
    private MessageProcessingFlowTraceManager manager;
    private EventContext messageContext;
    private FlowConstruct rootFlowConstruct;
    private FlowConstruct nestedFlowConstruct;

    @BeforeClass
    public static void beforeClass() {
        originalFlowTrace = DefaultMuleConfiguration.flowTrace;
        DefaultMuleConfiguration.flowTrace = true;
    }

    @AfterClass
    public static void afterClass() {
        DefaultMuleConfiguration.flowTrace = originalFlowTrace;
    }

    @Before
    public void before() {
        this.manager = new MessageProcessingFlowTraceManager();
        MuleContext context = (MuleContext)Mockito.mock(MuleContext.class);
        MuleConfiguration config = (MuleConfiguration)Mockito.mock(MuleConfiguration.class);
        Mockito.when((Object)config.getId()).thenReturn((Object)APP_ID);
        Mockito.when((Object)context.getConfiguration()).thenReturn((Object)config);
        this.manager.setMuleContext(context);
        this.rootFlowConstruct = (FlowConstruct)Mockito.mock(FlowConstruct.class);
        Mockito.when((Object)this.rootFlowConstruct.getName()).thenReturn((Object)ROOT_FLOW_NAME);
        Mockito.when((Object)this.rootFlowConstruct.getMuleContext()).thenReturn((Object)context);
        this.nestedFlowConstruct = (FlowConstruct)Mockito.mock(FlowConstruct.class);
        Mockito.when((Object)this.nestedFlowConstruct.getName()).thenReturn((Object)NESTED_FLOW_NAME);
        Mockito.when((Object)this.nestedFlowConstruct.getMuleContext()).thenReturn((Object)context);
        this.messageContext = DefaultEventContext.create((FlowConstruct)this.rootFlowConstruct, (ComponentLocation)TEST_CONNECTOR_LOCATION);
    }

    @Test
    public void newFlowInvocation() {
        Event event = this.buildEvent("newFlowInvocation");
        PipelineMessageNotification pipelineNotification = this.buildPipelineNotification(event, this.rootFlowConstruct.getName());
        Assert.assertThat((Object)this.getContextInfo(event, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)""));
        this.manager.onPipelineNotificationStart(pipelineNotification);
        Assert.assertThat((Object)this.getContextInfo(event, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)("at " + this.rootFlowConstruct.getName())));
        this.manager.onPipelineNotificationComplete(pipelineNotification);
        Assert.assertThat((Object)this.getContextInfo(event, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)""));
    }

    @Test
    public void nestedFlowInvocations() {
        Event event = this.buildEvent("nestedFlowInvocations");
        PipelineMessageNotification pipelineNotification = this.buildPipelineNotification(event, this.rootFlowConstruct.getName());
        Assert.assertThat((Object)this.getContextInfo(event, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)""));
        this.manager.onPipelineNotificationStart(pipelineNotification);
        this.manager.onMessageProcessorNotificationPreInvoke(this.buildProcessorNotification(event, this.createMockProcessor("nestedFlow_ref")));
        PipelineMessageNotification pipelineNotificationNested = this.buildPipelineNotification(event, NESTED_FLOW_NAME);
        this.manager.onPipelineNotificationStart(pipelineNotificationNested);
        String rootEntry = "at " + this.rootFlowConstruct.getName() + "(" + NESTED_FLOW_NAME + "_ref @ " + APP_ID + ":null:null)";
        Assert.assertThat((Object)this.getContextInfo(event, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)("at nestedFlow" + System.lineSeparator() + rootEntry)));
        this.manager.onPipelineNotificationComplete(pipelineNotificationNested);
        Assert.assertThat((Object)this.getContextInfo(event, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)rootEntry));
        this.manager.onPipelineNotificationComplete(pipelineNotification);
        Assert.assertThat((Object)this.getContextInfo(event, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)""));
    }

    @Test
    public void newComponentCall() {
        Event event = this.buildEvent("newComponentCall");
        PipelineMessageNotification pipelineNotification = this.buildPipelineNotification(event, this.rootFlowConstruct.getName());
        Assert.assertThat((Object)this.getContextInfo(event, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)""));
        this.manager.onPipelineNotificationStart(pipelineNotification);
        Assert.assertThat((Object)this.getContextInfo(event, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)"at rootFlow"));
        this.manager.onMessageProcessorNotificationPreInvoke(this.buildProcessorNotification(event, this.createMockProcessor("/comp")));
        Assert.assertThat((Object)this.getContextInfo(event, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)"at rootFlow(/comp @ MessageProcessingFlowTraceManagerTestCase:null:null)"));
        this.manager.onPipelineNotificationComplete(pipelineNotification);
        Assert.assertThat((Object)this.getContextInfo(event, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)""));
    }

    protected String getContextInfo(Event event, FlowConstruct flow) {
        return (String)this.manager.getContextInfo(EnrichedNotificationInfo.createInfo((Event)event, null, null), null, flow).get("FlowStack");
    }

    @Test
    public void newAnnotatedComponentCall() {
        Event event = this.buildEvent("newAnnotatedComponentCall");
        PipelineMessageNotification pipelineNotification = this.buildPipelineNotification(event, this.rootFlowConstruct.getName());
        Assert.assertThat((Object)this.getContextInfo(event, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)""));
        this.manager.onPipelineNotificationStart(pipelineNotification);
        Assert.assertThat((Object)this.getContextInfo(event, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)("at " + this.rootFlowConstruct.getName())));
        AnnotatedObject annotatedMessageProcessor = (AnnotatedObject)this.createMockProcessor("/comp");
        Mockito.when((Object)annotatedMessageProcessor.getAnnotation(docNameAttrName)).thenReturn((Object)"annotatedName");
        Mockito.when((Object)annotatedMessageProcessor.getAnnotation(sourceFileNameAttrName)).thenReturn((Object)"muleApp.xml");
        Mockito.when((Object)annotatedMessageProcessor.getAnnotation(sourceFileLineAttrName)).thenReturn((Object)10);
        this.manager.onMessageProcessorNotificationPreInvoke(this.buildProcessorNotification(event, (Processor)annotatedMessageProcessor));
        Assert.assertThat((Object)this.getContextInfo(event, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)("at " + this.rootFlowConstruct.getName() + "(/comp @ " + APP_ID + ":muleApp.xml:10 (annotatedName))")));
        this.manager.onPipelineNotificationComplete(pipelineNotification);
        Assert.assertThat((Object)this.getContextInfo(event, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)""));
    }

    @Test
    public void splitStack() {
        Event event = this.buildEvent("newAnnotatedComponentCall");
        PipelineMessageNotification pipelineNotification = this.buildPipelineNotification(event, this.rootFlowConstruct.getName());
        Assert.assertThat((Object)this.getContextInfo(event, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)""));
        this.manager.onPipelineNotificationStart(pipelineNotification);
        Assert.assertThat((Object)this.getContextInfo(event, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)("at " + this.rootFlowConstruct.getName())));
        this.manager.onMessageProcessorNotificationPreInvoke(this.buildProcessorNotification(event, this.createMockProcessor("/comp")));
        Assert.assertThat((Object)this.getContextInfo(event, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)("at " + this.rootFlowConstruct.getName() + "(/comp @ " + APP_ID + ":null:null)")));
        Event eventCopy = this.buildEvent("newAnnotatedComponentCall", event.getFlowCallStack().clone());
        Assert.assertThat((Object)this.getContextInfo(eventCopy, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)("at " + this.rootFlowConstruct.getName() + "(/comp @ " + APP_ID + ":null:null)")));
        this.manager.onPipelineNotificationComplete(pipelineNotification);
        Assert.assertThat((Object)this.getContextInfo(event, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)""));
        FlowConstruct asyncFlowConstruct = (FlowConstruct)Mockito.mock(FlowConstruct.class);
        Mockito.when((Object)asyncFlowConstruct.getName()).thenReturn((Object)"asyncFlow");
        this.manager.onPipelineNotificationStart(this.buildPipelineNotification(eventCopy, asyncFlowConstruct.getName()));
        this.manager.onMessageProcessorNotificationPreInvoke(this.buildProcessorNotification(eventCopy, this.createMockProcessor("/asyncComp")));
        Assert.assertThat((Object)this.getContextInfo(eventCopy, asyncFlowConstruct), (Matcher)CoreMatchers.is((Object)("at " + asyncFlowConstruct.getName() + "(/asyncComp @ " + APP_ID + ":null:null)" + System.lineSeparator() + "at " + this.rootFlowConstruct.getName() + "(/comp @ " + APP_ID + ":null:null)")));
    }

    @Test
    public void splitStackEnd() {
        Event event = this.buildEvent("newAnnotatedComponentCall");
        PipelineMessageNotification pipelineNotification = this.buildPipelineNotification(event, this.rootFlowConstruct.getName());
        this.manager.onPipelineNotificationStart(pipelineNotification);
        this.manager.onMessageProcessorNotificationPreInvoke(this.buildProcessorNotification(event, this.createMockProcessor("/comp")));
        FlowCallStack flowCallStack = event.getFlowCallStack();
        Event eventCopy = this.buildEvent("newAnnotatedComponentCall", flowCallStack.clone());
        this.manager.onPipelineNotificationComplete(pipelineNotification);
        String asyncFlowName = "asyncFlow";
        this.manager.onPipelineNotificationStart(this.buildPipelineNotification(eventCopy, asyncFlowName));
        this.manager.onMessageProcessorNotificationPreInvoke(this.buildProcessorNotification(eventCopy, this.createMockProcessor("/asyncComp")));
        Assert.assertThat((Object)event.getContext().getProcessorsTrace(), this.hasExecutedProcessors("/comp @ MessageProcessingFlowTraceManagerTestCase:null:null", "/asyncComp @ MessageProcessingFlowTraceManagerTestCase:null:null"));
    }

    @Test
    public void joinStack() {
        Event event = this.buildEvent("joinStack");
        PipelineMessageNotification pipelineNotification = this.buildPipelineNotification(event, this.rootFlowConstruct.getName());
        Assert.assertThat((Object)this.getContextInfo(event, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)""));
        this.manager.onPipelineNotificationStart(pipelineNotification);
        Assert.assertThat((Object)this.getContextInfo(event, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)("at " + this.rootFlowConstruct.getName())));
        this.manager.onMessageProcessorNotificationPreInvoke(this.buildProcessorNotification(event, this.createMockProcessor("/scatter-gather")));
        Assert.assertThat((Object)this.getContextInfo(event, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)("at " + this.rootFlowConstruct.getName() + "(/scatter-gather @ " + APP_ID + ":null:null)")));
        Event eventCopy0 = this.buildEvent("joinStack_0", event.getFlowCallStack().clone());
        Event eventCopy1 = this.buildEvent("joinStack_1", event.getFlowCallStack().clone());
        this.manager.onMessageProcessorNotificationPreInvoke(this.buildProcessorNotification(eventCopy0, this.createMockProcessor("/route_0")));
        this.manager.onMessageProcessorNotificationPreInvoke(this.buildProcessorNotification(eventCopy1, this.createMockProcessor("nestedFlow_ref")));
        PipelineMessageNotification pipelineNotificationNested = this.buildPipelineNotification(eventCopy1, NESTED_FLOW_NAME);
        this.manager.onPipelineNotificationStart(pipelineNotificationNested);
        this.manager.onMessageProcessorNotificationPreInvoke(this.buildProcessorNotification(eventCopy1, this.createMockProcessor("/route_1")));
        Assert.assertThat((Object)this.getContextInfo(eventCopy1, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)("at nestedFlow(/route_1 @ MessageProcessingFlowTraceManagerTestCase:null:null)" + System.lineSeparator() + "at " + ROOT_FLOW_NAME + "(" + NESTED_FLOW_NAME + "_ref @ " + APP_ID + ":null:null)")));
        this.manager.onPipelineNotificationComplete(pipelineNotificationNested);
        Assert.assertThat((Object)this.getContextInfo(event, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)("at " + this.rootFlowConstruct.getName() + "(/scatter-gather @ " + APP_ID + ":null:null)")));
        this.manager.onPipelineNotificationComplete(pipelineNotification);
        Assert.assertThat((Object)this.getContextInfo(event, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)""));
    }

    public Processor createMockProcessor(String processorPath) {
        ComponentLocation componentLocation = (ComponentLocation)Mockito.mock(ComponentLocation.class);
        Mockito.when((Object)componentLocation.getLocation()).thenReturn((Object)processorPath);
        AnnotatedObject annotatedMessageProcessor = (AnnotatedObject)Mockito.mock(Processor.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{AnnotatedObject.class}).defaultAnswer(Mockito.RETURNS_DEEP_STUBS));
        Mockito.when((Object)annotatedMessageProcessor.getAnnotation((QName)Matchers.any())).thenReturn(null);
        Mockito.when((Object)annotatedMessageProcessor.getLocation()).thenReturn((Object)componentLocation);
        return (Processor)annotatedMessageProcessor;
    }

    @Test
    public void joinStackEnd() {
        Event event = this.buildEvent("joinStack");
        PipelineMessageNotification pipelineNotification = this.buildPipelineNotification(event, this.rootFlowConstruct.getName());
        this.manager.onPipelineNotificationStart(pipelineNotification);
        this.manager.onMessageProcessorNotificationPreInvoke(this.buildProcessorNotification(event, this.createMockProcessor("/scatter-gather")));
        FlowCallStack flowCallStack = event.getFlowCallStack();
        Event eventCopy0 = this.buildEvent("joinStack_0", flowCallStack.clone());
        Event eventCopy1 = this.buildEvent("joinStack_1", flowCallStack.clone());
        this.manager.onMessageProcessorNotificationPreInvoke(this.buildProcessorNotification(eventCopy0, this.createMockProcessor("/route_0")));
        this.manager.onMessageProcessorNotificationPreInvoke(this.buildProcessorNotification(eventCopy1, this.createMockProcessor("nestedFlow_ref")));
        PipelineMessageNotification pipelineNotificationNested = this.buildPipelineNotification(eventCopy1, NESTED_FLOW_NAME);
        this.manager.onPipelineNotificationStart(pipelineNotificationNested);
        this.manager.onMessageProcessorNotificationPreInvoke(this.buildProcessorNotification(eventCopy1, this.createMockProcessor("/route_1")));
        this.manager.onPipelineNotificationComplete(pipelineNotificationNested);
        this.manager.onPipelineNotificationComplete(pipelineNotification);
        Assert.assertThat((Object)event.getContext().getProcessorsTrace(), this.hasExecutedProcessors("/scatter-gather @ MessageProcessingFlowTraceManagerTestCase:null:null", "/route_0 @ MessageProcessingFlowTraceManagerTestCase:null:null", "nestedFlow_ref @ MessageProcessingFlowTraceManagerTestCase:null:null", "/route_1 @ MessageProcessingFlowTraceManagerTestCase:null:null"));
    }

    @Test
    public void mixedEvents() {
        Event event1 = this.buildEvent("mixedEvents_1");
        Event event2 = this.buildEvent("mixedEvents_2");
        PipelineMessageNotification pipelineNotification1 = this.buildPipelineNotification(event1, this.rootFlowConstruct.getName());
        PipelineMessageNotification pipelineNotification2 = this.buildPipelineNotification(event2, this.rootFlowConstruct.getName());
        Assert.assertThat((Object)this.getContextInfo(event1, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)""));
        Assert.assertThat((Object)this.getContextInfo(event2, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)""));
        this.manager.onPipelineNotificationStart(pipelineNotification1);
        Assert.assertThat((Object)this.getContextInfo(event1, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)("at " + this.rootFlowConstruct.getName())));
        Assert.assertThat((Object)this.getContextInfo(event2, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)""));
        this.manager.onPipelineNotificationStart(pipelineNotification2);
        Assert.assertThat((Object)this.getContextInfo(event1, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)("at " + this.rootFlowConstruct.getName())));
        Assert.assertThat((Object)this.getContextInfo(event2, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)("at " + this.rootFlowConstruct.getName())));
        this.manager.onPipelineNotificationComplete(pipelineNotification1);
        Assert.assertThat((Object)this.getContextInfo(event1, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)""));
        Assert.assertThat((Object)this.getContextInfo(event2, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)("at " + this.rootFlowConstruct.getName())));
        this.manager.onPipelineNotificationComplete(pipelineNotification2);
        Assert.assertThat((Object)this.getContextInfo(event1, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)""));
        Assert.assertThat((Object)this.getContextInfo(event2, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)""));
    }

    protected Event buildEvent(String eventId) {
        return this.buildEvent(eventId, (FlowCallStack)new DefaultFlowCallStack());
    }

    protected Event buildEvent(String eventId, FlowCallStack flowStack) {
        Event event = (Event)Mockito.mock(Event.class);
        Mockito.when((Object)event.getContext()).thenReturn((Object)this.messageContext);
        Mockito.when((Object)event.getFlowCallStack()).thenReturn((Object)flowStack);
        return event;
    }

    protected MessageProcessorNotification buildProcessorNotification(Event event, Processor processor) {
        return MessageProcessorNotification.createFrom((Event)event, null, (Processor)processor, null, (int)1601);
    }

    protected PipelineMessageNotification buildPipelineNotification(Event event, String name) {
        Pipeline flowConstruct = (Pipeline)Mockito.mock(Pipeline.class);
        Mockito.when((Object)flowConstruct.getName()).thenReturn((Object)name);
        return new PipelineMessageNotification(EnrichedNotificationInfo.createInfo((Event)event, null, null), flowConstruct, 1801);
    }

    private Matcher<ProcessorsTrace> hasExecutedProcessors(final String ... expectedProcessors) {
        return new TypeSafeMatcher<ProcessorsTrace>(){
            private List<Matcher> failed = new ArrayList<Matcher>();

            protected boolean matchesSafely(ProcessorsTrace processorsTrace) {
                Matcher sizeMatcher = IsCollectionWithSize.hasSize((int)expectedProcessors.length);
                if (!sizeMatcher.matches((Object)processorsTrace.getExecutedProcessors())) {
                    this.failed.add(sizeMatcher);
                }
                int i = 0;
                for (String expectedProcessor : expectedProcessors) {
                    Matcher processorItemMatcher = CoreMatchers.is((Object)expectedProcessor);
                    if (!processorItemMatcher.matches(processorsTrace.getExecutedProcessors().get(i))) {
                        this.failed.add(processorItemMatcher);
                    }
                    ++i;
                }
                return this.failed.isEmpty();
            }

            public void describeTo(Description description) {
                description.appendValue(Arrays.asList(expectedProcessors));
            }

            protected void describeMismatchSafely(ProcessorsTrace item, Description description) {
                description.appendText("was ").appendValue((Object)item.getExecutedProcessors());
            }
        };
    }
}

