/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.context.notification;

import java.util.Collections;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.LocationPart;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.context.notification.ServerNotification;
import org.mule.runtime.core.api.context.notification.ServerNotificationHandler;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.context.notification.ConnectorMessageNotification;
import org.mule.runtime.core.context.notification.NotificationHelper;
import org.mule.runtime.core.context.notification.ServerNotificationManager;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class NotificationHelperTestCase
extends AbstractMuleTestCase {
    @Mock
    private ServerNotificationHandler defaultNotificationHandler;
    @Mock
    private ServerNotificationManager eventNotificationHandler;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private Event event;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MuleContext muleContext;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private InternalMessage message;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MessageSource messageSource;
    private NotificationHelper helper;

    @Before
    public void before() {
        Mockito.when((Object)this.muleContext.getNotificationManager()).thenReturn((Object)this.eventNotificationHandler);
        Mockito.when((Object)this.event.getMessage()).thenReturn((Object)this.message);
        Mockito.when((Object)this.message.getPayload()).thenReturn((Object)new TypedValue((Object)"", DataType.STRING));
        this.initMocks((ServerNotificationHandler)this.eventNotificationHandler);
        this.initMocks(this.defaultNotificationHandler);
        this.helper = new NotificationHelper(this.defaultNotificationHandler, TestServerNotification.class, false);
    }

    private void initMocks(ServerNotificationHandler notificationHandler) {
        Mockito.when((Object)notificationHandler.isNotificationEnabled(TestServerNotification.class)).thenReturn((Object)true);
        Mockito.when((Object)notificationHandler.isNotificationEnabled(ConnectorMessageNotification.class)).thenReturn((Object)true);
    }

    @Test
    public void isNotificationEnabled() {
        Assert.assertThat((Object)this.helper.isNotificationEnabled(), (Matcher)CoreMatchers.is((Object)true));
        ((ServerNotificationHandler)Mockito.verify((Object)this.defaultNotificationHandler)).isNotificationEnabled(TestServerNotification.class);
    }

    @Test
    public void isNotificationEnabledForEvent() {
        Assert.assertThat((Object)this.helper.isNotificationEnabled(this.muleContext), (Matcher)CoreMatchers.is((Object)true));
        ((ServerNotificationManager)Mockito.verify((Object)this.eventNotificationHandler)).isNotificationEnabled(TestServerNotification.class);
    }

    @Test
    public void fireNotificationForEvent() {
        ComponentLocation location = (ComponentLocation)Mockito.mock(ComponentLocation.class);
        Mockito.when((Object)this.messageSource.getLocation()).thenReturn((Object)location);
        FlowConstruct flowConstruct = (FlowConstruct)Mockito.mock(FlowConstruct.class);
        Mockito.when((Object)flowConstruct.getMuleContext()).thenReturn((Object)this.muleContext);
        int action = 100;
        this.helper.fireNotification((Object)this.messageSource, this.event, flowConstruct, 100);
        this.assertConnectorMessageNotification((ServerNotificationHandler)this.eventNotificationHandler, this.messageSource, location, flowConstruct, 100);
    }

    @Test
    public void fireSpecificNotificationForEvent() {
        TestServerNotification notification = new TestServerNotification();
        this.helper.fireNotification((ServerNotification)notification, this.muleContext);
        ((ServerNotificationManager)Mockito.verify((Object)this.eventNotificationHandler)).fireNotification((ServerNotification)notification);
    }

    @Test
    public void fireSpecificNotificationOnDefaultHandler() {
        TestServerNotification notification = new TestServerNotification();
        this.helper.fireNotification((ServerNotification)notification);
        ((ServerNotificationHandler)Mockito.verify((Object)this.defaultNotificationHandler)).fireNotification((ServerNotification)notification);
    }

    @Test
    public void fireNotificationUsingLocation() {
        LocationPart flowPart = (LocationPart)Mockito.mock(LocationPart.class);
        Mockito.when((Object)flowPart.getPartPath()).thenReturn((Object)"flowName");
        ComponentLocation location = (ComponentLocation)Mockito.mock(ComponentLocation.class);
        Mockito.when((Object)location.getParts()).thenReturn(Collections.singletonList(flowPart));
        Mockito.when((Object)location.getComponentIdentifier()).thenReturn((Object)TypedComponentIdentifier.builder().withType(TypedComponentIdentifier.ComponentType.SOURCE).withIdentifier(ComponentIdentifier.buildFromStringRepresentation((String)"http:listener")).build());
        Mockito.when((Object)this.messageSource.getLocation()).thenReturn((Object)location);
        FlowConstruct flowConstruct = (FlowConstruct)Mockito.mock(FlowConstruct.class);
        Mockito.when((Object)flowConstruct.getMuleContext()).thenReturn((Object)this.muleContext);
        int action = 100;
        this.helper.fireNotification((Object)this.messageSource, this.event, flowConstruct, 100);
        this.assertConnectorMessageNotification((ServerNotificationHandler)this.eventNotificationHandler, this.messageSource, location, flowConstruct, 100);
    }

    private void assertConnectorMessageNotification(ServerNotificationHandler notificationHandler, MessageSource messageSource, ComponentLocation location, FlowConstruct flowConstruct, int action) {
        ArgumentCaptor notificationCaptor = ArgumentCaptor.forClass(ConnectorMessageNotification.class);
        ((ServerNotificationHandler)Mockito.verify((Object)notificationHandler)).fireNotification((ServerNotification)notificationCaptor.capture());
        ConnectorMessageNotification notification = (ConnectorMessageNotification)notificationCaptor.getValue();
        Assert.assertThat((Object)notification.getComponent(), (Matcher)CoreMatchers.is((Object)messageSource));
        Assert.assertThat((Object)notification.getAction(), (Matcher)CoreMatchers.is((Object)action));
        Assert.assertThat((Object)notification.getFlowConstruct(), (Matcher)CoreMatchers.is((Object)flowConstruct));
        Assert.assertThat((Object)notification.getComponent().getLocation(), (Matcher)CoreMatchers.is((Object)location));
    }

    private class TestServerNotification
    extends ServerNotification {
        public TestServerNotification() {
            super((Object)"", 0);
        }
    }
}

