/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.el;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.SystemUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.message.NullAttributes;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.config.MuleManifest;
import org.mule.runtime.core.el.AbstractWeaveExpressionLanguageTestCase;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.message.BaseAttributes;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;

@Features(value={"Expression Language"})
@Stories(value={"Support DW"})
public class DataWeaveExpressionLanguageAdaptorTestCase
extends AbstractWeaveExpressionLanguageTestCase {
    @Rule
    public ExpectedException expectedEx = ExpectedException.none();

    @Test
    public void stringExpression() throws Exception {
        TypedValue result = this.expressionLanguage.evaluate("\"hey\"", this.testEvent(), BindingContext.builder().build());
        Assert.assertThat((Object)result.getValue(), (Matcher)Matchers.is((Object)"hey"));
        Assert.assertThat((Object)result.getDataType(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)DataType.STRING)));
    }

    @Test
    public void withPrefixExpression() throws Exception {
        TypedValue result = this.expressionLanguage.evaluate("#[dw:\"hey\"]", this.testEvent(), BindingContext.builder().build());
        Assert.assertThat((Object)result.getValue(), (Matcher)Matchers.is((Object)"hey"));
        Assert.assertThat((Object)result.getDataType(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)DataType.STRING)));
    }

    @Test
    public void attributesBinding() throws Exception {
        Event event = this.getEventWithError(Optional.empty());
        SomeAttributes attributes = new SomeAttributes();
        InternalMessage message = (InternalMessage)Message.builder().nullPayload().attributes((Object)attributes).build();
        Mockito.when((Object)event.getMessage()).thenReturn((Object)message);
        TypedValue result = this.expressionLanguage.evaluate("attributes", event, BindingContext.builder().build());
        Assert.assertThat((Object)result.getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((Object)attributes))));
        Assert.assertThat((Object)result.getDataType().getType(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(SomeAttributes.class)));
    }

    @Test
    public void splitByJson() throws Exception {
        Event jsonMessage = DataWeaveExpressionLanguageAdaptorTestCase.eventBuilder().message(Message.builder().payload((Object)"[1,2,3]").mediaType(MediaType.APPLICATION_JSON).build()).build();
        Iterator payload = this.expressionLanguage.split("payload", jsonMessage, BindingContext.builder().build());
        Assert.assertThat((Object)payload.hasNext(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((TypedValue)payload.next()).getValue().toString(), (Matcher)Matchers.is((Object)"1"));
        Assert.assertThat((Object)payload.hasNext(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((TypedValue)payload.next()).getValue().toString(), (Matcher)Matchers.is((Object)"2"));
        Assert.assertThat((Object)payload.hasNext(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((TypedValue)payload.next()).getValue().toString(), (Matcher)Matchers.is((Object)"3"));
        Assert.assertThat((Object)payload.hasNext(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void expectedOutputShouldBeUsed() throws Exception {
        Event jsonMessage = DataWeaveExpressionLanguageAdaptorTestCase.eventBuilder().message(Message.builder().payload((Object)"{\"student\": false}").mediaType(MediaType.APPLICATION_JSON).build()).build();
        TypedValue result = this.expressionLanguage.evaluate("payload.student", DataType.BOOLEAN, jsonMessage, BindingContext.builder().build());
        Assert.assertThat((Object)result.getValue(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void errorBinding() throws Exception {
        Error error = (Error)Mockito.mock(Error.class);
        Optional<Error> opt = Optional.of(error);
        Event event = this.getEventWithError(opt);
        ((Event)Mockito.doReturn((Object)this.testEvent().getMessage()).when((Object)event)).getMessage();
        TypedValue result = this.expressionLanguage.evaluate("error", event, BindingContext.builder().build());
        Assert.assertThat((Object)result.getValue(), (Matcher)Matchers.is((Matcher)Matchers.sameInstance((Object)error)));
    }

    @Test
    public void errorMessageContainsDataweaveExceptionCauseMessage() throws Exception {
        Error error = (Error)Mockito.mock(Error.class);
        Optional<Error> opt = Optional.of(error);
        Event event = this.getEventWithError(opt);
        ((Event)Mockito.doReturn((Object)this.testEvent().getMessage()).when((Object)event)).getMessage();
        String expressionThatThrowsException = "payload + 'foo'";
        this.expectedEx.expect(ExpressionRuntimeException.class);
        this.expectedEx.expectMessage(Matchers.containsString((String)"You called the function '+' with these arguments"));
        this.expectedEx.expectMessage(Matchers.containsString((String)("evaluating expression: \"" + expressionThatThrowsException)));
        this.expressionLanguage.evaluate(expressionThatThrowsException, event, BindingContext.builder().build());
    }

    @Test
    public void payloadBinding() throws Exception {
        Event event = this.getEventWithError(Optional.empty());
        InternalMessage message = (InternalMessage)Mockito.mock(InternalMessage.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)event.getMessage()).thenReturn((Object)message);
        TypedValue payload = new TypedValue((Object)"hey", DataType.STRING);
        TypedValue attributes = new TypedValue(null, DataType.OBJECT);
        Mockito.when((Object)message.getPayload()).thenReturn((Object)payload);
        Mockito.when((Object)message.getAttributes()).thenReturn((Object)attributes);
        TypedValue result = this.expressionLanguage.evaluate("payload", event, BindingContext.builder().build());
        Assert.assertThat((Object)result.getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)payload.getValue())));
        Assert.assertThat((Object)result.getDataType(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)payload.getDataType())));
    }

    @Test
    public void dataTypeBinding() throws Exception {
        Event event = this.getEventWithError(Optional.empty());
        InternalMessage message = (InternalMessage)Mockito.mock(InternalMessage.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)event.getMessage()).thenReturn((Object)message);
        TypedValue payload = new TypedValue((Object)"hey", DataType.STRING);
        TypedValue attributes = new TypedValue(null, DataType.OBJECT);
        Mockito.when((Object)message.getPayload()).thenReturn((Object)payload);
        Mockito.when((Object)message.getAttributes()).thenReturn((Object)attributes);
        TypedValue result = this.expressionLanguage.evaluate("dataType", event, BindingContext.builder().build());
        Assert.assertThat((Object)result.getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)DataType.STRING)));
        Assert.assertThat((Object)DataType.fromType(DataType.class).isCompatibleWith(result.getDataType()), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void variablesBindings() throws Exception {
        Event event = this.getEventWithError(Optional.empty());
        String var1 = "var1";
        String var2 = "var2";
        Mockito.when((Object)event.getVariableNames()).thenReturn((Object)Sets.newHashSet((Object[])new String[]{var1, var2}));
        TypedValue varValue = new TypedValue(null, DataType.OBJECT);
        Mockito.when((Object)event.getVariable(var1)).thenReturn((Object)varValue);
        Mockito.when((Object)event.getVariable(var2)).thenReturn((Object)varValue);
        TypedValue result = this.expressionLanguage.evaluate("variables", event, BindingContext.builder().build());
        Assert.assertThat((Object)result.getValue(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(Map.class)));
        Assert.assertThat((Object)((Map)result.getValue()), (Matcher)Matchers.hasEntry((Object)var1, (Object)varValue));
        Assert.assertThat((Object)((Map)result.getValue()), (Matcher)Matchers.hasEntry((Object)var2, (Object)varValue));
    }

    @Test
    public void singleVariableBindings() throws Exception {
        Event event = this.getEventWithError(Optional.empty());
        String var1 = "var1";
        String var2 = "var2";
        Mockito.when((Object)event.getVariableNames()).thenReturn((Object)Sets.newHashSet((Object[])new String[]{var1, var2}));
        String varValue = "mangoose";
        TypedValue var = new TypedValue((Object)varValue, DataType.STRING);
        Mockito.when((Object)event.getVariable(var1)).thenReturn((Object)var);
        Mockito.when((Object)event.getVariable(var2)).thenReturn((Object)var);
        TypedValue resultVar1 = this.expressionLanguage.evaluate(var1, event, BindingContext.builder().build());
        Assert.assertThat((Object)resultVar1.getValue(), (Matcher)Matchers.is((Object)varValue));
        Assert.assertThat((Object)resultVar1.getDataType(), (Matcher)Matchers.is((Object)DataType.STRING));
        TypedValue resultVar2 = this.expressionLanguage.evaluate(var2, event, BindingContext.builder().build());
        Assert.assertThat((Object)resultVar2.getValue(), (Matcher)Matchers.is((Object)varValue));
        Assert.assertThat((Object)resultVar2.getDataType(), (Matcher)Matchers.is((Object)DataType.STRING));
    }

    @Test
    public void variablesCannotOverrideEventBindings() throws MuleException {
        Event event = (Event)Mockito.spy((Object)this.testEvent());
        HashSet variables = Sets.newHashSet((Object[])new String[]{"payload", "attributes", "error", "variables", "flow"});
        Mockito.when((Object)event.getVariableNames()).thenReturn((Object)variables);
        TypedValue varValue = new TypedValue((Object)"", DataType.STRING);
        variables.forEach(var -> ((Event)Mockito.doReturn((Object)varValue).when((Object)event)).getVariable(var));
        FlowConstruct mockFlowConstruct = (FlowConstruct)Mockito.mock(FlowConstruct.class);
        String flowName = "myFlowName";
        Mockito.when((Object)mockFlowConstruct.getName()).thenReturn((Object)flowName);
        Assert.assertThat((Object)this.expressionLanguage.evaluate("payload", event, BindingContext.builder().build()).getValue(), (Matcher)Matchers.is((Object)"test"));
        Assert.assertThat((Object)this.expressionLanguage.evaluate("attributes", event, BindingContext.builder().build()).getValue(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(NullAttributes.class)));
        Assert.assertThat((Object)this.expressionLanguage.evaluate("error", event, BindingContext.builder().build()).getValue(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)this.expressionLanguage.evaluate("variables", event, BindingContext.builder().build()).getValue(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(Map.class)));
        Assert.assertThat((Object)this.expressionLanguage.evaluate("flow.name", event, mockFlowConstruct, BindingContext.builder().build()).getValue(), (Matcher)Matchers.is((Object)flowName));
    }

    @Test
    public void propertiesBindings() throws Exception {
        Event event = this.getEventWithError(Optional.empty());
        String var1 = "var1";
        String var2 = "var2";
        TypedValue varValue = new TypedValue(null, DataType.OBJECT);
        HashMap<String, TypedValue> properties = new HashMap<String, TypedValue>();
        properties.put(var1, varValue);
        properties.put(var2, varValue);
        Mockito.when((Object)event.getProperties()).thenReturn(properties);
        TypedValue result = this.expressionLanguage.evaluate("properties", event, BindingContext.builder().build());
        Assert.assertThat((Object)result.getValue(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(Map.class)));
        Assert.assertThat((Object)((Map)result.getValue()), (Matcher)Matchers.hasEntry((Object)var1, (Object)varValue));
        Assert.assertThat((Object)((Map)result.getValue()), (Matcher)Matchers.hasEntry((Object)var2, (Object)varValue));
    }

    @Test
    public void parametersBindings() throws Exception {
        Event event = this.getEventWithError(Optional.empty());
        String var1 = "var1";
        String var2 = "var2";
        TypedValue varValue = new TypedValue(null, DataType.OBJECT);
        HashMap<String, TypedValue> parameters = new HashMap<String, TypedValue>();
        parameters.put(var1, varValue);
        parameters.put(var2, varValue);
        Mockito.when((Object)event.getParameters()).thenReturn(parameters);
        TypedValue result = this.expressionLanguage.evaluate("parameters", event, BindingContext.builder().build());
        Assert.assertThat((Object)result.getValue(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(Map.class)));
        Assert.assertThat((Object)((Map)result.getValue()), (Matcher)Matchers.hasEntry((Object)var1, (Object)varValue));
        Assert.assertThat((Object)((Map)result.getValue()), (Matcher)Matchers.hasEntry((Object)var2, (Object)varValue));
    }

    @Test
    public void accessRegistryBean() throws MuleException {
        Event event = this.testEvent();
        muleContext.getRegistry().registerObject("myBean", (Object)new MyBean("DataWeave"));
        TypedValue evaluate = this.expressionLanguage.evaluate("app.registry.myBean.name", event, BindingContext.builder().build());
        Assert.assertThat((Object)evaluate.getValue(), (Matcher)Matchers.is((Object)"DataWeave"));
    }

    @Test
    public void accessServerFileSeparator() throws MuleException {
        Event event = this.testEvent();
        muleContext.getRegistry().registerObject("myBean", (Object)new MyBean("DataWeave"));
        TypedValue evaluate = this.expressionLanguage.evaluate("server.fileSeparator", event, BindingContext.builder().build());
        Assert.assertThat((Object)evaluate.getValue(), (Matcher)Matchers.is((Object)SystemUtils.FILE_SEPARATOR));
    }

    @Test
    public void accessMuleVersion() throws MuleException {
        Event event = this.testEvent();
        muleContext.getRegistry().registerObject("myBean", (Object)new MyBean("DataWeave"));
        TypedValue evaluate = this.expressionLanguage.evaluate("mule.version", event, BindingContext.builder().build());
        Assert.assertThat((Object)evaluate.getValue(), (Matcher)Matchers.is((Object)MuleManifest.getProductVersion()));
    }

    @Test
    public void flowNameBinding() {
        Event event = this.getEventWithError(Optional.empty());
        FlowConstruct mockFlowConstruct = (FlowConstruct)Mockito.mock(FlowConstruct.class);
        String flowName = "myFlowName";
        Mockito.when((Object)mockFlowConstruct.getName()).thenReturn((Object)flowName);
        TypedValue result = this.expressionLanguage.evaluate("flow.name", event, mockFlowConstruct, BindingContext.builder().build());
        Assert.assertThat((Object)result.getDataType(), (Matcher)Matchers.is((Object)DataType.STRING));
        Assert.assertThat((Object)result.getValue(), (Matcher)Matchers.is((Object)flowName));
    }

    private Event getEventWithError(Optional<Error> error) {
        Event event = (Event)Mockito.mock(Event.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        ((Event)Mockito.doReturn(error).when((Object)event)).getError();
        Mockito.when((Object)event.getMessage().getPayload()).thenReturn((Object)new TypedValue(null, DataType.OBJECT));
        Mockito.when((Object)event.getMessage().getAttributes()).thenReturn((Object)new TypedValue(null, DataType.OBJECT));
        return event;
    }

    private class MyBean {
        private String name;

        public MyBean(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    private class SomeAttributes
    extends BaseAttributes {
        private SomeAttributes() {
        }
    }
}

