/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.el;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.DefaultExpressionLanguageFactoryService;
import org.mule.runtime.api.el.ExpressionFunction;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.FunctionParameter;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.registry.MuleRegistry;
import org.mule.runtime.core.el.DefaultExpressionManager;
import org.mule.runtime.core.el.mvel.MVELExpressionLanguage;
import org.mule.runtime.core.streaming.StreamingManager;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;

@Features(value={"Expression Language"})
@Stories(value={"Support both MVEL and DW"})
@RunWith(value=MockitoJUnitRunner.class)
public class DefaultExpressionManagerTestCase
extends AbstractMuleContextTestCase {
    private static final String MY_VAR = "myVar";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Mock
    private StreamingManager streamingManager;
    private ExtendedExpressionManager expressionManager;

    @Before
    public void setUp() {
        this.expressionManager = new DefaultExpressionManager(muleContext, this.streamingManager);
    }

    @Test
    @Description(value="Verifies that global bindings can be added.")
    public void globals() {
        final DataType integerType = DataType.fromType(Integer.class);
        ExpressionFunction multiply = new ExpressionFunction(){

            public Object call(Object[] objects, BindingContext bindingContext) {
                return (Integer)objects[0] * (Integer)objects[1];
            }

            public Optional<DataType> returnType() {
                return Optional.of(integerType);
            }

            public List<FunctionParameter> parameters() {
                return Arrays.asList(new FunctionParameter("x", integerType), new FunctionParameter("y", integerType));
            }
        };
        BindingContext globalContext = BindingContext.builder().addBinding("aNum", new TypedValue((Object)4, DataType.fromType(Integer.class))).addBinding("times", new TypedValue((Object)multiply, DataType.fromFunction((ExpressionFunction)multiply))).build();
        this.expressionManager.addGlobalBindings(globalContext);
        TypedValue result = this.expressionManager.evaluate("aNum times 5");
        Assert.assertThat((Object)result.getValue(), (Matcher)Matchers.is((Object)20));
        this.expressionManager.addGlobalBindings(BindingContext.builder().addBinding("otherNum", new TypedValue((Object)3, integerType)).build());
        result = this.expressionManager.evaluate("(times(7, 3) + otherNum) / aNum");
        Assert.assertThat((Object)result.getValue(), (Matcher)Matchers.is((Object)6));
    }

    @Test
    @Description(value="Verifies that a simple literal expression is successful.")
    public void simple() {
        String expression = "\"wow\"";
        this.assertString(expression);
    }

    @Test
    @Description(value="Verifies that a simple literal expression is successful when using brackets.")
    public void simpleEnclosed() {
        this.assertString("#[\"wow\"]");
    }

    private void assertString(String expression) {
        Assert.assertThat((Object)this.expressionManager.evaluate(expression).getValue(), (Matcher)Matchers.is((Object)"wow"));
    }

    @Test
    @Description(value="Verifies that a map expression is successful.")
    public void map() {
        String expression = "{'name' : 'Sarah', 'surname' : 'Manning'}";
        Object result = this.expressionManager.evaluate(expression).getValue();
        Assert.assertThat((Object)result, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(Map.class)));
        Assert.assertThat((Object)((Map)result), (Matcher)Matchers.hasEntry((Object)"name", (Object)"Sarah"));
        Assert.assertThat((Object)((Map)result), (Matcher)Matchers.hasEntry((Object)"surname", (Object)"Manning"));
    }

    @Test
    @Description(value="Verifies that custom variables are considered.")
    public void simpleCustomVariable() {
        Object object = new Object();
        BindingContext context = BindingContext.builder().addBinding(MY_VAR, new TypedValue(object, DataType.OBJECT)).build();
        Assert.assertThat((Object)this.expressionManager.evaluate("#[myVar]", context).getValue(), (Matcher)Matchers.equalTo((Object)object));
    }

    @Test
    @Description(value="Verifies that the flow variable exposing it's name works.")
    public void flowName() throws MuleException {
        FlowConstruct mockFlowConstruct = (FlowConstruct)Mockito.mock(FlowConstruct.class);
        Mockito.when((Object)mockFlowConstruct.getName()).thenReturn((Object)"myFlowName");
        String result = (String)this.expressionManager.evaluate("#[flow.name]", this.testEvent(), mockFlowConstruct).getValue();
        Assert.assertThat((Object)result, (Matcher)Matchers.is((Object)mockFlowConstruct.getName()));
    }

    @Test
    @Description(value="Verifies that payload variable works.")
    public void payloadVariable() throws MuleException {
        Assert.assertThat((Object)this.expressionManager.evaluate("payload", this.testEvent()).getValue(), (Matcher)Matchers.is((Object)"test"));
    }

    @Test
    @Description(value="Verifies that flowVars work, returning null for non existent ones and it's value for those that do.")
    public void flowVars() throws MuleException {
        Event.Builder eventBuilder = Event.builder((Event)this.testEvent());
        String flowVars = "variables.myVar";
        Assert.assertThat((Object)this.expressionManager.evaluate(flowVars, eventBuilder.build()).getValue(), (Matcher)Matchers.nullValue());
        String value = "Leda";
        eventBuilder.addVariable(MY_VAR, (Object)value);
        Assert.assertThat((Object)this.expressionManager.evaluate(flowVars, eventBuilder.build()).getValue(), (Matcher)Matchers.is((Object)value));
    }

    @Test
    @Description(value="Verifies that a simple transformation works.")
    public void transformation() throws MuleException {
        String expression = "payload";
        TypedValue result = this.expressionManager.evaluate(expression, DataType.BYTE_ARRAY, BindingContext.builder().build(), this.testEvent());
        Assert.assertThat((Object)result.getValue(), (Matcher)Matchers.is((Object)"test".getBytes()));
        Assert.assertThat((Object)result.getDataType(), (Matcher)Matchers.is((Object)DataType.BYTE_ARRAY));
    }

    @Test
    @Description(value="Verifies that a simple transformation works even when it's not required.")
    public void transformationNotNeeded() throws MuleException {
        String expression = "payload";
        TypedValue result = this.expressionManager.evaluate(expression, DataType.STRING, BindingContext.builder().build(), this.testEvent());
        Assert.assertThat((Object)result.getValue(), (Matcher)Matchers.is((Object)"test"));
        Assert.assertThat((Object)result.getDataType(), (Matcher)Matchers.is((Object)DataType.STRING));
    }

    @Test
    @Description(value="Verifies that parsing works with inner expressions in MVEL but only with regular ones in DW.")
    public void parseCompatibility() throws MuleException {
        Assert.assertThat((Object)this.expressionManager.parse("this is #[mel:payload]", this.testEvent(), (FlowConstruct)Mockito.mock(FlowConstruct.class)), (Matcher)Matchers.is((Object)String.format("this is %s", "test")));
        Assert.assertThat((Object)this.expressionManager.parse("#['this is ' ++ payload]", this.testEvent(), (FlowConstruct)Mockito.mock(FlowConstruct.class)), (Matcher)Matchers.is((Object)String.format("this is %s", "test")));
        this.expectedException.expect(RuntimeException.class);
        this.expressionManager.parse("this is #[payload]", this.testEvent(), (FlowConstruct)Mockito.mock(FlowConstruct.class));
    }

    @Test
    @Description(value="Verifies that parsing works for plain String scenarios.")
    public void parse() throws MuleException {
        String expression = "this is a test";
        Assert.assertThat((Object)this.expressionManager.parse(expression, this.testEvent(), (FlowConstruct)Mockito.mock(FlowConstruct.class)), (Matcher)Matchers.is((Object)expression));
    }

    @Test
    public void isValid() {
        String expression = "2*2";
        Assert.assertThat((Object)this.expressionManager.isValid(expression), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void isInvalid() {
        String expression = "2*'2";
        Assert.assertThat((Object)this.expressionManager.isValid(expression), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void isExpression() {
        Assert.assertThat((Object)this.expressionManager.isExpression("2*2 + #[var]"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.expressionManager.isExpression("#[var]"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.expressionManager.isExpression("${var}"), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void managedCursor() throws Exception {
        MuleContext mockMuleContext = (MuleContext)Mockito.mock(MuleContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        DefaultExpressionLanguageFactoryService mockFactory = (DefaultExpressionLanguageFactoryService)Mockito.mock(DefaultExpressionLanguageFactoryService.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        ExpressionLanguage expressionLanguage = (ExpressionLanguage)Mockito.mock(ExpressionLanguage.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        CursorProvider cursorProvider = (CursorProvider)Mockito.mock(CursorProvider.class);
        MuleRegistry registry = mockMuleContext.getRegistry();
        ((MuleRegistry)Mockito.doReturn((Object)mockFactory).when((Object)registry)).lookupObject(DefaultExpressionLanguageFactoryService.class);
        ((MuleRegistry)Mockito.doReturn((Object)Mockito.mock(MVELExpressionLanguage.class, (Answer)Mockito.RETURNS_DEEP_STUBS)).when((Object)registry)).lookupObject("_muleExpressionLanguage");
        TypedValue value = new TypedValue((Object)cursorProvider, DataType.BYTE_ARRAY);
        Mockito.when((Object)expressionLanguage.evaluate(org.mockito.Matchers.anyString(), (BindingContext)org.mockito.Matchers.any())).thenReturn((Object)value);
        Mockito.when((Object)expressionLanguage.evaluate(org.mockito.Matchers.anyString(), (DataType)org.mockito.Matchers.any(), (BindingContext)org.mockito.Matchers.any())).thenReturn((Object)value);
        Mockito.when((Object)mockFactory.create()).thenReturn((Object)expressionLanguage);
        this.expressionManager = new DefaultExpressionManager(mockMuleContext, this.streamingManager);
        Event event = this.testEvent();
        this.expressionManager.evaluate("someExpression", event);
        ((StreamingManager)Mockito.verify((Object)this.streamingManager)).manage(cursorProvider, event);
    }
}

