/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.el;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionModule;
import org.mule.runtime.api.el.ModuleNamespace;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class DefaultExpressionModuleBuilderTestCase
extends AbstractMuleTestCase {
    public static final String ID = "id";
    private TypedValue<String> typedValue = new TypedValue((Object)"", DataType.STRING);
    private ModuleNamespace namespace = new ModuleNamespace(new String[]{"org", "mule", "mymodule"});

    @Test
    public void shouldCreateTheModuleCorrectly() {
        ExpressionModule.Builder builder = ExpressionModule.builder((ModuleNamespace)this.namespace);
        builder.addBinding(ID, this.typedValue);
        ExpressionModule module = builder.build();
        Assert.assertThat((Object)module.bindings(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)module.identifiers(), (Matcher)CoreMatchers.hasItem((Object)ID));
        Assert.assertThat(module.lookup(ID).get(), (Matcher)Is.is((Matcher)CoreMatchers.sameInstance(this.typedValue)));
        Assert.assertThat((Object)module.namespace(), (Matcher)Is.is((Object)this.namespace));
    }

    @Test
    public void shouldBeAddedToBindingContext() {
        BindingContext.Builder bindingContextBuilder = BindingContext.builder();
        ExpressionModule.Builder builder = ExpressionModule.builder((ModuleNamespace)this.namespace);
        builder.addBinding(ID, this.typedValue);
        ExpressionModule module = builder.build();
        bindingContextBuilder.addModule(module);
        BindingContext bindingContext = bindingContextBuilder.build();
        Assert.assertThat((Object)bindingContext.modules(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)bindingContext.modules(), (Matcher)CoreMatchers.hasItem((Object)module));
    }
}

