/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.el;

import javax.activation.DataHandler;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.el.context.AbstractELTestCase;
import org.mule.runtime.core.el.mvel.MVELExpressionLanguage;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.tck.size.SmallTest;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Fruit;
import org.mule.tck.testmodels.fruit.FruitCleaner;

@SmallTest
public class ExpressionLanguageEnrichmentTestCase
extends AbstractELTestCase {
    protected MVELExpressionLanguage expressionLanguage;

    public ExpressionLanguageEnrichmentTestCase(String mvelOptimizer) {
        super(mvelOptimizer);
    }

    @Before
    public void setup() throws Exception {
        this.expressionLanguage = new MVELExpressionLanguage(muleContext);
        muleContext.getRegistry().registerObject("_muleExpressionLanguage", (Object)this.expressionLanguage);
    }

    @Test
    public void enrichReplacePayload() throws Exception {
        Event event = Event.builder((EventContext)this.context).message(Message.of((Object)"foo")).build();
        Event.Builder eventBuilder = Event.builder((Event)event);
        this.expressionLanguage.enrich("message.payload", event, eventBuilder, (FlowConstruct)this.flowConstruct, (Object)"bar");
        Assert.assertThat((Object)eventBuilder.build().getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"bar"));
    }

    @Test
    public void enrichObjectPayload() throws Exception {
        Apple apple = new Apple();
        FruitCleaner fruitCleaner = new FruitCleaner(){

            public void wash(Fruit fruit) {
            }

            public void polish(Fruit fruit) {
            }
        };
        Event event = Event.builder((EventContext)this.context).message(Message.of((Object)apple)).build();
        this.expressionLanguage.enrich("message.payload.appleCleaner", event, Event.builder((Event)event), (FlowConstruct)this.flowConstruct, (Object)fruitCleaner);
        Assert.assertThat((Object)apple.getAppleCleaner(), (Matcher)CoreMatchers.is((Object)fruitCleaner));
    }

    @Test
    public void enrichMessageProperty() throws Exception {
        Event event = Event.builder((EventContext)this.context).message(Message.of((Object)"foo")).build();
        Event.Builder eventBuilder = Event.builder((Event)event);
        this.expressionLanguage.enrich("message.outboundProperties.foo", event, eventBuilder, (FlowConstruct)this.flowConstruct, (Object)"bar");
        Assert.assertThat((Object)((InternalMessage)eventBuilder.build().getMessage()).getOutboundProperty("foo"), (Matcher)CoreMatchers.is((Object)"bar"));
    }

    @Test
    public void enrichMessageAttachment() throws Exception {
        DataHandler dataHandler = new DataHandler(new Object(), "test/xml");
        Event event = Event.builder((EventContext)this.context).message(Message.of((Object)"foo")).build();
        Event.Builder eventBuilder = Event.builder((Event)event);
        this.expressionLanguage.enrich("message.outboundAttachments.foo", event, eventBuilder, (FlowConstruct)this.flowConstruct, (Object)dataHandler);
        Assert.assertThat((Object)((InternalMessage)eventBuilder.build().getMessage()).getOutboundAttachment("foo"), (Matcher)CoreMatchers.is((Object)dataHandler));
    }

    @Test
    public void enrichFlowVariable() throws Exception {
        Event event = ExpressionLanguageEnrichmentTestCase.eventBuilder().message(Message.of((Object)"")).build();
        Event.Builder eventBuilder = Event.builder((Event)event);
        this.expressionLanguage.enrich("flowVars['foo']", event, eventBuilder, (FlowConstruct)this.flowConstruct, (Object)"bar");
        Assert.assertThat((Object)eventBuilder.build().getVariable("foo").getValue(), (Matcher)CoreMatchers.is((Object)"bar"));
        Assert.assertThat((Object)eventBuilder.build().getSession().getProperty("foo"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void enrichSessionVariable() throws Exception {
        Event event = ExpressionLanguageEnrichmentTestCase.eventBuilder().message(Message.of((Object)"")).build();
        Event.Builder eventBuilder = Event.builder((Event)event);
        this.expressionLanguage.enrich("sessionVars['foo']", event, eventBuilder, (FlowConstruct)this.flowConstruct, (Object)"bar");
        Assert.assertThat((Object)eventBuilder.build().getSession().getProperty("foo"), (Matcher)CoreMatchers.equalTo((Object)"bar"));
        Assert.assertThat((Object)eventBuilder.build().getVariableNames(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Object)"foo")));
    }

    @Test
    public void enrichWithDolarPlaceholder() throws Exception {
        Event event = Event.builder((EventContext)this.context).message(Message.of((Object)"")).build();
        Event.Builder eventBuilder = Event.builder((Event)event);
        this.expressionLanguage.enrich("message.outboundProperties.put('foo', $)", event, eventBuilder, (FlowConstruct)this.flowConstruct, (Object)"bar");
        Assert.assertThat((Object)((InternalMessage)eventBuilder.build().getMessage()).getOutboundProperty("foo"), (Matcher)CoreMatchers.is((Object)"bar"));
    }
}

