/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.el;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.mvel2.compiler.AbstractParser;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.el.ExpressionLanguageContext;
import org.mule.runtime.core.api.el.ExpressionLanguageExtension;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.api.registry.RegistrationException;
import org.mule.runtime.core.config.builders.DefaultsConfigurationBuilder;
import org.mule.runtime.core.context.notification.DefaultFlowCallStack;
import org.mule.runtime.core.el.context.AbstractELTestCase;
import org.mule.runtime.core.el.context.AppContext;
import org.mule.runtime.core.internal.message.InternalMessage;

public class ExpressionLanguageExtensionTestCase
extends AbstractELTestCase {
    private String a = "hi";
    private String b = "hi";

    public ExpressionLanguageExtensionTestCase(String mvelOptimizer) {
        super(mvelOptimizer);
    }

    protected ConfigurationBuilder getBuilder() throws Exception {
        return new DefaultsConfigurationBuilder(){

            public void configure(MuleContext muleContext) throws ConfigurationException {
                super.configure(muleContext);
                try {
                    muleContext.getRegistry().registerObject("key1", (Object)new TestExtension());
                }
                catch (RegistrationException e) {
                    throw new ConfigurationException((Throwable)e);
                }
            }
        };
    }

    @Test
    public void importClass() throws RegistrationException, InitialisationException {
        Assert.assertThat((Object)this.evaluate("Calendar"), (Matcher)CoreMatchers.equalTo(Calendar.class));
    }

    @Test
    public void importClassWithName() throws RegistrationException, InitialisationException {
        Assert.assertThat((Object)this.evaluate("CAL"), (Matcher)CoreMatchers.equalTo(Calendar.class));
    }

    @Test
    public void importStaticMethod() throws RegistrationException, InitialisationException {
        Assert.assertThat((Object)this.evaluate("dateFormat()"), (Matcher)CoreMatchers.is((Object)DateFormat.getInstance()));
    }

    @Test
    public void variable() throws RegistrationException, InitialisationException {
        Assert.assertThat((Object)this.evaluate("a"), (Matcher)CoreMatchers.is((Object)"hi"));
    }

    @Test
    public void assignValueToVariable() throws RegistrationException, InitialisationException {
        this.evaluate("a='1'");
    }

    @Test(expected=ExpressionRuntimeException.class)
    public void assignValueToFinalVariable() throws RegistrationException, InitialisationException {
        this.evaluate("final='1'");
    }

    @Test
    public void mutableVariable() throws RegistrationException, InitialisationException {
        Assert.assertThat((Object)this.evaluate("b"), (Matcher)CoreMatchers.is((Object)"hi"));
    }

    @Test
    public void assignValueToMutableVariable() throws RegistrationException, InitialisationException {
        Assert.assertThat((Object)this.evaluate("b='1'"), (Matcher)CoreMatchers.is((Object)"hi"));
        Assert.assertThat((Object)this.b, (Matcher)CoreMatchers.is((Object)"1"));
    }

    @Test
    public void testShortcutVariable() throws RegistrationException, InitialisationException {
        Assert.assertThat((Object)this.evaluate("appShortcut.name"), (Matcher)CoreMatchers.is((Object)muleContext.getConfiguration().getId()));
    }

    @Test
    public void testVariableAlias() throws Exception {
        Event event = Event.builder((EventContext)this.context).message(Message.of((Object)"foo")).build();
        Assert.assertThat((Object)this.evaluate("p", event), (Matcher)CoreMatchers.is((Object)"foo"));
    }

    @Test
    public void testAssignValueToVariableAlias() throws Exception {
        Event event = Event.builder((EventContext)this.context).message(Message.of((Object)"")).build();
        Event.Builder eventBuilder = Event.builder((Event)event);
        this.evaluate("p='bar'", event, eventBuilder);
        Assert.assertThat((Object)eventBuilder.build().getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"bar"));
    }

    @Test
    public void testMuleMessageAvailableAsVariable() throws Exception {
        Event event = Event.builder((EventContext)this.context).message(Message.of((Object)"")).build();
        this.evaluate("p=m.uniqueId", event);
    }

    @Test
    public void testFunction() throws RegistrationException, InitialisationException {
        Assert.assertThat((Object)this.evaluate("f('one','two')"), (Matcher)CoreMatchers.is((Object)("called param[0]=one,param[1]=two,app.name=" + muleContext.getConfiguration().getId())));
    }

    @Test
    public void testMuleContextAvailableInFunction() throws RegistrationException, InitialisationException {
        Assert.assertThat((Object)this.evaluate("muleContext()"), (Matcher)CoreMatchers.is((Object)muleContext));
    }

    @Test
    public void testMuleMessageAvailableInFunction() throws RegistrationException, InitialisationException {
        Event event = (Event)Mockito.mock(Event.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)event.getFlowCallStack()).thenReturn((Object)new DefaultFlowCallStack());
        Mockito.when((Object)event.getError()).thenReturn(Optional.empty());
        InternalMessage message = (InternalMessage)Mockito.mock(InternalMessage.class);
        Mockito.when((Object)event.getMessage()).thenReturn((Object)message);
        Assert.assertThat((Object)this.evaluate("muleMessage()", event), (Matcher)CoreMatchers.is((Object)message));
    }

    @Test(expected=ExpressionRuntimeException.class)
    public void testFunctionInvalidParams() throws RegistrationException, InitialisationException {
        this.evaluate("f('one')");
    }

    @Test
    public void testParserContextThreadLocalCleared() throws RegistrationException, InitialisationException {
        Assert.assertThat((Object)AbstractParser.contextControl((int)2, null, null), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        this.evaluate("f('one','two')");
        Assert.assertThat((Object)AbstractParser.contextControl((int)2, null, null), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    class TestExtension
    implements ExpressionLanguageExtension {
        TestExtension() {
        }

        public void configureContext(ExpressionLanguageContext context) {
            context.importClass(Calendar.class);
            context.importClass("CAL", Calendar.class);
            try {
                context.importStaticMethod("dateFormat", DateFormat.class.getMethod("getInstance", new Class[0]));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            context.addVariable("a", (Object)ExpressionLanguageExtensionTestCase.this.a);
            context.addVariable("b", (Object)ExpressionLanguageExtensionTestCase.this.b, (name, value, newValue) -> ExpressionLanguageExtensionTestCase.this.b = newValue);
            context.addAlias("appShortcut", "app");
            context.addFinalVariable("final", (Object)"final");
            context.addAlias("p", "message.payload");
            try {
                context.addAlias("m", "_muleMessage");
            }
            catch (Exception exception) {
                // empty catch block
            }
            context.declareFunction("f", (params, context1) -> "called param[0]=" + params[0] + ",param[1]=" + params[1] + ",app.name=" + ((AppContext)context1.getVariable("app")).getName());
            context.declareFunction("muleContext", (params, context1) -> context1.getVariable("_muleContext"));
            context.declareFunction("muleMessage", (params, context1) -> context1.getVariable("_muleMessage"));
        }
    }
}

