/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.el;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionFunction;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.FunctionParameter;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.el.GlobalBindingContextProvider;
import org.mule.runtime.core.api.registry.RegistrationException;
import org.mule.runtime.core.config.builders.DefaultsConfigurationBuilder;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.weave.v2.el.WeaveDefaultExpressionLanguageFactoryService;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;

@Features(value={"Expression Language"})
@Stories(value={"Support Functions"})
public class GlobalBindingContextProviderTestCase
extends AbstractMuleContextTestCase {
    public static final String KEY = "testProvider";

    protected ConfigurationBuilder getBuilder() throws Exception {
        return new DefaultsConfigurationBuilder(){

            public void configure(MuleContext muleContext) throws ConfigurationException {
                try {
                    WeaveDefaultExpressionLanguageFactoryService weaveExpressionExecutor = new WeaveDefaultExpressionLanguageFactoryService();
                    muleContext.getRegistry().registerObject(weaveExpressionExecutor.getName(), (Object)weaveExpressionExecutor);
                }
                catch (RegistrationException e) {
                    throw new ConfigurationException((Throwable)e);
                }
                super.configure(muleContext);
                try {
                    muleContext.getRegistry().registerObject(GlobalBindingContextProviderTestCase.KEY, (Object)new TestGlobalBindingContextProvider());
                }
                catch (RegistrationException e) {
                    throw new ConfigurationException((Throwable)e);
                }
            }
        };
    }

    @Test
    public void variable() {
        TypedValue result = muleContext.getExpressionManager().evaluate("number");
        Assert.assertThat((Object)result.getValue(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)DataType.NUMBER.isCompatibleWith(result.getDataType()), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void function() {
        TypedValue result = muleContext.getExpressionManager().evaluate("repeat('oa', 3)");
        Assert.assertThat((Object)result.getValue(), (Matcher)Matchers.is((Object)"oaoaoa"));
        Assert.assertThat((Object)result.getDataType(), (Matcher)Matchers.is((Object)DataType.STRING));
    }

    private class TestExpressionFunction
    implements ExpressionFunction {
        private TestExpressionFunction() {
        }

        public Object call(Object[] objects, BindingContext bindingContext) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < (Integer)objects[1]; ++i) {
                builder.append((String)objects[0]);
            }
            return builder.toString();
        }

        public Optional<DataType> returnType() {
            return Optional.of(DataType.STRING);
        }

        public List<FunctionParameter> parameters() {
            ArrayList<FunctionParameter> parameters = new ArrayList<FunctionParameter>();
            parameters.add(new FunctionParameter("word", DataType.STRING));
            parameters.add(new FunctionParameter("times", DataType.fromType(Integer.class), ctx -> 1));
            return parameters;
        }
    }

    private class TestGlobalBindingContextProvider
    implements GlobalBindingContextProvider {
        private TestGlobalBindingContextProvider() {
        }

        public BindingContext getBindingContext() {
            TestExpressionFunction function = new TestExpressionFunction();
            return BindingContext.builder().addBinding("number", new TypedValue((Object)1, DataType.NUMBER)).addBinding("repeat", new TypedValue((Object)function, DataType.fromFunction((ExpressionFunction)function))).build();
        }
    }
}

