/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.el.context;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.mvel2.ImmutableElementException;
import org.mule.mvel2.PropertyAccessException;
import org.mule.mvel2.optimizers.OptimizerFactory;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.el.ExtendedExpressionLanguageAdaptor;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.el.mvel.MVELExpressionLanguage;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

@RunWith(value=Parameterized.class)
public abstract class AbstractELTestCase
extends AbstractMuleContextTestCase {
    protected ExtendedExpressionLanguageAdaptor expressionLanguage;
    protected Flow flowConstruct;
    protected EventContext context;

    public AbstractELTestCase(String mvelOptimizer) {
        OptimizerFactory.setDefaultOptimizer((String)mvelOptimizer);
    }

    @Before
    public void setupFlowConstruct() throws Exception {
        this.flowConstruct = MuleTestUtils.getTestFlow((MuleContext)muleContext);
    }

    @Before
    public void setupMessageContext() throws Exception {
        this.context = DefaultEventContext.create((FlowConstruct)this.flowConstruct, (ComponentLocation)TEST_CONNECTOR_LOCATION);
    }

    @Before
    public void setupExpressionEvaluator() throws Exception {
        this.expressionLanguage = this.getExpressionLanguage();
        if (this.expressionLanguage instanceof Initialisable) {
            ((Initialisable)this.expressionLanguage).initialise();
        }
    }

    protected Object evaluate(String expression) {
        return this.evaluate(expression, null);
    }

    protected Object evaluate(String expression, Event event) {
        return this.evaluate(expression, event, event != null ? Event.builder((Event)event) : null);
    }

    protected Object evaluate(String expression, Event event, Event.Builder eventBuilder) {
        return this.expressionLanguage.evaluate(expression, event, eventBuilder, (FlowConstruct)this.flowConstruct, BindingContext.builder().build()).getValue();
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        return Arrays.asList({OptimizerFactory.DYNAMIC}, {OptimizerFactory.SAFE_REFLECTIVE});
    }

    protected ExtendedExpressionLanguageAdaptor getExpressionLanguage() {
        MVELExpressionLanguage el = new MVELExpressionLanguage(muleContext);
        return el;
    }

    protected void assertUnsupportedOperation(String expression) {
        try {
            this.evaluate(expression);
            Assert.fail((String)"ExpressionRuntimeException expected");
        }
        catch (ExpressionRuntimeException e) {
            Assert.assertEquals(UnsupportedOperationException.class, ExceptionUtils.getRootCause((Throwable)e).getClass());
        }
    }

    protected void assertUnsupportedOperation(String expression, Event event) {
        try {
            this.evaluate(expression, event);
            Assert.fail((String)"ExpressionRuntimeException expected");
        }
        catch (ExpressionRuntimeException e) {
            Assert.assertEquals(UnsupportedOperationException.class, ExceptionUtils.getRootCause((Throwable)e).getClass());
        }
    }

    protected void assertImmutableVariable(String expression) {
        try {
            this.evaluate(expression);
            Assert.fail((String)"ExpressionRuntimeException expected");
        }
        catch (ExpressionRuntimeException e) {
            Assert.assertEquals(ImmutableElementException.class, ExceptionUtils.getRootCause((Throwable)e).getClass());
        }
    }

    protected void assertImmutableVariable(String expression, Event event) {
        try {
            this.evaluate(expression, event);
            Assert.fail((String)"ExpressionRuntimeException expected");
        }
        catch (ExpressionRuntimeException e) {
            Assert.assertEquals(ImmutableElementException.class, ExceptionUtils.getRootCause((Throwable)e).getClass());
        }
    }

    protected void assertFinalProperty(String expression) {
        try {
            this.evaluate(expression);
            Assert.fail((String)"ExpressionRuntimeException expected");
        }
        catch (ExpressionRuntimeException e) {
            Assert.assertEquals(PropertyAccessException.class, ExceptionUtils.getRootCause((Throwable)e).getClass());
        }
    }

    protected void assertFinalProperty(String expression, Event event) {
        try {
            this.evaluate(expression, event);
            Assert.fail((String)"ExpressionRuntimeException expected");
        }
        catch (ExpressionRuntimeException e) {
            Assert.assertEquals(PropertyAccessException.class, ExceptionUtils.getRootCause((Throwable)e).getClass());
        }
    }

    public static enum Variant {
        EXPRESSION_MANAGER,
        EVALUATOR_LANGUAGE;

    }
}

