/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.el.context;

import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.core.api.registry.RegistrationException;
import org.mule.runtime.core.el.context.AbstractELTestCase;

public class AppContextTestCase
extends AbstractELTestCase {
    public AppContextTestCase(String mvelOptimizer) {
        super(mvelOptimizer);
    }

    @Test
    public void name() {
        Assert.assertEquals((Object)muleContext.getConfiguration().getId(), (Object)this.evaluate("app.name"));
    }

    public void assignValueToName() {
        this.assertFinalProperty("app.name='1'");
    }

    @Test
    public void encoding() {
        Assert.assertEquals((Object)muleContext.getConfiguration().getDefaultEncoding(), (Object)this.evaluate("app.encoding"));
    }

    public void assignValueToEncoding() {
        this.assertFinalProperty("app.encoding='1'");
    }

    @Test
    public void workDir() {
        Assert.assertEquals((Object)muleContext.getConfiguration().getWorkingDirectory(), (Object)this.evaluate("app.workDir"));
    }

    public void assignValueToWorkDir() {
        this.assertFinalProperty("app.workDir='1'");
    }

    @Test
    public void standalone() {
        Assert.assertFalse((String)muleContext.getClusterId(), (boolean)((Boolean)this.evaluate("app.standalone")));
    }

    public void assignValueToStandalone() {
        this.assertFinalProperty("app.standalone='1'");
    }

    @Test
    public void registryInstanceOfMap() {
        Assert.assertTrue((boolean)(this.evaluate("app.registry") instanceof Map));
    }

    public void assignValueToRegistry() {
        this.assertFinalProperty("app.registy='1'");
    }

    @Test
    public void registryGet() throws RegistrationException {
        Object o = new Object();
        muleContext.getRegistry().registerObject("myObject", o);
        Assert.assertEquals((Object)o, (Object)this.evaluate("app.registry.myObject"));
        Assert.assertEquals((Object)o, (Object)this.evaluate("app.registry['myObject']"));
    }

    @Test
    public void registryPut() throws RegistrationException {
        this.evaluate("app.registry.myString ='dan'");
        Assert.assertEquals((Object)"dan", (Object)muleContext.getRegistry().lookupObject("myString"));
    }

    @Test
    public void registryPutAll() throws RegistrationException {
        this.evaluate("app.registry.putAll({'1' :'one', '2' : 'two'})");
        Assert.assertEquals((Object)"one", (Object)muleContext.getRegistry().lookupObject("1"));
        Assert.assertEquals((Object)"two", (Object)muleContext.getRegistry().lookupObject("2"));
    }

    @Test
    public void registryContainsKey() throws RegistrationException {
        muleContext.getRegistry().registerObject("myString", (Object)"dan");
        Assert.assertTrue((boolean)((Boolean)this.evaluate("app.registry.containsKey('myString')")));
    }

    @Test
    public void registryEntrySet() {
        this.assertUnsupportedOperation("app.registry.entrySet()");
    }

    @Test
    public void registryIsEmpty() {
        Assert.assertFalse((boolean)((Boolean)this.evaluate("app.registry.isEmpty()")));
    }

    @Test
    public void registryClear() {
        this.assertUnsupportedOperation("app.registry.clear()");
    }

    @Test
    public void registryValues() {
        this.assertUnsupportedOperation("app.registry.values()");
    }

    @Test
    public void registrySize() {
        this.assertUnsupportedOperation("app.registry.size()");
    }

    @Test
    public void registryContainsValue() {
        this.assertUnsupportedOperation("app.registry.containsValue('foo')");
    }
}

