/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.el.context;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.el.context.AbstractELTestCase;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.tck.MuleTestUtils;

public class ExceptionTestCase
extends AbstractELTestCase {
    private Error mockError = (Error)Mockito.mock(Error.class);

    public ExceptionTestCase(String mvelOptimizer) {
        super(mvelOptimizer);
    }

    @Override
    public void setupFlowConstruct() throws Exception {
        this.flowConstruct = MuleTestUtils.getTestFlow((MuleContext)muleContext);
    }

    @Test
    public void exception() throws Exception {
        Event event = this.createEvent();
        RuntimeException rte = new RuntimeException();
        Mockito.when((Object)this.mockError.getCause()).thenReturn((Object)rte);
        event = Event.builder((Event)event).message((Message)InternalMessage.builder((Message)event.getMessage()).build()).build();
        Object exception = this.evaluate("exception", event);
        Assert.assertThat((Object)exception, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(MessagingException.class)));
        Assert.assertThat((Object)((MessagingException)((Object)exception)).getCause(), (Matcher)Matchers.is((Object)rte));
    }

    @Test
    public void assignException() throws Exception {
        Event event = this.createEvent();
        event = Event.builder((Event)event).message((Message)InternalMessage.builder((Message)event.getMessage()).build()).build();
        RuntimeException runtimeException = new RuntimeException();
        Mockito.when((Object)this.mockError.getCause()).thenReturn((Object)runtimeException);
        this.assertImmutableVariable("exception='other'", event);
    }

    @Test
    public void exceptionCausedBy() throws Exception {
        Event event = this.createEvent();
        Message message = event.getMessage();
        MessagingException me = new MessagingException(CoreMessages.createStaticMessage((String)""), Event.builder((EventContext)this.context).message(message).flow((FlowConstruct)this.flowConstruct).build(), (Throwable)new IllegalAccessException());
        Mockito.when((Object)this.mockError.getCause()).thenReturn((Object)me);
        Assert.assertTrue((boolean)((Boolean)this.evaluate("exception.causedBy(java.lang.IllegalAccessException)", event)));
    }

    private Event createEvent() throws Exception {
        return Event.builder((EventContext)this.context).message(Message.of((Object)"")).flow((FlowConstruct)this.flowConstruct).error(this.mockError).build();
    }
}

