/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.el.context;

import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.message.NullAttributes;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.TransformationService;
import org.mule.runtime.core.context.notification.DefaultFlowCallStack;
import org.mule.runtime.core.el.context.AbstractELTestCase;
import org.mule.runtime.core.el.context.MessageContext;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.message.GroupCorrelation;

public class MessageContextTestCase
extends AbstractELTestCase {
    private Event event;
    private Message message;

    public MessageContextTestCase(String mvelOptimizer) {
        super(mvelOptimizer);
    }

    @Before
    public void setup() {
        this.event = (Event)Mockito.mock(Event.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.event.getFlowCallStack()).thenReturn((Object)new DefaultFlowCallStack());
        Mockito.when((Object)this.event.getError()).thenReturn(Optional.empty());
        this.message = (Message)Mockito.spy((Object)Message.of(null));
        Mockito.when((Object)this.event.getGroupCorrelation()).thenReturn(Mockito.mock(GroupCorrelation.class));
        Mockito.when((Object)this.event.getMessage()).thenAnswer(invocation -> this.message);
    }

    @Test
    public void message() throws Exception {
        Event event = Event.builder((EventContext)this.context).message(Message.of((Object)"foo")).build();
        Assert.assertTrue((boolean)(this.evaluate("message", event) instanceof MessageContext));
        Assert.assertEquals((Object)"foo", (Object)this.evaluate("message.payload", event));
    }

    @Test
    public void assignToMessage() throws Exception {
        Event event = Event.builder((EventContext)this.context).message(Message.of((Object)"")).build();
        this.assertImmutableVariable("message='foo'", event);
    }

    @Test
    public void correlationId() throws Exception {
        Mockito.when((Object)this.event.getCorrelationId()).thenReturn((Object)"3");
        Assert.assertEquals((Object)"3", (Object)this.evaluate("message.correlationId", this.event));
        this.assertFinalProperty("message.correlationId=2", this.event);
    }

    @Test
    public void correlationSequence() throws Exception {
        Mockito.when((Object)this.event.getGroupCorrelation().getSequence()).thenReturn(Optional.of(4));
        Assert.assertEquals((Object)4, (Object)this.evaluate("message.correlationSequence", this.event));
        this.assertFinalProperty("message.correlationSequence=2", this.event);
    }

    @Test
    public void correlationGroupSize() throws Exception {
        Mockito.when((Object)this.event.getGroupCorrelation()).thenReturn((Object)new GroupCorrelation(null, Integer.valueOf(4)));
        Assert.assertEquals((Object)4, (Object)this.evaluate("message.correlationGroupSize", this.event));
        this.assertFinalProperty("message.correlationGroupSize=2", this.event);
    }

    @Test
    public void dataType() throws Exception {
        Mockito.when((Object)this.message.getPayload()).thenReturn((Object)new TypedValue((Object)"", DataType.STRING));
        Assert.assertThat((Object)this.evaluate("message.dataType", this.event), (Matcher)CoreMatchers.is((Object)DataType.STRING));
        this.assertFinalProperty("message.mimType=2", this.event);
    }

    @Test
    public void payload() throws Exception {
        InternalMessage message = (InternalMessage)Mockito.mock(InternalMessage.class);
        Mockito.when((Object)this.event.getMessage()).thenReturn((Object)message);
        Object payload = new Object();
        Mockito.when((Object)message.getPayload()).thenReturn((Object)new TypedValue(payload, DataType.OBJECT));
        Assert.assertSame((Object)payload, (Object)this.evaluate("message.payload", this.event));
    }

    @Test
    public void assignPayload() throws Exception {
        this.message = Message.of((Object)"");
        Event.Builder eventBuilder = Event.builder((Event)this.event);
        this.evaluate("message.payload = 'foo'", this.event, eventBuilder);
        Assert.assertThat((Object)eventBuilder.build().getMessage().getPayload().getValue(), (Matcher)CoreMatchers.equalTo((Object)"foo"));
    }

    @Test
    public void payloadAsType() throws Exception {
        InternalMessage transformedMessage = (InternalMessage)Mockito.mock(InternalMessage.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        TypedValue expectedPayload = new TypedValue(new Object(), DataType.OBJECT);
        Mockito.when((Object)transformedMessage.getPayload()).thenReturn((Object)expectedPayload);
        TransformationService transformationService = (TransformationService)Mockito.mock(TransformationService.class);
        muleContext.setTransformationService(transformationService);
        Mockito.when((Object)transformationService.transform((Message)Matchers.any(InternalMessage.class), (DataType)Matchers.any(DataType.class))).thenReturn((Object)transformedMessage);
        Assert.assertSame((Object)transformedMessage.getPayload().getValue(), (Object)this.evaluate("message.payloadAs(org.mule.tck.testmodels.fruit.Banana)", this.event));
    }

    @Test
    public void payloadAsDataType() throws Exception {
        InternalMessage transformedMessage = (InternalMessage)Mockito.mock(InternalMessage.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        TransformationService transformationService = (TransformationService)Mockito.mock(TransformationService.class);
        Mockito.when((Object)transformedMessage.getPayload()).thenReturn((Object)new TypedValue((Object)"test", DataType.STRING));
        muleContext.setTransformationService(transformationService);
        Mockito.when((Object)transformationService.transform(this.event.getMessage(), DataType.STRING)).thenReturn((Object)transformedMessage);
        Object result = this.evaluate("message.payloadAs(" + DataType.class.getName() + ".STRING)", this.event);
        Assert.assertSame((Object)"test", (Object)result);
    }

    @Test
    public void nullPayloadTest() throws Exception {
        Mockito.when((Object)this.message.getPayload()).thenReturn(null);
        Assert.assertEquals((Object)true, (Object)this.evaluate("message.payload == null", this.event));
        Assert.assertEquals((Object)true, (Object)this.evaluate("payload == null", this.event));
        Assert.assertEquals((Object)true, (Object)this.evaluate("message.payload == empty", this.event));
    }

    @Test
    public void attributes() throws Exception {
        NullAttributes attributes = NullAttributes.NULL_ATTRIBUTES;
        Mockito.when((Object)this.message.getAttributes()).thenReturn((Object)new TypedValue((Object)attributes, DataType.OBJECT));
        Assert.assertThat((Object)this.evaluate("message.attributes", this.event), (Matcher)CoreMatchers.is((Object)attributes));
    }
}

