/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.el.context;

import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.context.notification.DefaultFlowCallStack;
import org.mule.runtime.core.el.context.AbstractELTestCase;
import org.mule.runtime.core.internal.message.InternalMessage;

public class PayloadTestCase
extends AbstractELTestCase {
    private Event event;
    private Message message;
    private Event.Builder eventBuilder;

    public PayloadTestCase(String mvelOptimizer) {
        super(mvelOptimizer);
    }

    @Before
    public void setup() {
        this.event = (Event)Mockito.mock(Event.class);
        this.eventBuilder = (Event.Builder)Mockito.mock(Event.Builder.class);
        Mockito.when((Object)this.event.getFlowCallStack()).thenReturn((Object)new DefaultFlowCallStack());
        Mockito.when((Object)this.event.getError()).thenReturn(Optional.empty());
        this.message = (Message)Mockito.mock(InternalMessage.class);
        Mockito.when((Object)this.event.getMessage()).thenAnswer(invocation -> this.message);
    }

    @Test
    public void payload() throws Exception {
        Object payload = new Object();
        Mockito.when((Object)this.message.getPayload()).thenReturn((Object)new TypedValue(payload, DataType.OBJECT));
        Assert.assertSame((Object)payload, (Object)this.evaluate("payload", this.event));
    }

    @Test
    public void assignPayload() throws Exception {
        this.message = Message.of((Object)"");
        Mockito.when((Object)this.event.getMessage()).thenReturn((Object)this.message);
        this.evaluate("payload = 'foo'", this.event, this.eventBuilder);
        ArgumentCaptor argument = ArgumentCaptor.forClass(InternalMessage.class);
        ((Event.Builder)Mockito.verify((Object)this.eventBuilder)).message((Message)argument.capture());
        Assert.assertThat((Object)((InternalMessage)argument.getValue()).getPayload().getValue(), (Matcher)CoreMatchers.equalTo((Object)"foo"));
    }
}

