/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.el.context;

import java.io.Serializable;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.el.context.AbstractELTestCase;

public class VariablesTestCase
extends AbstractELTestCase {
    private Event event;

    public VariablesTestCase(String mvelOptimizer) {
        super(mvelOptimizer);
    }

    @Before
    public void setup() throws Exception {
        this.event = Event.builder((EventContext)this.context).message(Message.of((Object)"")).build();
    }

    @Test
    public void flowVariablesMap() throws Exception {
        this.event = Event.builder((Event)this.event).addVariable("foo", (Object)"bar").build();
        Assert.assertTrue((boolean)(this.evaluate("flowVars", this.event) instanceof Map));
    }

    @Test
    public void assignToFlowVariablesMap() throws Exception {
        this.assertImmutableVariable("flowVars='foo'", this.event);
    }

    @Test
    public void flowVariable() throws Exception {
        Message message = Message.of((Object)"");
        Event event = Event.builder((EventContext)this.context).message(message).flow((FlowConstruct)this.flowConstruct).addVariable("foo", (Object)"bar").build();
        Assert.assertEquals((Object)event.getVariable("foo").getValue(), (Object)this.evaluate("flowVars['foo']", event));
    }

    @Test
    public void assignValueToFlowVariable() throws Exception {
        Message message = Message.of((Object)"");
        Event event = Event.builder((EventContext)this.context).message(message).flow((FlowConstruct)this.flowConstruct).addVariable("foo", (Object)"bar_old").build();
        Event.Builder eventBuilder = Event.builder((Event)event);
        this.evaluate("flowVars['foo']='bar'", event, eventBuilder);
        Assert.assertEquals((Object)"bar", (Object)eventBuilder.build().getVariable("foo").getValue());
    }

    @Test
    public void assignValueToNewFlowVariable() throws Exception {
        Message message = Message.of((Object)"");
        Event event = Event.builder((EventContext)this.context).message(message).flow((FlowConstruct)this.flowConstruct).build();
        Event.Builder eventBuilder = Event.builder((Event)event);
        this.evaluate("flowVars['foo']='bar'", event, eventBuilder);
        Assert.assertEquals((Object)"bar", (Object)eventBuilder.build().getVariable("foo").getValue());
    }

    @Test
    public void sessionVariablesMap() throws Exception {
        Message message = Message.of((Object)"");
        Event event = Event.builder((EventContext)this.context).message(message).flow((FlowConstruct)this.flowConstruct).build();
        event.getSession().setProperty("foo", (Serializable)((Object)"bar"));
        Assert.assertTrue((boolean)(this.evaluate("sessionVars", event) instanceof Map));
    }

    @Test
    public void assignToSessionVariablesMap() throws Exception {
        this.assertImmutableVariable("sessionVars='foo'", this.event);
    }

    @Test
    public void sessionVariable() throws Exception {
        Message message = Message.of((Object)"");
        Event event = Event.builder((EventContext)this.context).message(message).flow((FlowConstruct)this.flowConstruct).build();
        event.getSession().setProperty("foo", (Serializable)((Object)"bar"));
        Assert.assertEquals((Object)event.getSession().getProperty("foo"), (Object)this.evaluate("sessionVars['foo']", event));
    }

    @Test
    public void assignValueToSessionVariable() throws Exception {
        Message message = Message.of((Object)"");
        Event event = Event.builder((EventContext)this.context).message(message).flow((FlowConstruct)this.flowConstruct).build();
        event.getSession().setProperty("foo", (Serializable)((Object)"bar_old"));
        this.evaluate("sessionVars['foo']='bar'", event);
        Assert.assertEquals((Object)"bar", (Object)event.getSession().getProperty("foo"));
    }

    @Test
    public void assignValueToNewSessionVariable() throws Exception {
        Message message = Message.of((Object)"");
        Event event = Event.builder((EventContext)this.context).message(message).flow((FlowConstruct)this.flowConstruct).build();
        this.evaluate("sessionVars['foo']='bar'", event);
        Assert.assertEquals((Object)"bar", (Object)event.getSession().getProperty("foo"));
    }

    @Test
    public void variableFromFlowScope() throws Exception {
        Message message = Message.of((Object)"");
        Event event = Event.builder((EventContext)this.context).message(message).flow((FlowConstruct)this.flowConstruct).addVariable("foo", (Object)"bar").build();
        event.getSession().setProperty("foo", (Serializable)((Object)"NOTbar"));
        Assert.assertEquals((Object)event.getVariable("foo").getValue(), (Object)this.evaluate("foo", event));
    }

    @Test
    public void updateVariableFromFlowScope() throws Exception {
        Message message = Message.of((Object)"");
        Event event = Event.builder((EventContext)this.context).message(message).flow((FlowConstruct)this.flowConstruct).addVariable("foo", (Object)"bar").build();
        Assert.assertEquals((Object)"bar_new", (Object)this.evaluate("foo='bar_new'", event));
    }

    @Test
    public void variableFromSessionScope() throws Exception {
        Message message = Message.of((Object)"");
        Event event = Event.builder((EventContext)this.context).message(message).flow((FlowConstruct)this.flowConstruct).build();
        event.getSession().setProperty("foo", (Serializable)((Object)"bar"));
        Assert.assertEquals((Object)event.getSession().getProperty("foo"), (Object)this.evaluate("foo", event));
    }

    @Test
    public void updateVariableFromSessionScope() throws Exception {
        Message message = Message.of((Object)"");
        Event event = Event.builder((EventContext)this.context).message(message).flow((FlowConstruct)this.flowConstruct).build();
        event.getSession().setProperty("foo", (Serializable)((Object)"bar"));
        Assert.assertEquals((Object)"bar_new", (Object)this.evaluate("foo='bar_new'", event));
    }

    @Test
    public void assignValueToVariable() throws Exception {
        Message message = Message.of((Object)"");
        Event event = Event.builder((EventContext)this.context).message(message).flow((FlowConstruct)this.flowConstruct).addVariable("foo", (Object)"bar_old").build();
        Event.Builder eventBuilder = Event.builder((Event)event);
        this.evaluate("foo='bar'", event, eventBuilder);
        Assert.assertEquals((Object)"bar", (Object)eventBuilder.build().getVariable("foo").getValue());
    }

    @Test
    public void assignValueToLocalVariable() throws Exception {
        Message message = Message.of((Object)"");
        Event event = Event.builder((EventContext)this.context).message(message).flow((FlowConstruct)this.flowConstruct).build();
        this.evaluate("localVar='bar'", event);
    }

    @Test
    public void reassignValueToLocalVariable() throws Exception {
        Message message = Message.of((Object)"");
        Event event = Event.builder((EventContext)this.context).message(message).flow((FlowConstruct)this.flowConstruct).build();
        this.evaluate("localVar='bar';localVar='bar2'", event);
    }

    @Test
    public void localVariable() throws Exception {
        Message message = Message.of((Object)"");
        Event event = Event.builder((EventContext)this.context).message(message).flow((FlowConstruct)this.flowConstruct).build();
        Assert.assertEquals((Object)"bar", (Object)this.evaluate("localVar='bar';localVar", event));
    }
}

