/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.el.datetime;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.bind.DatatypeConverter;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.core.api.el.datetime.Date;
import org.mule.runtime.core.api.el.datetime.Instant;
import org.mule.runtime.core.el.datetime.DateTime;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class DateTimeDateTestCase
extends AbstractMuleTestCase {
    private Calendar currentCalendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
    private Date now = new DateTime(this.currentCalendar).withTimeZone("UTC").getDate();

    @Test
    public void isBefore() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, 1);
        Assert.assertTrue((boolean)this.now.isBefore((Instant)new DateTime(cal).withTimeZone("UTC")));
    }

    @Test
    public void isAfter() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        Assert.assertTrue((boolean)this.now.isAfter((Instant)new DateTime(cal).withTimeZone("UTC")));
    }

    @Test
    public void format() {
        SimpleDateFormat df = new SimpleDateFormat("EEE, MMM d, yyyy");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        Assert.assertEquals((Object)df.format(this.now.toDate()), (Object)this.now.format("EEE, MMM d, yyyy"));
    }

    @Test
    public void timeZone() {
        Assert.assertEquals((Object)TimeZone.getTimeZone("UTC").getDisplayName(), (Object)this.now.getTimeZone());
    }

    @Test
    public void plusDays() {
        Assert.assertEquals((long)(this.currentCalendar.get(6) % this.currentCalendar.getActualMaximum(6) + 1), (long)this.now.plusDays(1).getDayOfYear());
    }

    @Test
    public void plusWeeks() {
        Assert.assertEquals((long)(this.currentCalendar.get(3) % this.currentCalendar.getWeeksInWeekYear() + 1), (long)this.now.plusWeeks(1).getWeekOfYear());
    }

    @Test
    public void plusMonths() {
        Assert.assertEquals((long)((this.currentCalendar.get(2) + 1) % 12 + 1), (long)this.now.plusMonths(1).getMonth());
    }

    @Test
    public void plusYears() {
        Assert.assertEquals((long)(this.currentCalendar.get(1) + 1), (long)this.now.plusYears(1).getYear());
    }

    @Test
    public void withLocale() {
        SimpleDateFormat df = new SimpleDateFormat("E", Locale.US);
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        Assert.assertEquals((Object)df.format(new java.util.Date()), (Object)this.now.withLocale("en_US").format("E"));
    }

    @Test
    public void dayOfWeek() {
        Assert.assertEquals((long)this.currentCalendar.get(7), (long)this.now.getDayOfWeek());
    }

    @Test
    public void dayOfMonth() {
        Assert.assertEquals((long)this.currentCalendar.get(5), (long)this.now.getDayOfMonth());
    }

    @Test
    public void dayOfYear() {
        Assert.assertEquals((long)this.currentCalendar.get(6), (long)this.now.getDayOfYear());
    }

    @Test
    public void weekOfMonth() {
        Assert.assertEquals((long)this.currentCalendar.get(4), (long)this.now.getWeekOfMonth());
    }

    @Test
    public void weekOfYear() {
        Assert.assertEquals((long)this.currentCalendar.get(3), (long)this.now.getWeekOfYear());
    }

    @Test
    public void monthOfYear() {
        Assert.assertEquals((long)(this.currentCalendar.get(2) + 1), (long)this.now.getMonth());
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)DatatypeConverter.printDate((Calendar)this.currentCalendar), (Object)this.now.toString());
    }

    @Test
    public void toDate() {
        Assert.assertEquals(java.util.Date.class, this.now.toDate().getClass());
    }

    @Test
    public void toCalendar() {
        Assert.assertEquals(GregorianCalendar.class, this.now.toCalendar().getClass());
    }

    @Test
    public void toXMLCalendar() throws DatatypeConfigurationException {
        Assert.assertTrue((boolean)(this.now.toXMLCalendar() instanceof XMLGregorianCalendar));
    }

    @Test
    public void fromDate() {
        java.util.Date date = new java.util.Date();
        date.setYear(0);
        date.setMonth(0);
        date.setDate(1);
        Assert.assertEquals((long)1900L, (long)new DateTime(date).getYear());
        Assert.assertEquals((long)1L, (long)new DateTime(date).getMonth());
        Assert.assertEquals((long)1L, (long)new DateTime(date).getDayOfMonth());
    }

    @Test
    public void fromCalendar() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(1, 1900);
        cal.set(2, 0);
        cal.set(5, 1);
        Assert.assertEquals((long)1900L, (long)new DateTime((Calendar)cal).getYear());
        Assert.assertEquals((long)1L, (long)new DateTime((Calendar)cal).getMonth());
        Assert.assertEquals((long)1L, (long)new DateTime((Calendar)cal).getDayOfMonth());
    }

    @Test
    public void fromXMLCalendar() throws DatatypeConfigurationException {
        XMLGregorianCalendar xmlCal = DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar());
        xmlCal.setYear(1900);
        xmlCal.setMonth(1);
        xmlCal.setDay(1);
        Assert.assertEquals((long)1900L, (long)new DateTime(xmlCal).getYear());
        Assert.assertEquals((long)1L, (long)new DateTime(xmlCal).getMonth());
        Assert.assertEquals((long)1L, (long)new DateTime(xmlCal).getDayOfMonth());
    }
}

