/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.el.datetime;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.bind.DatatypeConverter;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.core.api.el.datetime.Instant;
import org.mule.runtime.core.api.el.datetime.Time;
import org.mule.runtime.core.el.datetime.DateTime;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class DateTimeTimeTestCase
extends AbstractMuleTestCase {
    public static final int TWO_DAYS_IN_SECONDS = 172800;
    public static final int TWO_DAYS_IN_MINUTES = 2880;
    public static final int TWO_DAYS_IN_HOURS = 48;
    protected volatile Calendar calendarNow;
    protected volatile DateTime now;
    protected volatile DateTime before;
    protected volatile DateTime after;

    @Before
    public void setup() {
        this.calendarNow = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        GregorianCalendar calendarBefore = (GregorianCalendar)this.calendarNow.clone();
        calendarBefore.add(14, -10);
        GregorianCalendar calendarAfter = (GregorianCalendar)this.calendarNow.clone();
        calendarAfter.add(14, 10);
        this.before = new DateTime((Calendar)calendarBefore).withTimeZone("UTC");
        this.now = new DateTime((Calendar)((GregorianCalendar)this.calendarNow.clone())).withTimeZone("UTC");
        this.after = new DateTime((Calendar)calendarAfter).withTimeZone("UTC");
    }

    @Test
    public void milliSeconds() {
        Assert.assertThat((Object)this.now.getMilliSeconds(), (Matcher)Matchers.is((Object)this.calendarNow.get(14)));
    }

    @Test
    public void isBefore() {
        Assert.assertThat((Object)this.before.isBefore((Instant)this.now), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.before.isBefore((Instant)this.after), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.now.isBefore((Instant)this.after), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void isAfter() {
        Assert.assertThat((Object)this.after.isAfter((Instant)this.before), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.after.isAfter((Instant)this.now), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.now.isAfter((Instant)this.before), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void format() {
        SimpleDateFormat df = new SimpleDateFormat("hh:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        Assert.assertThat((Object)this.now.format("hh:mm:ss"), (Matcher)Matchers.is((Object)df.format(this.calendarNow.getTime())));
    }

    @Test
    public void timeZone() {
        Assert.assertThat((Object)this.now.getTimeZone(), (Matcher)Matchers.is((Object)TimeZone.getTimeZone("UTC").getDisplayName()));
    }

    @Test
    public void plusSeconds() {
        Assert.assertThat((Object)this.now.plusSeconds(1).getSeconds(), (Matcher)Matchers.is((Object)((this.calendarNow.get(13) + 1) % 60)));
    }

    @Test
    public void plusSecondsShouldKeepSameDayInRollover() {
        this.assertSameDay(this.now.getTime(), this.now.getTime().plusSeconds(172800));
    }

    @Test
    public void plusMinutes() {
        Assert.assertThat((Object)this.now.getTime().plusMinutes(1).getMinutes(), (Matcher)Matchers.is((Object)((this.calendarNow.get(12) + 1) % 60)));
    }

    @Test
    public void plusMinutesShouldKeepSameDayInRollover() {
        this.assertSameDay(this.now.getTime(), this.now.getTime().plusMinutes(2880));
    }

    @Test
    public void plusHours() {
        Assert.assertThat((Object)this.now.getTime().plusHours(1).getHours(), (Matcher)Matchers.is((Object)((this.calendarNow.get(11) + 1) % 24)));
    }

    @Test
    public void plusHoursShouldKeepSameDayInRollover() {
        this.assertSameDay(this.now.getTime(), this.now.getTime().plusHours(48));
    }

    private void assertSameDay(Time a, Time b) {
        Assert.assertThat((Object)a.toCalendar().get(6), (Matcher)Matchers.is((Object)b.toCalendar().get(6)));
    }

    @Test
    public void withTimeZone() {
        int hour = this.now.getHours();
        Assert.assertThat((Object)this.now.withTimeZone("GMT-03:00").getHours(), (Matcher)Matchers.is((Object)hour));
    }

    @Test
    public void changeTimeZone() {
        int hour = this.now.getHours();
        Assert.assertThat((Object)this.now.changeTimeZone("GMT-03:00").getHours(), (Matcher)Matchers.is((Object)((hour + 24 - 3) % 24)));
    }

    @Test
    public void changeTimeZoneRollover() {
        Assert.assertThat((Object)this.now.getTime().plusHours(48).toCalendar().get(6), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void seconds() {
        Assert.assertThat((Object)this.now.getSeconds(), (Matcher)Matchers.is((Object)this.calendarNow.get(13)));
    }

    @Test
    public void minutes() {
        Assert.assertThat((Object)this.now.getMinutes(), (Matcher)Matchers.is((Object)this.calendarNow.get(12)));
    }

    @Test
    public void hourOfDay() {
        Assert.assertThat((Object)this.now.getHours(), (Matcher)Matchers.is((Object)this.calendarNow.get(11)));
    }

    @Test
    public void testToString() {
        Assert.assertThat((Object)this.now.getTime().withTimeZone("UTC").toString().substring(0, 8), (Matcher)Matchers.is((Object)DatatypeConverter.printTime((Calendar)Calendar.getInstance(TimeZone.getTimeZone("UTC"))).substring(0, 8)));
    }

    @Test
    public void toDate() {
        Assert.assertThat((Object)this.now.toDate(), (Matcher)Matchers.is((Matcher)IsInstanceOf.instanceOf(Date.class)));
    }

    @Test
    public void toCalendar() {
        Assert.assertThat((Object)this.now.toCalendar(), (Matcher)Matchers.is((Matcher)IsInstanceOf.instanceOf(GregorianCalendar.class)));
    }

    @Test
    public void toXMLCalendar() throws DatatypeConfigurationException {
        Assert.assertThat((Object)this.now.toXMLCalendar(), (Matcher)Matchers.is((Matcher)IsInstanceOf.instanceOf(XMLGregorianCalendar.class)));
    }

    @Test
    public void fromDate() {
        Date date = new Date();
        date.setYear(0);
        date.setMonth(0);
        date.setDate(1);
        Assert.assertEquals((long)1900L, (long)new DateTime(date).getYear());
        Assert.assertEquals((long)1L, (long)new DateTime(date).getMonth());
        Assert.assertEquals((long)1L, (long)new DateTime(date).getDayOfMonth());
    }

    @Test
    public void fromCalendar() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(1, 1900);
        cal.set(2, 0);
        cal.set(5, 1);
        Assert.assertEquals((long)1900L, (long)new DateTime((Calendar)cal).getYear());
        Assert.assertEquals((long)1L, (long)new DateTime((Calendar)cal).getMonth());
        Assert.assertEquals((long)1L, (long)new DateTime((Calendar)cal).getDayOfMonth());
    }

    @Test
    public void fromXMLCalendar() throws DatatypeConfigurationException {
        XMLGregorianCalendar xmlCal = DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar());
        xmlCal.setYear(1900);
        xmlCal.setMonth(1);
        xmlCal.setDay(1);
        Assert.assertEquals((long)1900L, (long)new DateTime(xmlCal).getYear());
        Assert.assertEquals((long)1L, (long)new DateTime(xmlCal).getMonth());
        Assert.assertEquals((long)1L, (long)new DateTime(xmlCal).getDayOfMonth());
    }
}

