/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.el.function;

import java.util.Date;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.mvel2.CompileException;
import org.mule.mvel2.ParserConfiguration;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.TransformationService;
import org.mule.runtime.core.api.el.ExpressionExecutor;
import org.mule.runtime.core.api.el.ExpressionLanguageContext;
import org.mule.runtime.core.api.el.ExpressionLanguageFunction;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.context.notification.DefaultFlowCallStack;
import org.mule.runtime.core.el.context.MessageContext;
import org.mule.runtime.core.el.function.RegexExpressionLanguageFuntion;
import org.mule.runtime.core.el.mvel.MVELExpressionExecutor;
import org.mule.runtime.core.el.mvel.MVELExpressionLanguageContext;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class RegexExpressionLanguageFunctionTestCase
extends AbstractMuleTestCase {
    protected ExpressionExecutor<MVELExpressionLanguageContext> expressionExecutor;
    protected MVELExpressionLanguageContext context;
    protected RegexExpressionLanguageFuntion regexFuntion;
    protected MuleContext muleContext;
    private Event event;
    private Event.Builder eventBuilder;
    private InternalMessage message;

    @Before
    public void setup() throws InitialisationException {
        ParserConfiguration parserConfiguration = new ParserConfiguration();
        this.expressionExecutor = new MVELExpressionExecutor(parserConfiguration);
        this.muleContext = (MuleContext)Mockito.mock(MuleContext.class);
        this.context = new MVELExpressionLanguageContext(parserConfiguration, this.muleContext);
        this.regexFuntion = new RegexExpressionLanguageFuntion();
        this.context.declareFunction("regex", (ExpressionLanguageFunction)this.regexFuntion);
    }

    @Test
    public void testReturnNullWhenDoesNotMatches() throws Exception {
        this.addMessageToContextWithPayload("TEST");
        Object result = this.regexFuntion.call(new Object[]{"'TESTw+TEST'"}, (ExpressionLanguageContext)this.context);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testReturnNullWhenDoesNotMatchesMVEL() throws Exception {
        this.addMessageToContextWithPayload("TEST");
        Object result = this.expressionExecutor.execute("regex('TESTw+TEST')", (ExpressionLanguageContext)this.context);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testReturnsPayloadWhenMatchesIfNoCaptureGroupDefined() throws Exception {
        this.addMessageToContextWithPayload("TESTfooTEST");
        Object result = this.regexFuntion.call(new Object[]{"TEST\\w+TEST"}, (ExpressionLanguageContext)this.context);
        Assert.assertEquals((Object)"TESTfooTEST", (Object)result);
    }

    @Test
    public void testReturnsPayloadWhenMatchesIfNoCaptureGroupDefinedMVEL() throws Exception {
        this.addMessageToContextWithPayload("TESTfooTEST");
        Object result = this.expressionExecutor.execute("regex('TEST\\\\w+TEST')", (ExpressionLanguageContext)this.context);
        Assert.assertEquals((Object)"TESTfooTEST", (Object)result);
    }

    @Test
    public void testReturnsMatchedValueIfCaptureGroupDefined() throws Exception {
        this.addMessageToContextWithPayload("TESTfooTEST");
        Object result = this.regexFuntion.call(new Object[]{"TEST(\\w+)TEST"}, (ExpressionLanguageContext)this.context);
        Assert.assertEquals((Object)"foo", (Object)result);
    }

    @Test
    public void testReturnsMatchedValueIfCaptureGroupDefinedMVEL() throws Exception {
        this.addMessageToContextWithPayload("TESTfooTEST");
        Object result = this.expressionExecutor.execute("regex('TEST(\\\\w+)TEST')", (ExpressionLanguageContext)this.context);
        Assert.assertEquals((Object)"foo", (Object)result);
    }

    @Test
    public void testReturnsMultipleValuesIfMultipleCaptureGroupDefine() throws Exception {
        this.addMessageToContextWithPayload("TESTfooTESTbar");
        Object result = this.regexFuntion.call(new Object[]{"TEST(\\w+)TEST(\\w+)"}, (ExpressionLanguageContext)this.context);
        Assert.assertTrue((boolean)(result instanceof String[]));
        String[] values = (String[])result;
        Assert.assertEquals((long)2L, (long)values.length);
        Assert.assertEquals((Object)"foo", (Object)values[0]);
        Assert.assertEquals((Object)"bar", (Object)values[1]);
    }

    @Test
    public void testReturnsMultipleValuesIfMultipleCaptureGroupDefineMVEL() throws Exception {
        this.addMessageToContextWithPayload("TESTfooTESTbar");
        Object result = this.expressionExecutor.execute("regex('TEST(\\\\w+)TEST(\\\\w+)')", (ExpressionLanguageContext)this.context);
        Assert.assertTrue((boolean)(result instanceof String[]));
        String[] values = (String[])result;
        Assert.assertEquals((long)2L, (long)values.length);
        Assert.assertEquals((Object)"foo", (Object)values[0]);
        Assert.assertEquals((Object)"bar", (Object)values[1]);
    }

    @Test
    public void testReturnsPayloadWhenMatchesIfNoCaptureGroupDefinedTextArgument() throws Exception {
        Object result = this.regexFuntion.call(new Object[]{"TEST\\w+TEST", "TESTfooTEST"}, (ExpressionLanguageContext)this.context);
        Assert.assertEquals((Object)"TESTfooTEST", (Object)result);
    }

    @Test
    public void testReturnsPayloadWhenMatchesIfNoCaptureGroupDefinedTextArgumentMVEL() throws Exception {
        Object result = this.expressionExecutor.execute("regex('TEST\\\\w+TEST','TESTfooTEST')", (ExpressionLanguageContext)this.context);
        Assert.assertEquals((Object)"TESTfooTEST", (Object)result);
    }

    @Test
    public void testReturnsPayloadWhenMatchesIfNoCaptureGroupDefinedTextAndFlagsArgument() throws Exception {
        Object result = this.regexFuntion.call(new Object[]{"test\\w+test", "TESTfooTEST", 2}, (ExpressionLanguageContext)this.context);
        Assert.assertEquals((Object)"TESTfooTEST", (Object)result);
    }

    @Test
    public void testReturnsPayloadWhenMatchesIfNoCaptureGroupDefinedTextAndFlagsArgumentMVEL() throws Exception {
        Object result = this.expressionExecutor.execute("regex('test\\\\w+test','TESTfooTEST', java.util.regex.Pattern.CASE_INSENSITIVE)", (ExpressionLanguageContext)this.context);
        Assert.assertEquals((Object)"TESTfooTEST", (Object)result);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidNullRegex() throws Exception {
        this.regexFuntion.call(new Object[]{null}, (ExpressionLanguageContext)this.context);
    }

    @Test(expected=CompileException.class)
    public void testInvalidNullRegexMVEL() throws Exception {
        this.expressionExecutor.execute("regex(null)", (ExpressionLanguageContext)this.context);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidNonStringRegex() throws Exception {
        this.regexFuntion.call(new Object[]{new Date()}, (ExpressionLanguageContext)this.context);
    }

    @Test(expected=CompileException.class)
    public void testInvalidNonStringRegexMVEL() throws Exception {
        this.expressionExecutor.execute("regex(new Date())", (ExpressionLanguageContext)this.context);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidNullText() throws Exception {
        this.regexFuntion.call(new Object[]{"TESTw+TEST", null}, (ExpressionLanguageContext)this.context);
    }

    @Test(expected=CompileException.class)
    public void testInvalidNullTextMVEL() throws Exception {
        this.expressionExecutor.execute("regex('TESTw+TEST',null)", (ExpressionLanguageContext)this.context);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidNonStringText() throws Exception {
        this.regexFuntion.call(new Object[]{"TESTw+TEST", new Date()}, (ExpressionLanguageContext)this.context);
    }

    @Test(expected=CompileException.class)
    public void testInvalidNonStringTextMVEL() throws Exception {
        this.expressionExecutor.execute("regex('TESTw+TEST',new Date())", (ExpressionLanguageContext)this.context);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidNonIntFlags() throws Exception {
        this.regexFuntion.call(new Object[]{"TESTw+TEST", "text", "foo"}, (ExpressionLanguageContext)this.context);
    }

    @Test(expected=CompileException.class)
    public void testInvalidNonIntFlagsMVEL() throws Exception {
        this.expressionExecutor.execute("regex('TESTw+TEST','text','foo')", (ExpressionLanguageContext)this.context);
    }

    protected void addMessageToContextWithPayload(String payload) throws TransformerException {
        this.event = (Event)Mockito.mock(Event.class);
        Mockito.when((Object)this.event.getFlowCallStack()).thenReturn((Object)new DefaultFlowCallStack());
        Mockito.when((Object)this.event.getError()).thenReturn(Optional.empty());
        this.eventBuilder = Event.builder((Event)this.event);
        this.message = (InternalMessage)Mockito.mock(InternalMessage.class);
        Mockito.when((Object)this.event.getMessage()).thenAnswer(invocation -> this.message);
        InternalMessage transformedMessage = (InternalMessage)Mockito.mock(InternalMessage.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)transformedMessage.getPayload()).thenReturn((Object)new TypedValue((Object)payload, DataType.fromObject((Object)payload)));
        TransformationService transformationService = (TransformationService)Mockito.mock(TransformationService.class);
        Mockito.when((Object)this.muleContext.getTransformationService()).thenReturn((Object)transformationService);
        Mockito.when((Object)transformationService.transform((Message)Matchers.any(InternalMessage.class), (DataType)Matchers.any(DataType.class))).thenReturn((Object)transformedMessage);
        this.context.addFinalVariable("message", (Object)new MessageContext(this.event, this.eventBuilder, this.muleContext));
    }
}

