/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.el.mvel;

import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.mule.mvel2.ParserConfiguration;
import org.mule.mvel2.integration.VariableResolver;
import org.mule.mvel2.integration.VariableResolverFactory;
import org.mule.mvel2.integration.impl.MapVariableResolverFactory;
import org.mule.mvel2.integration.impl.SimpleValueResolver;
import org.mule.runtime.core.el.mvel.MVELExpressionLanguageContext;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class MVELExpressionLanguageContextTestCase
extends AbstractMuleContextTestCase {
    private ParserConfiguration parserConfig = new ParserConfiguration();

    @Test
    public void testGetVariableResolver() {
        MVELExpressionLanguageContext resoverFactory = new MVELExpressionLanguageContext(this.parserConfig, muleContext);
        resoverFactory.addResolver("foo", (VariableResolver)new SimpleValueResolver((Object)"val"));
        Assert.assertNotNull((Object)resoverFactory.getVariableResolver("foo"));
        Assert.assertEquals((Object)"val", (Object)resoverFactory.getVariableResolver("foo").getValue());
        Assert.assertNull((Object)resoverFactory.getVariableResolver("bar"));
    }

    @Test
    public void testGetVariableResolverNextFactory() {
        this.parserConfig.addImport(String.class);
        MVELExpressionLanguageContext resoverFactory = new MVELExpressionLanguageContext(this.parserConfig, muleContext);
        resoverFactory.setNextFactory((VariableResolverFactory)new MapVariableResolverFactory(Collections.singletonMap("foo", "val")));
        Assert.assertNotNull((Object)resoverFactory.getVariableResolver("foo"));
        Assert.assertEquals((Object)"val", (Object)resoverFactory.getVariableResolver("foo").getValue());
        Assert.assertNull((Object)resoverFactory.getVariableResolver("bar"));
    }
}

