/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.el.mvel;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.MimeType;
import org.apache.commons.lang.ClassUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.mule.mvel2.CompileException;
import org.mule.mvel2.ParserContext;
import org.mule.mvel2.PropertyAccessException;
import org.mule.mvel2.ast.Function;
import org.mule.mvel2.integration.VariableResolverFactory;
import org.mule.mvel2.optimizers.OptimizerFactory;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ValidationResult;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.message.NullAttributes;
import org.mule.runtime.api.metadata.AbstractDataTypeBuilderFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.el.ExpressionLanguageContext;
import org.mule.runtime.core.api.el.ExpressionLanguageExtension;
import org.mule.runtime.core.api.el.ExpressionLanguageFunction;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.api.registry.RegistrationException;
import org.mule.runtime.core.config.MuleManifest;
import org.mule.runtime.core.context.notification.DefaultFlowCallStack;
import org.mule.runtime.core.el.context.AppContext;
import org.mule.runtime.core.el.context.MessageContext;
import org.mule.runtime.core.el.function.RegexExpressionLanguageFuntion;
import org.mule.runtime.core.el.mvel.MVELExpressionLanguage;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.junit4.matcher.DataTypeMatcher;

@RunWith(value=Parameterized.class)
public class MVELExpressionLanguageTestCase
extends AbstractMuleContextTestCase {
    protected Variant variant;
    protected MVELExpressionLanguage mvel;
    private FlowConstruct flowConstruct;
    final String largeExpression = "payload = 'Tom,Fennelly,Male,4,Ireland';StringBuilder sb = new StringBuilder(); fields = payload.split(',');if (fields.length > 4) {    sb.append('  <Contact>\n');    sb.append('    <FirstName>').append(fields[0]).append('</FirstName>\n');    sb.append('    <LastName>').append(fields[1]).append('</LastName>\n');    sb.append('    <Address>').append(fields[2]).append('</Address>\n');    sb.append('    <TelNum>').append(fields[3]).append('</TelNum>\n');    sb.append('    <SIN>').append(fields[4]).append('</SIN>\n');    sb.append('  </Contact>\n');}sb.toString();";
    @Rule
    public ExpectedException expectedEx = ExpectedException.none();

    public MVELExpressionLanguageTestCase(Variant variant, String mvelOptimizer) {
        this.variant = variant;
        OptimizerFactory.setDefaultOptimizer((String)mvelOptimizer);
    }

    @Before
    public void setupMVEL() throws InitialisationException {
        this.mvel = new MVELExpressionLanguage(muleContext);
        this.mvel.initialise();
        this.flowConstruct = (FlowConstruct)Mockito.mock(FlowConstruct.class);
        Mockito.when((Object)this.flowConstruct.getName()).thenReturn((Object)"myFlow");
    }

    @Test
    public void testEvaluateString() {
        Assert.assertEquals((Object)"hi", (Object)this.evaluate("'hi'"));
        Assert.assertEquals((Object)4, (Object)this.evaluate("2*2"));
        Assert.assertEquals((Object)"hiho", (Object)this.evaluate("'hi'+'ho'"));
        Assert.assertEquals((Object)Calendar.getInstance().getTimeZone(), (Object)this.evaluate("server.timeZone"));
        Assert.assertEquals((Object)MuleManifest.getProductVersion(), (Object)this.evaluate("mule.version"));
        Assert.assertEquals((Object)muleContext.getConfiguration().getId(), (Object)this.evaluate("app.name"));
    }

    @Test
    public void testEvaluateStringMapOfStringObject() {
        Assert.assertEquals((Object)"hi", (Object)this.evaluate("'hi'", Collections.emptyMap()));
        Assert.assertEquals((Object)4, (Object)this.evaluate("2*2", Collections.emptyMap()));
        Assert.assertEquals((Object)Calendar.getInstance().getTimeZone(), (Object)this.evaluate("server.timeZone", Collections.emptyMap()));
        Assert.assertEquals((Object)MuleManifest.getProductVersion(), (Object)this.evaluate("mule.version", Collections.emptyMap()));
        Assert.assertEquals((Object)muleContext.getConfiguration().getId(), (Object)this.evaluate("app.name", Collections.emptyMap()));
        Assert.assertEquals((Object)1, (Object)this.evaluate("foo", Collections.singletonMap("foo", 1)));
        Assert.assertEquals((Object)"bar", (Object)this.evaluate("foo", Collections.singletonMap("foo", "bar")));
    }

    @Test
    public void testEvaluateStringMuleEvent() throws Exception {
        Event event = this.createMockEvent();
        Assert.assertEquals((Object)"hi", (Object)this.evaluate("'hi'", event));
        Assert.assertEquals((Object)4, (Object)this.evaluate("2*2", event));
        Assert.assertEquals((Object)Calendar.getInstance().getTimeZone(), (Object)this.evaluate("server.timeZone", event));
        Assert.assertEquals((Object)MuleManifest.getProductVersion(), (Object)this.evaluate("mule.version", event));
        Assert.assertEquals((Object)muleContext.getConfiguration().getId(), (Object)this.evaluate("app.name", event));
        Assert.assertEquals((Object)"myFlow", (Object)this.evaluate("flow.name", event));
        Assert.assertEquals((Object)"foo", (Object)this.evaluate("message.payload", event));
    }

    @Test
    public void testEvaluateMapOfStringObject() throws Exception {
        Event event = this.createMockEvent();
        Assert.assertEquals((Object)1, (Object)this.evaluate("foo", Collections.singletonMap("foo", 1)));
        Assert.assertEquals((Object)"bar", (Object)this.evaluate("foo", Collections.singletonMap("foo", "bar")));
    }

    @Test
    public void testEvaluateStringMuleMessage() throws Exception {
        Event event = this.createMockEvent();
        Assert.assertEquals((Object)"foo", (Object)this.evaluate("message.payload", event));
    }

    @Test
    public void testEvaluateAttributes() throws Exception {
        Event event = this.createMockEventWithAttributes();
        Assert.assertEquals((Object)"number 1", (Object)this.evaluate("attributes.one", event));
        Assert.assertEquals((Object)"number 2", (Object)this.evaluate("attributes.two", event));
    }

    @Test
    public void testValidate() {
        Assert.assertThat((Object)this.validate("2*2").isSuccess(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testValidateInvalid() {
        Assert.assertThat((Object)this.validate("2*'2").isSuccess(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void regexFunction() throws Exception {
        Event testEvent = MVELExpressionLanguageTestCase.eventBuilder().message(Message.of((Object)"TESTfooTEST")).build();
        Assert.assertEquals((Object)"foo", (Object)this.evaluate("regex('TEST(\\\\w+)TEST')", testEvent));
    }

    @Test
    public void appTakesPrecedenceOverEverything() throws Exception {
        this.mvel.setAliases(Collections.singletonMap("app", "'other1'"));
        Event event = MVELExpressionLanguageTestCase.eventBuilder().message(Message.of((Object)"")).addVariable("app", (Object)"otherb").build();
        muleContext.getRegistry().registerObject("foo", context -> context.addVariable("app", (Object)"otherc"));
        this.mvel.initialise();
        Assert.assertEquals(AppContext.class, this.evaluate("app", event).getClass());
    }

    @Test
    public void messageTakesPrecedenceOverEverything() throws Exception {
        this.mvel.setAliases(Collections.singletonMap("message", "'other1'"));
        Event event = MVELExpressionLanguageTestCase.eventBuilder().message(Message.of((Object)"")).addVariable("message", (Object)"other2").build();
        muleContext.getRegistry().registerObject("foo", context -> context.addVariable("message", (Object)"other3"));
        this.mvel.initialise();
        Assert.assertEquals(MessageContext.class, this.evaluate("message", event).getClass());
    }

    @Test
    public void extensionTakesPrecedenceOverAutoResolved() throws Exception {
        Event event = MVELExpressionLanguageTestCase.eventBuilder().message(Message.of((Object)"")).addVariable("foo", (Object)"other").build();
        muleContext.getRegistry().registerObject("key", context -> context.addVariable("foo", (Object)"bar"));
        this.mvel.initialise();
        Assert.assertEquals((Object)"bar", (Object)this.evaluate("foo", event));
    }

    @Test
    public void aliasTakesPrecedenceOverAutoResolved() throws RegistrationException, InitialisationException {
        this.mvel.setAliases(Collections.singletonMap("foo", "'bar'"));
        muleContext.getRegistry().registerObject("key", context -> context.addVariable("foo", (Object)"other"));
        this.mvel.initialise();
        Assert.assertEquals((Object)"bar", (Object)this.evaluate("foo"));
    }

    @Test
    public void aliasTakesPrecedenceOverExtension() throws Exception {
        this.mvel.setAliases(Collections.singletonMap("foo", "'bar'"));
        this.mvel.initialise();
        Assert.assertEquals((Object)"bar", (Object)this.evaluate("foo"));
    }

    @Test
    public void addImport() throws InitialisationException {
        this.mvel.setImports(Collections.singletonMap("loc", Locale.class));
        this.mvel.initialise();
        Assert.assertEquals(Locale.class, (Object)this.evaluate("loc"));
    }

    @Test
    public void addAlias() throws InitialisationException {
        this.mvel.setAliases(Collections.singletonMap("appName", "app.name"));
        this.mvel.initialise();
        Assert.assertEquals((Object)muleContext.getConfiguration().getId(), (Object)this.evaluate("appName"));
    }

    @Test
    public void addGlobalFunction() throws InitialisationException {
        this.mvel.addGlobalFunction("hello", (Function)new HelloWorldFunction(new ParserContext(this.mvel.parserConfiguration)));
        this.mvel.initialise();
        Assert.assertEquals((Object)"Hello World!", (Object)this.evaluate("hello()"));
    }

    @Test
    public void defaultImports() throws InitialisationException, ClassNotFoundException, IOException {
        Assert.assertEquals(InputStream.class, (Object)this.evaluate(InputStream.class.getSimpleName()));
        Assert.assertEquals(FileReader.class, (Object)this.evaluate(FileReader.class.getSimpleName()));
        Assert.assertEquals(Object.class, (Object)this.evaluate(Object.class.getSimpleName()));
        Assert.assertEquals(System.class, (Object)this.evaluate(System.class.getSimpleName()));
        Assert.assertEquals(URI.class, (Object)this.evaluate(URI.class.getSimpleName()));
        Assert.assertEquals(URL.class, (Object)this.evaluate(URL.class.getSimpleName()));
        Assert.assertEquals(Collection.class, (Object)this.evaluate(Collection.class.getSimpleName()));
        Assert.assertEquals(List.class, (Object)this.evaluate(List.class.getSimpleName()));
        Assert.assertEquals(BigDecimal.class, (Object)this.evaluate(BigDecimal.class.getSimpleName()));
        Assert.assertEquals(BigInteger.class, (Object)this.evaluate(BigInteger.class.getSimpleName()));
        Assert.assertEquals(DataHandler.class, (Object)this.evaluate(DataHandler.class.getSimpleName()));
        Assert.assertEquals(MimeType.class, (Object)this.evaluate(MimeType.class.getSimpleName()));
        Assert.assertEquals(Pattern.class, (Object)this.evaluate(Pattern.class.getSimpleName()));
        Assert.assertEquals(DataType.class, (Object)this.evaluate(DataType.class.getSimpleName()));
        Assert.assertEquals(AbstractDataTypeBuilderFactory.class, (Object)this.evaluate(AbstractDataTypeBuilderFactory.class.getSimpleName()));
    }

    @Test
    public void testConcurrentCompilation() throws Exception {
        int N = 100;
        CountDownLatch start = new CountDownLatch(1);
        CountDownLatch end = new CountDownLatch(100);
        AtomicInteger errors = new AtomicInteger(0);
        for (int i = 0; i < 100; ++i) {
            new Thread(() -> {
                try {
                    start.await();
                    this.evaluate("payload = 'Tom,Fennelly,Male,4,Ireland';StringBuilder sb = new StringBuilder(); fields = payload.split(',');if (fields.length > 4) {    sb.append('  <Contact>\n');    sb.append('    <FirstName>').append(fields[0]).append('</FirstName>\n');    sb.append('    <LastName>').append(fields[1]).append('</LastName>\n');    sb.append('    <Address>').append(fields[2]).append('</Address>\n');    sb.append('    <TelNum>').append(fields[3]).append('</TelNum>\n');    sb.append('    <SIN>').append(fields[4]).append('</SIN>\n');    sb.append('  </Contact>\n');}sb.toString();" + new Random().nextInt());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    errors.incrementAndGet();
                }
                finally {
                    end.countDown();
                }
            }, "thread-eval-" + i).start();
        }
        start.countDown();
        end.await();
        if (errors.get() > 0) {
            Assert.fail();
        }
    }

    @Test
    public void testConcurrentEvaluation() throws Exception {
        int N = 100;
        CountDownLatch start = new CountDownLatch(1);
        CountDownLatch end = new CountDownLatch(100);
        AtomicInteger errors = new AtomicInteger(0);
        for (int i = 0; i < 100; ++i) {
            new Thread(() -> {
                try {
                    start.await();
                    this.testEvaluateString();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    errors.incrementAndGet();
                }
                finally {
                    end.countDown();
                }
            }, "thread-eval-" + i).start();
        }
        start.countDown();
        end.await();
        if (errors.get() > 0) {
            Assert.fail();
        }
    }

    @Test
    public void propertyAccessException() throws InitialisationException {
        try {
            this.evaluate("doesntExist");
        }
        catch (Exception e) {
            Assert.assertEquals(ExpressionRuntimeException.class, e.getClass());
            Assert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(CompileException.class));
        }
    }

    @Test
    public void propertyAccessException2() throws InitialisationException {
        try {
            this.evaluate("app.doesntExist");
        }
        catch (Exception e) {
            Assert.assertEquals(ExpressionRuntimeException.class, e.getClass());
            Assert.assertEquals(PropertyAccessException.class, e.getCause().getClass());
        }
    }

    @Test
    public void expressionExceptionHasMvelCauseMessage() throws InitialisationException {
        String expressionWhichThrowsError = "doesntExist";
        this.expectedEx.expect(ExpressionRuntimeException.class);
        this.expectedEx.expectMessage(Matchers.containsString((String)("Error: unresolvable property or identifier: " + expressionWhichThrowsError)));
        this.expectedEx.expectMessage(Matchers.containsString((String)("evaluating expression: \"" + expressionWhichThrowsError + "\"")));
        this.evaluate(expressionWhichThrowsError);
    }

    @Test
    public void returnsDataType() throws Exception {
        DataType dataType = DataType.builder().type(String.class).mediaType(MediaType.JSON).charset(StandardCharsets.UTF_16.name()).build();
        Event event = this.createMockEvent("Test Message", dataType);
        TypedValue typedValue = this.evaluateTyped("payload", event);
        Assert.assertThat((Object)((String)typedValue.getValue()), (Matcher)CoreMatchers.equalTo((Object)"Test Message"));
        Assert.assertThat((Object)typedValue.getDataType(), (Matcher)DataTypeMatcher.like(String.class, (MediaType)MediaType.JSON, (Charset)StandardCharsets.UTF_16));
    }

    protected Object evaluate(String expression) {
        if (this.variant.equals((Object)Variant.EXPRESSION_WITH_DELIMITER)) {
            return this.mvel.evaluateUntyped("#[mel:" + expression + "]", null, null, null, null);
        }
        return this.mvel.evaluateUntyped(expression, null, null, null, null);
    }

    protected TypedValue evaluateTyped(String expression, Event event) throws Exception {
        if (this.variant.equals((Object)Variant.EXPRESSION_WITH_DELIMITER)) {
            return this.mvel.evaluate("#[mel:" + expression + "]", event, Event.builder((Event)event), this.flowConstruct, BindingContext.builder().build());
        }
        return this.mvel.evaluate(expression, event, Event.builder((Event)event), this.flowConstruct, BindingContext.builder().build());
    }

    protected Object evaluate(String expression, Map<String, Object> vars) {
        if (this.variant.equals((Object)Variant.EXPRESSION_WITH_DELIMITER)) {
            return this.mvel.evaluateUntyped("#[mel:" + expression + "]", vars);
        }
        return this.mvel.evaluateUntyped(expression, vars);
    }

    protected Object evaluate(String expression, Event event) throws Exception {
        if (this.variant.equals((Object)Variant.EXPRESSION_WITH_DELIMITER)) {
            return this.mvel.evaluateUntyped("#[mel:" + expression + "]", event, Event.builder((Event)event), this.flowConstruct, null);
        }
        return this.mvel.evaluateUntyped(expression, event, Event.builder((Event)event), this.flowConstruct, null);
    }

    protected ValidationResult validate(String expression) {
        if (this.variant.equals((Object)Variant.EXPRESSION_WITH_DELIMITER)) {
            return this.mvel.validate("#[mel:" + expression + "]");
        }
        return this.mvel.validate(expression);
    }

    protected Event createMockEvent(DataType dataType) {
        return this.createMockEvent("foo", DataType.STRING);
    }

    protected Event createMockEventWithAttributes(DataType dataType) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("one", "number 1");
        attributes.put("two", "number 2");
        return this.createMockEvent("foo", DataType.STRING, attributes, DataType.OBJECT);
    }

    protected Event createMockEvent(String payload, DataType dataType) {
        return this.createMockEvent(payload, dataType, NullAttributes.NULL_ATTRIBUTES, DataType.OBJECT);
    }

    protected Event createMockEvent(String payload, DataType dataType, Object attributes, DataType attributesDataType) {
        Event event = (Event)Mockito.mock(Event.class);
        InternalMessage message = (InternalMessage)Mockito.mock(InternalMessage.class);
        Mockito.when((Object)message.getPayload()).thenReturn((Object)new TypedValue((Object)payload, dataType));
        Mockito.when((Object)message.getAttributes()).thenReturn((Object)new TypedValue(attributes, attributesDataType));
        Mockito.when((Object)event.getMessage()).thenReturn((Object)message);
        Mockito.when((Object)event.getFlowCallStack()).thenReturn((Object)new DefaultFlowCallStack());
        Mockito.when((Object)event.getError()).thenReturn(Optional.empty());
        return event;
    }

    protected Event createMockEvent() {
        return this.createMockEvent(DataType.STRING);
    }

    protected Event createMockEventWithAttributes() {
        return this.createMockEventWithAttributes(DataType.STRING);
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        return Arrays.asList({Variant.EXPRESSION_WITH_DELIMITER, OptimizerFactory.SAFE_REFLECTIVE}, {Variant.EXPRESSION_WITH_DELIMITER, OptimizerFactory.DYNAMIC}, {Variant.EXPRESSION_STRAIGHT_UP, OptimizerFactory.SAFE_REFLECTIVE}, {Variant.EXPRESSION_STRAIGHT_UP, OptimizerFactory.DYNAMIC});
    }

    private static Class[] getClasses(String packageName) throws ClassNotFoundException, IOException, URISyntaxException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        assert (classLoader != null);
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList<File> dirs = new ArrayList<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            dirs.add(new File(resource.toURI()));
        }
        ArrayList<Class> classes = new ArrayList<Class>();
        for (File directory : dirs) {
            classes.addAll(MVELExpressionLanguageTestCase.findClasses(directory, packageName));
        }
        return classes.toArray(new Class[classes.size()]);
    }

    private static List<Class> findClasses(File directory, String packageName) throws ClassNotFoundException {
        File[] files;
        ArrayList<Class> classes = new ArrayList<Class>();
        if (!directory.exists()) {
            return classes;
        }
        for (File file : files = directory.listFiles()) {
            if (!file.getName().endsWith(".class")) continue;
            classes.add(ClassUtils.getClass((String)(packageName + '.' + file.getName().substring(0, file.getName().length() - 6))));
        }
        return classes;
    }

    @Test
    public void collectionAccessPayloadChangedMULE7506() throws Exception {
        Event event = MVELExpressionLanguageTestCase.eventBuilder().message(Message.of((Object)new String[]{"1", "2"})).build();
        Assert.assertEquals((Object)"1", (Object)this.mvel.evaluateUntyped("payload[0]", event, Event.builder((Event)event), this.flowConstruct, null));
        event = Event.builder((Event)event).message((Message)InternalMessage.builder((Message)event.getMessage()).payload(Collections.singletonList("1")).build()).build();
        Assert.assertEquals((Object)"1", (Object)this.mvel.evaluateUntyped("payload[0]", event, Event.builder((Event)event), this.flowConstruct, null));
    }

    private static class HelloWorldFunction
    extends Function {
        public HelloWorldFunction(ParserContext parserContext) {
            super("hello", new char[0], 0, 0, 0, 0, 0, parserContext);
        }

        public Object call(Object ctx, Object thisValue, VariableResolverFactory factory, Object[] parms) {
            return "Hello World!";
        }
    }

    public static enum Variant {
        EXPRESSION_WITH_DELIMITER,
        EXPRESSION_STRAIGHT_UP;

    }

    static class DummyExpressionLanguageExtension
    implements ExpressionLanguageExtension {
        DummyExpressionLanguageExtension() {
        }

        public void configureContext(ExpressionLanguageContext context) {
            for (int i = 0; i < 20; ++i) {
                context.declareFunction("dummy-function-" + i, (ExpressionLanguageFunction)new RegexExpressionLanguageFuntion());
            }
        }
    }
}

