/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.el.mvel.datatype;

import org.junit.Test;
import org.mule.runtime.core.el.mvel.datatype.AbstractVarAssignmentDataTypePropagatorTestCase;
import org.mule.runtime.core.el.mvel.datatype.EnricherDataTypePropagator;

public abstract class AbstractScopedVarAssignmentDataTypePropagatorTestCase
extends AbstractVarAssignmentDataTypePropagatorTestCase {
    protected final String variableName;

    public AbstractScopedVarAssignmentDataTypePropagatorTestCase(EnricherDataTypePropagator dataTypePropagator, String variableName) {
        super(dataTypePropagator);
        this.variableName = variableName;
    }

    @Test
    public void propagatesVarDataTypeUsingMapSyntax() throws Exception {
        this.doAssignmentDataTypePropagationTest(this.createAssignmentExpression("['foo']"));
    }

    @Test
    public void propagatesVarDataTypeUsingDotSyntax() throws Exception {
        this.doAssignmentDataTypePropagationTest(this.createAssignmentExpression(".foo"));
    }

    @Test
    public void propagatesVarDataTypeUsingEscapedDotSyntax() throws Exception {
        this.doAssignmentDataTypePropagationTest(this.createAssignmentExpression(".'foo'"));
    }

    @Test
    public void doesNotChangesVarDataTypeUsingRecursiveMapSyntax() throws Exception {
        this.doInnerAssignmentDataTypePropagationTest(this.createAssignmentExpression("['foo']['bar']"));
    }

    @Test
    public void doesNotChangesVarDataTypeUsingRecursiveDotSyntax() throws Exception {
        this.doInnerAssignmentDataTypePropagationTest(this.createAssignmentExpression(".foo.bar"));
    }

    @Test
    public void doesNotChangesVarDataTypeUsingRecursiveEscapedDotSyntax() throws Exception {
        this.doInnerAssignmentDataTypePropagationTest(this.createAssignmentExpression(".'foo'.'bar'"));
    }

    private String createAssignmentExpression(String accessorExpression) {
        return this.variableName + accessorExpression + " = 'unused'";
    }
}

