/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.el.mvel.datatype;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.mule.mvel2.MVEL;
import org.mule.mvel2.ParserConfiguration;
import org.mule.mvel2.ParserContext;
import org.mule.mvel2.compiler.CompiledExpression;
import org.mule.mvel2.integration.VariableResolverFactory;
import org.mule.mvel2.integration.impl.CachedMapVariableResolverFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.el.mvel.DelegateVariableResolverFactory;
import org.mule.runtime.core.el.mvel.GlobalVariableResolverFactory;
import org.mule.runtime.core.el.mvel.MVELExpressionLanguage;
import org.mule.runtime.core.el.mvel.MVELExpressionLanguageContext;
import org.mule.runtime.core.el.mvel.MessageVariableResolverFactory;
import org.mule.runtime.core.el.mvel.StaticVariableResolverFactory;
import org.mule.runtime.core.el.mvel.VariableVariableResolverFactory;
import org.mule.runtime.core.el.mvel.datatype.EnricherDataTypePropagator;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.junit4.matcher.DataTypeMatcher;

public abstract class AbstractVarAssignmentDataTypePropagatorTestCase
extends AbstractMuleContextTestCase {
    public static final Charset CUSTOM_ENCODING = StandardCharsets.UTF_16;
    public static final String PROPERTY_NAME = "foo";
    public static final String INNER_PROPERTY_NAME = "bar";
    private final EnricherDataTypePropagator dataTypePropagator;

    protected AbstractVarAssignmentDataTypePropagatorTestCase(EnricherDataTypePropagator dataTypePropagator) {
        this.dataTypePropagator = dataTypePropagator;
    }

    protected void doAssignmentDataTypePropagationTest(String expression) throws Exception {
        DataType expectedDataType = DataType.builder().type(String.class).mediaType(MediaType.JSON).charset(CUSTOM_ENCODING).build();
        Event.Builder builder = Event.builder((Event)this.testEvent());
        CompiledExpression compiledExpression = this.compileMelExpression(expression, this.testEvent(), builder);
        Event event = builder.build();
        this.dataTypePropagator.propagate(event, builder, new TypedValue((Object)"Test Message", expectedDataType), compiledExpression);
        event = builder.build();
        MatcherAssert.assertThat((Object)this.getVariableDataType(event), (Matcher)DataTypeMatcher.like(String.class, (MediaType)MediaType.JSON, (Charset)CUSTOM_ENCODING));
    }

    protected void doInnerAssignmentDataTypePropagationTest(String expression) throws Exception {
        DataType expectedDataType = DataType.builder().type(Map.class).mediaType(MediaType.UNKNOWN).charset(CUSTOM_ENCODING).build();
        HashMap<String, String> propertyValue = new HashMap<String, String>();
        propertyValue.put(INNER_PROPERTY_NAME, "Test Message");
        Event event = this.setVariable(this.testEvent(), propertyValue, expectedDataType);
        Event.Builder builder = Event.builder((Event)event);
        CompiledExpression compiledExpression = this.compileMelExpression(expression, event, builder);
        event = builder.build();
        this.dataTypePropagator.propagate(event, builder, new TypedValue(propertyValue, DataType.STRING), compiledExpression);
        event = builder.build();
        MatcherAssert.assertThat((Object)this.getVariableDataType(event), (Matcher)DataTypeMatcher.like(Map.class, (MediaType)MediaType.UNKNOWN, (Charset)CUSTOM_ENCODING));
    }

    protected abstract DataType getVariableDataType(Event var1);

    protected abstract Event setVariable(Event var1, Object var2, DataType var3);

    private CompiledExpression compileMelExpression(String expression, Event testEvent, Event.Builder builder) {
        ParserConfiguration parserConfiguration = MVELExpressionLanguage.createParserConfiguration((Map)Collections.EMPTY_MAP);
        MVELExpressionLanguageContext context = this.createMvelExpressionLanguageContext(testEvent, builder, parserConfiguration);
        CompiledExpression compiledExpression = (CompiledExpression)MVEL.compileExpression((String)expression, (ParserContext)new ParserContext(parserConfiguration));
        MVEL.executeExpression((Object)compiledExpression, (VariableResolverFactory)context);
        return compiledExpression;
    }

    protected MVELExpressionLanguageContext createMvelExpressionLanguageContext(Event testEvent, Event.Builder builder, ParserConfiguration parserConfiguration) {
        MVELExpressionLanguageContext context = new MVELExpressionLanguageContext(parserConfiguration, muleContext);
        StaticVariableResolverFactory staticContext = new StaticVariableResolverFactory(parserConfiguration, muleContext);
        GlobalVariableResolverFactory globalContext = new GlobalVariableResolverFactory(Collections.emptyMap(), Collections.emptyMap(), parserConfiguration, muleContext);
        DelegateVariableResolverFactory innerDelegate = new DelegateVariableResolverFactory((VariableResolverFactory)globalContext, (VariableResolverFactory)new VariableVariableResolverFactory(parserConfiguration, muleContext, testEvent, builder));
        DelegateVariableResolverFactory delegate = new DelegateVariableResolverFactory((VariableResolverFactory)staticContext, (VariableResolverFactory)new MessageVariableResolverFactory(parserConfiguration, muleContext, testEvent, builder, (VariableResolverFactory)innerDelegate));
        context.setNextFactory((VariableResolverFactory)new CachedMapVariableResolverFactory(Collections.emptyMap(), (VariableResolverFactory)delegate));
        return context;
    }
}

