/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.el.mvel.datatype;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.mvel2.MVEL;
import org.mule.mvel2.ParserConfiguration;
import org.mule.mvel2.ParserContext;
import org.mule.mvel2.compiler.CompiledExpression;
import org.mule.mvel2.integration.VariableResolverFactory;
import org.mule.mvel2.integration.impl.CachedMapVariableResolverFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.el.mvel.DelegateVariableResolverFactory;
import org.mule.runtime.core.el.mvel.GlobalVariableResolverFactory;
import org.mule.runtime.core.el.mvel.MVELExpressionLanguage;
import org.mule.runtime.core.el.mvel.MVELExpressionLanguageContext;
import org.mule.runtime.core.el.mvel.MessageVariableResolverFactory;
import org.mule.runtime.core.el.mvel.StaticVariableResolverFactory;
import org.mule.runtime.core.el.mvel.VariableVariableResolverFactory;
import org.mule.runtime.core.el.mvel.datatype.ExpressionDataTypeResolver;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.junit4.matcher.DataTypeMatcher;

public abstract class AbstractVarExpressionDataTypeResolverTestCase
extends AbstractMuleContextTestCase {
    public static final String EXPRESSION_VALUE = "bar";
    public static final Charset CUSTOM_ENCODING = StandardCharsets.UTF_16;
    public static final String PROPERTY_NAME = "foo";
    private final ExpressionDataTypeResolver expressionDataTypeResolver;
    private final String variableName;

    protected AbstractVarExpressionDataTypeResolverTestCase(ExpressionDataTypeResolver expressionDataTypeResolver, String variableName) {
        this.expressionDataTypeResolver = expressionDataTypeResolver;
        this.variableName = variableName;
    }

    @Test
    public void returnsFlowVarDataTypeUsingMapSyntax() throws Exception {
        this.doVarDataTypeTest(this.variableName + "['" + PROPERTY_NAME + "']");
    }

    @Test
    public void returnsFlowVarDataTypeUsingDotSyntax() throws Exception {
        this.doVarDataTypeTest(this.variableName + "." + PROPERTY_NAME);
    }

    @Test
    public void returnsFlowVarDataTypeUsingEscapedDotSyntax() throws Exception {
        this.doVarDataTypeTest(this.variableName + ".'" + PROPERTY_NAME + "'");
    }

    protected void doVarDataTypeTest(String expression) throws Exception {
        DataType expectedDataType = DataType.builder().type(String.class).mediaType(MediaType.JSON).charset(CUSTOM_ENCODING).build();
        Event event = this.setVariable(this.testEvent(), EXPRESSION_VALUE, expectedDataType);
        ParserConfiguration parserConfiguration = MVELExpressionLanguage.createParserConfiguration((Map)Collections.EMPTY_MAP);
        MVELExpressionLanguageContext context = this.createMvelExpressionLanguageContext(event, parserConfiguration);
        CompiledExpression compiledExpression = (CompiledExpression)MVEL.compileExpression((String)expression, (ParserContext)new ParserContext(parserConfiguration));
        MVEL.executeExpression((Object)compiledExpression, (VariableResolverFactory)context);
        MatcherAssert.assertThat((Object)this.expressionDataTypeResolver.resolve(event, compiledExpression), (Matcher)DataTypeMatcher.like(String.class, (MediaType)MediaType.JSON, (Charset)CUSTOM_ENCODING));
    }

    protected MVELExpressionLanguageContext createMvelExpressionLanguageContext(Event testEvent, ParserConfiguration parserConfiguration) {
        MVELExpressionLanguageContext context = new MVELExpressionLanguageContext(parserConfiguration, muleContext);
        StaticVariableResolverFactory staticContext = new StaticVariableResolverFactory(parserConfiguration, muleContext);
        GlobalVariableResolverFactory globalContext = new GlobalVariableResolverFactory(Collections.EMPTY_MAP, Collections.EMPTY_MAP, parserConfiguration, muleContext);
        DelegateVariableResolverFactory innerDelegate = new DelegateVariableResolverFactory((VariableResolverFactory)globalContext, (VariableResolverFactory)new VariableVariableResolverFactory(parserConfiguration, muleContext, testEvent, Event.builder((Event)testEvent)));
        DelegateVariableResolverFactory delegate = new DelegateVariableResolverFactory((VariableResolverFactory)staticContext, (VariableResolverFactory)new MessageVariableResolverFactory(parserConfiguration, muleContext, testEvent, Event.builder((Event)testEvent), (VariableResolverFactory)innerDelegate));
        context.setNextFactory((VariableResolverFactory)new CachedMapVariableResolverFactory(Collections.EMPTY_MAP, (VariableResolverFactory)delegate));
        return context;
    }

    protected abstract Event setVariable(Event var1, Object var2, DataType var3);
}

