/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.el.mvel.datatype;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.mvel2.MVEL;
import org.mule.mvel2.ParserContext;
import org.mule.mvel2.compiler.CompiledExpression;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.el.mvel.MVELExpressionLanguage;
import org.mule.runtime.core.el.mvel.datatype.PayloadEnricherDataTypePropagator;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.junit4.matcher.DataTypeMatcher;

public class PayloadEnricherDataTypePropagatorTestCase
extends AbstractMuleContextTestCase {
    public static final Charset CUSTOM_ENCODING = StandardCharsets.UTF_16;
    private final PayloadEnricherDataTypePropagator dataTypePropagator = new PayloadEnricherDataTypePropagator();

    @Test
    public void propagatesPayloadDataType() throws Exception {
        this.doPayloadDataTypeTest("payload = 'unused'");
    }

    @Test
    public void propagatesMessagePayloadDataType() throws Exception {
        this.doPayloadDataTypeTest("message.payload = 'unused'");
    }

    private void doPayloadDataTypeTest(String expression) throws Exception {
        DataType expectedDataType = DataType.builder().type(String.class).mediaType(MediaType.JSON).charset(CUSTOM_ENCODING).build();
        MVELExpressionLanguage expressionLanguage = new MVELExpressionLanguage(muleContext);
        CompiledExpression compiledExpression = (CompiledExpression)MVEL.compileExpression((String)expression, (ParserContext)new ParserContext(expressionLanguage.getParserConfiguration()));
        Event.Builder builder = Event.builder((Event)this.testEvent());
        this.dataTypePropagator.propagate(this.testEvent(), builder, new TypedValue((Object)"Test Message", expectedDataType), compiledExpression);
        Event event = builder.build();
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getDataType(), (Matcher)DataTypeMatcher.like(String.class, (MediaType)MediaType.JSON, (Charset)CUSTOM_ENCODING));
    }
}

