/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.el.mvel.datatype;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.mvel2.MVEL;
import org.mule.mvel2.ParserContext;
import org.mule.mvel2.compiler.CompiledExpression;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.el.mvel.MVELExpressionLanguage;
import org.mule.runtime.core.el.mvel.datatype.EnricherDataTypePropagator;
import org.mule.runtime.core.el.mvel.datatype.PropertyEnricherDataTypePropagator;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.junit4.matcher.DataTypeMatcher;

public class PropertyEnricherDataTypePropagatorTestCase
extends AbstractMuleContextTestCase {
    private static final Charset CUSTOM_ENCODING = StandardCharsets.UTF_16;
    private final EnricherDataTypePropagator dataTypePropagator = new PropertyEnricherDataTypePropagator();

    @Test
    public void propagatesDataTypeForInlinedInvocationProperty() throws Exception {
        DataType expectedDataType = DataType.builder().type(String.class).mediaType(MediaType.JSON).charset(CUSTOM_ENCODING).build();
        MVELExpressionLanguage expressionLanguage = new MVELExpressionLanguage(muleContext);
        CompiledExpression compiledExpression = (CompiledExpression)MVEL.compileExpression((String)"foo = 'unused'", (ParserContext)new ParserContext(expressionLanguage.getParserConfiguration()));
        Event testEvent = PropertyEnricherDataTypePropagatorTestCase.eventBuilder().message(Message.of((Object)"Test Message")).addVariable("foo", (Object)"bar").build();
        Event.Builder builder = Event.builder((Event)testEvent);
        this.dataTypePropagator.propagate(testEvent, builder, new TypedValue((Object)"Test Message", expectedDataType), compiledExpression);
        MatcherAssert.assertThat((Object)builder.build().getVariable("foo").getDataType(), (Matcher)DataTypeMatcher.like(String.class, (MediaType)MediaType.JSON, (Charset)CUSTOM_ENCODING));
    }

    @Test
    public void propagatesDataTypeForInlinedSessionProperty() throws Exception {
        DataType expectedDataType = DataType.builder().type(String.class).mediaType(MediaType.JSON).charset(CUSTOM_ENCODING).build();
        MVELExpressionLanguage expressionLanguage = new MVELExpressionLanguage(muleContext);
        CompiledExpression compiledExpression = (CompiledExpression)MVEL.compileExpression((String)"foo = 'unused'", (ParserContext)new ParserContext(expressionLanguage.getParserConfiguration()));
        this.testEvent().getSession().setProperty("foo", (Serializable)((Object)"bar"));
        Event.Builder builder = Event.builder((Event)this.testEvent());
        this.dataTypePropagator.propagate(this.testEvent(), builder, new TypedValue((Object)"Test Message", expectedDataType), compiledExpression);
        MatcherAssert.assertThat((Object)builder.build().getSession().getPropertyDataType("foo"), (Matcher)DataTypeMatcher.like(String.class, (MediaType)MediaType.JSON, (Charset)CUSTOM_ENCODING));
    }
}

