/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.el.mvel.datatype;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.mvel2.MVEL;
import org.mule.mvel2.ParserContext;
import org.mule.mvel2.compiler.CompiledExpression;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.el.mvel.MVELExpressionLanguage;
import org.mule.runtime.core.el.mvel.datatype.ExpressionDataTypeResolver;
import org.mule.runtime.core.el.mvel.datatype.PropertyExpressionDataTypeResolver;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.junit4.matcher.DataTypeMatcher;

public class PropertyExpressionDataTypeResolverTestCase
extends AbstractMuleContextTestCase {
    public static final String EXPRESSION_VALUE = "bar";
    public static final Charset CUSTOM_ENCODING = StandardCharsets.UTF_16;
    private final ExpressionDataTypeResolver expressionDataTypeResolver = new PropertyExpressionDataTypeResolver();

    @Test
    public void returnsInlineFlowVarDataType() throws Exception {
        String expression = "foo";
        DataType expectedDataType = DataType.builder().type(String.class).mediaType(MediaType.JSON).charset(CUSTOM_ENCODING).build();
        MVELExpressionLanguage expressionLanguage = new MVELExpressionLanguage(muleContext);
        CompiledExpression compiledExpression = (CompiledExpression)MVEL.compileExpression((String)"foo", (ParserContext)new ParserContext(expressionLanguage.getParserConfiguration()));
        Event testEvent = PropertyExpressionDataTypeResolverTestCase.eventBuilder().message(Message.of((Object)"Test Message")).addVariable("foo", (Object)EXPRESSION_VALUE, expectedDataType).build();
        MatcherAssert.assertThat((Object)this.expressionDataTypeResolver.resolve(testEvent, compiledExpression), (Matcher)DataTypeMatcher.like(String.class, (MediaType)MediaType.JSON, (Charset)CUSTOM_ENCODING));
    }

    @Test
    public void returnsInlineSessionPropertyDataType() throws Exception {
        String expression = "foo";
        DataType expectedDataType = DataType.builder().type(String.class).mediaType(MediaType.JSON).charset(CUSTOM_ENCODING).build();
        MVELExpressionLanguage expressionLanguage = new MVELExpressionLanguage(muleContext);
        CompiledExpression compiledExpression = (CompiledExpression)MVEL.compileExpression((String)"foo", (ParserContext)new ParserContext(expressionLanguage.getParserConfiguration()));
        this.testEvent().getSession().setProperty("foo", (Serializable)((Object)EXPRESSION_VALUE), expectedDataType);
        MatcherAssert.assertThat((Object)this.expressionDataTypeResolver.resolve(this.testEvent(), compiledExpression), (Matcher)DataTypeMatcher.like(String.class, (MediaType)MediaType.JSON, (Charset)CUSTOM_ENCODING));
    }
}

