/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.exception;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.core.exception.AbstractErrorTypeMatcherTestCase;
import org.mule.runtime.core.exception.DisjunctiveErrorTypeMatcher;
import org.mule.runtime.core.exception.ErrorTypeMatcher;
import org.mule.runtime.core.exception.SingleErrorTypeMatcher;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;

@Features(value={"Error Handling"})
@Stories(value={"Error Types"})
public class DisjunctiveErrorTypeMatcherTestCase
extends AbstractErrorTypeMatcherTestCase {
    @Test
    public void anyPresenceMatchAll() {
        ErrorTypeMatcher matcherWithAny = this.createMatcher(this.anyErrorType, this.transformationErrorType);
        Assert.assertThat((Object)matcherWithAny.match(this.anyErrorType), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)matcherWithAny.match(this.transformationErrorType), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)matcherWithAny.match(this.expressionErrorType), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void oneMatch() {
        ErrorType mockErrorType = (ErrorType)Mockito.mock(ErrorType.class);
        Mockito.when((Object)mockErrorType.getParentErrorType()).thenReturn((Object)this.transformationErrorType);
        ErrorTypeMatcher matcherWithTransformation = this.createMatcher(this.transformationErrorType, this.expressionErrorType);
        Assert.assertThat((Object)matcherWithTransformation.match(this.transformationErrorType), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)matcherWithTransformation.match(mockErrorType), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void allMatch() {
        ErrorType mockErrorType = (ErrorType)Mockito.mock(ErrorType.class);
        Mockito.when((Object)mockErrorType.getParentErrorType()).thenReturn((Object)this.transformationErrorType);
        ErrorTypeMatcher matcherWithTwoTransformation = this.createMatcher(this.transformationErrorType, mockErrorType);
        Assert.assertThat((Object)matcherWithTwoTransformation.match(mockErrorType), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void noMatch() {
        ErrorType mockErrorType = (ErrorType)Mockito.mock(ErrorType.class);
        Mockito.when((Object)mockErrorType.getParentErrorType()).thenReturn((Object)this.anyErrorType);
        ErrorTypeMatcher matcherWithTwoTransformation = this.createMatcher(this.transformationErrorType, this.expressionErrorType);
        Assert.assertThat((Object)matcherWithTwoTransformation.match(mockErrorType), (Matcher)Matchers.is((Object)false));
    }

    private ErrorTypeMatcher createMatcher(ErrorType ... errorTypes) {
        return new DisjunctiveErrorTypeMatcher(Arrays.stream(errorTypes).map(SingleErrorTypeMatcher::new).collect(Collectors.toList()));
    }
}

